/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.business.partnerinfo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.url.UrlService;
import kd.scmc.scmdi.marketpulse.common.PartnerInfo;
import org.apache.commons.lang3.StringUtils;

public abstract class BasePartnerInfos {
    private static List<PartnerInfo> convertToPartnerInfos(DataSet rows) {
        ArrayList<PartnerInfo> partnerInfos = new ArrayList<PartnerInfo>(10);
        while (rows.hasNext()) {
            Row next = rows.next();
            PartnerInfo partnerInfo = new PartnerInfo();
            partnerInfo.setName(next.getString("name"));
            partnerInfo.setAvatarPath(BasePartnerInfos.getAvatarPath(next.getString("picturefield")));
            partnerInfo.setPartnerType(next.getString("partnerType"));
            partnerInfo.setSocietyCreditCode(next.getString("societycreditcode"));
            partnerInfos.add(partnerInfo);
        }
        return partnerInfos;
    }

    private static String getAvatarPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return UrlService.getDomainContextUrl() + "/images/pc/emotion/default_person_82_82.png";
        }
        return UrlService.getDomainContextUrl() + path;
    }

    public List<PartnerInfo> getPartnerInfos() {
        return BasePartnerInfos.convertToPartnerInfos(this.getAllPartnerDataSet());
    }

    protected abstract DataSet getAllPartnerDataSet();
}

