/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.business.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SSLException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.scmdi.marketpulse.business.ApiClientParams;
import kd.scmc.scmdi.marketpulse.business.fetcher.CompanyByName;
import kd.scmc.scmdi.marketpulse.business.fetcher.CompanyHistoryName;
import kd.scmc.scmdi.marketpulse.common.CompanyFilterCondition;
import kd.scmc.scmdi.marketpulse.common.CompanyInfo;
import kd.scmc.scmdi.marketpulse.common.PartnerInfo;
import kd.scmc.scmdi.marketpulse.common.enums.RiskDataFetcherEnum;
import kd.scmc.scmdi.marketpulse.common.vo.BaseInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyBusinessInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyBusinessInfoItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CompanyInfosService {
    private static final Log LOG = LogFactory.getLog(CompanyInfosService.class);
    public static final int COMPANY_INFOS_SIZE = 10;
    public static final int MAX_SECONDS = 10;
    private CompanyFilterCondition filterCondition;
    public static final String DATA_SOURCE_NAME = "daas";

    public CompanyFilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setCompanyFilterCondition(CompanyFilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    public CompanyInfosService(CompanyFilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    public CompanyInfosService() {
    }

    public List<CompanyInfo> getBatchCompanyInfos(IFormView view) {
        ApiClientParams apiClientParams = new ApiClientParams();
        List<CompanyInfo> companyInfosResult = CompanyInfosService.initCompanyInfos(view);
        int partnerInfosSize = this.filterCondition.getPartners().size();
        long startTime = System.currentTimeMillis();
        long remainingTime = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
        while (this.filterCondition.getStartIndex() < partnerInfosSize && companyInfosResult.size() < 10) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime > remainingTime) {
                ObjectMapper objectMapper = new ObjectMapper();
                CompanyInfosService.cacheCompanyInfos(view, companyInfosResult, objectMapper);
                HashMap<Integer, String> buttonNames = new HashMap<Integer, String>(1);
                buttonNames.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u52a0\u8f7d", (String)"CompanyInfosService_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
                String msg = String.format(ResManager.loadKDString((String)"\u8d85\u65f6\u63d0\u793a\uff0c\u662f\u5426\u7ee7\u7eed\u52a0\u8f7d\uff0c\u603b\u5171\u83b7\u53d6\u6761\u6570\uff1a%1$s\uff0c\u5df2\u67e5\u627e\u6761\u6570\uff1a%2$s\u3002", (String)"CompanyInfosService_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), companyInfosResult.size(), this.filterCondition.getStartIndex());
                view.showConfirm(msg, (String)null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isContinueLoading"), buttonNames);
                break;
            }
            List<CompanyInfo> companyInfos = this.getCompanyInfos(apiClientParams);
            if (companyInfos != null) {
                companyInfosResult.addAll(companyInfos);
            }
            this.filterCondition.setStartIndex(Math.min(this.filterCondition.getStartIndex() + this.filterCondition.getPageSize(), partnerInfosSize));
        }
        return this.fixedSizeCompanyInfos(companyInfosResult);
    }

    public List<CompanyInfo> fixedSizeCompanyInfos(List<CompanyInfo> companyInfos) {
        if (companyInfos.size() > 10) {
            List<CompanyInfo> fixSizeCompanyInfos = companyInfos.subList(0, 10);
            CompanyInfo companyInfo = fixSizeCompanyInfos.get(9);
            List<PartnerInfo> partnerInfos = this.filterCondition.getPartners().subList(this.getLastedStartIndex() - this.filterCondition.getPageSize(), this.getLastedStartIndex());
            OptionalInt index = IntStream.range(0, partnerInfos.size()).filter(i -> ((PartnerInfo)partnerInfos.get(i)).getName().equals(companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyName())).findFirst();
            if (index.isPresent()) {
                this.filterCondition.setStartIndex(this.filterCondition.getStartIndex() - this.filterCondition.getPageSize() + index.getAsInt() + 1);
            }
            return fixSizeCompanyInfos;
        }
        return companyInfos;
    }

    private static void cacheCompanyInfos(IFormView view, List<CompanyInfo> companyInfosResult, ObjectMapper objectMapper) {
        try {
            String partCompanyInfos = objectMapper.writeValueAsString(companyInfosResult);
            view.getPageCache().put("lastLoadingData", partCompanyInfos);
        }
        catch (JsonProcessingException e) {
            LOG.error(e.getCause());
            throw new KDBizException(e.getCause().getMessage());
        }
    }

    private static List<CompanyInfo> initCompanyInfos(IFormView view) {
        String partCompanyInfos = view.getPageCache().get("lastLoadingData");
        if (StringUtils.isNotBlank((CharSequence)partCompanyInfos)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, CompanyInfo.class);
                List companyInfos = (List)objectMapper.readValue(partCompanyInfos, (JavaType)type);
                return companyInfos;
            }
            catch (JsonProcessingException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return new ArrayList<CompanyInfo>(10);
    }

    public CompanyInfo getSingleCompanyInfos(PartnerInfo partnerInfo) {
        CompanyInfo companyInfo = null;
        CompletableFuture<CompanyInfo> completableFuture = CompanyInfosService.getCompanyInfoCompletableFuture(new ApiClientParams(), partnerInfo);
        try {
            companyInfo = completableFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.handleException(e);
        }
        return companyInfo;
    }

    public int getLastedStartIndex() {
        return this.filterCondition.getStartIndex();
    }

    public List<CompanyInfo> getCompanyInfos(ApiClientParams apiClientParams) {
        List<PartnerInfo> partners = this.getFilterCondition().getPartners();
        int startIndex = this.filterCondition.getStartIndex();
        int pageIndex = this.filterCondition.getStartIndex() + this.filterCondition.getPageSize();
        int endIndex = Math.min(partners.size(), pageIndex);
        List<PartnerInfo> partnerInfos = partners.subList(startIndex, endIndex);
        ArrayList completableFutures = new ArrayList(10);
        partnerInfos.forEach(partnerInfo -> {
            CompletableFuture<CompanyInfo> completableFuture = CompanyInfosService.getCompanyInfoCompletableFuture(apiClientParams, partnerInfo);
            completableFutures.add(completableFuture);
        });
        List<CompanyInfo> companyInfos = completableFutures.stream().map(companyInfoCompletableFuture -> {
            try {
                return (CompanyInfo)companyInfoCompletableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return this.getCleanedCompanyInfos(partners, companyInfos);
    }

    private void handleException(Throwable throwable) {
        if (throwable instanceof SSLException) {
            String readTimeOutMessage = ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"CompanyInfosService_2", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            throw new KDBizException(readTimeOutMessage);
        }
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            LOG.error("completableFutures execution exception:", throwable.getCause());
        } else if (throwable.getCause() != null) {
            this.handleException(throwable.getCause());
        }
    }

    private static CompletableFuture<CompanyInfo> getCompanyInfoCompletableFuture(ApiClientParams apiClientParams, PartnerInfo partnerInfo) {
        CompanyInfo companyInfo = new CompanyInfo();
        companyInfo.setDataSource(DATA_SOURCE_NAME);
        companyInfo.setAvatarPath(partnerInfo.getAvatarPath());
        companyInfo.setPartnerType(partnerInfo.getPartnerType());
        CompletionStage completableFuture = new CompanyByName(partnerInfo).fetchHandleEx(apiClientParams, companyInfo).thenApplyAsync(item -> {
            if (CollectionUtils.isEmpty(companyInfo.getBusinessInfo().getBaseData())) {
                return companyInfo;
            }
            CompanyInfosService.setCompanyBusinessInfoItem(companyInfo.getBusinessInfo(), partnerInfo);
            if (partnerInfo.getCompanyId() == null) {
                String companyId = companyInfo.getBusinessInfo().getBusinessInfoItem() != null ? companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyId() : "";
                partnerInfo.setCompanyId(companyId);
            }
            CompletableFuture<Void> companyHistoryNameFuture = new CompanyHistoryName(partnerInfo).fetchHandleEx(apiClientParams, companyInfo);
            List<CompletableFuture> companyInfoFetchers = Arrays.stream(RiskDataFetcherEnum.values()).map(riskDataFetcherEnum -> riskDataFetcherEnum.getFetcher(partnerInfo).fetchHandleEx(apiClientParams, companyInfo)).filter(Objects::nonNull).collect(Collectors.toList());
            companyInfoFetchers.add(companyHistoryNameFuture);
            CompletionStage companyInfoCompletableFuture = CompletableFuture.allOf(companyInfoFetchers.toArray(new CompletableFuture[0])).thenApplyAsync(unused -> companyInfo);
            return (CompanyInfo)((CompletableFuture)companyInfoCompletableFuture).join();
        });
        return completableFuture;
    }

    private static void setCompanyBusinessInfoItem(CompanyBusinessInfo companyBusinessInfo, PartnerInfo partnerInfo) {
        if (StringUtils.isNotBlank((CharSequence)partnerInfo.getCompanyId())) {
            companyBusinessInfo.getBaseData().stream().filter(data -> partnerInfo.getCompanyId().equals(data.getCompanyId())).findFirst().ifPresent(companyBusinessInfo::setCompanyBusinessInfoItem);
        }
        if (companyBusinessInfo.getBusinessInfoItem() == null && StringUtils.isNotBlank((CharSequence)partnerInfo.getSocietyCreditCode())) {
            companyBusinessInfo.getBaseData().stream().filter(data -> partnerInfo.getSocietyCreditCode().equals(data.getCreditNo())).findFirst().ifPresent(companyBusinessInfo::setCompanyBusinessInfoItem);
        }
        if (companyBusinessInfo.getBusinessInfoItem() == null) {
            companyBusinessInfo.setCompanyBusinessInfoItem((CompanyBusinessInfoItem)companyBusinessInfo.getBaseData().get(0));
        }
    }

    public List<CompanyInfo> getCleanedCompanyInfos(List<PartnerInfo> partnerInfos, List<CompanyInfo> companyInfos) {
        List<CompanyInfo> dataRemoveWithoutRisk = companyInfos.stream().filter(companyInfo -> Arrays.stream(this.getFilterCondition().getRiskItems()).anyMatch(risItem -> companyInfo.getRiskInfos().stream().anyMatch(riskInfo -> risItem.equals(riskInfo.getDataType()) && riskInfo.getBaseData().size() > 0))).collect(Collectors.toList());
        this.sortCompanyInfo(partnerInfos, dataRemoveWithoutRisk);
        CompanyInfosService.sortRiskInfos(dataRemoveWithoutRisk);
        return dataRemoveWithoutRisk;
    }

    private static void sortRiskInfos(List<CompanyInfo> companyInfos) {
        List riskTypes = Arrays.stream(RiskDataFetcherEnum.values()).map(RiskDataFetcherEnum::getDataType).collect(Collectors.toList());
        companyInfos.forEach(companyInfo -> {
            List<BaseInfo<?>> riskInfos = companyInfo.getRiskInfos();
            if (CollectionUtils.isNotEmpty(riskInfos)) {
                riskInfos.sort(Comparator.comparingInt(previous -> riskTypes.indexOf(previous.getDataType())));
            }
        });
    }

    public void sortCompanyInfo(List<PartnerInfo> partnerInfos, List<CompanyInfo> companyInfos) {
        if (CollectionUtils.isNotEmpty(partnerInfos) && CollectionUtils.isNotEmpty(companyInfos)) {
            companyInfos.sort((previous, last) -> {
                PartnerInfo previousCompanyInfo = partnerInfos.stream().filter(item -> previous.getBusinessInfo().getBusinessInfoItem().getCompanyName().equals(item.getName())).findAny().orElse(null);
                PartnerInfo lastCompanyInfo = partnerInfos.stream().filter(item -> last.getBusinessInfo().getBusinessInfoItem().getCompanyName().equals(item.getName())).findAny().orElse(null);
                return partnerInfos.indexOf(previousCompanyInfo) - partnerInfos.indexOf(lastCompanyInfo);
            });
        }
    }
}

