/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.scmdi.marketpulse.common.vo.BaseInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyBusinessInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyHistoryNameInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompanyInfo {
    List<BaseInfo<?>> riskInfos = new ArrayList(10);
    String dataSource;
    String partnerType;
    CompanyBusinessInfo businessInfo;
    CompanyHistoryNameInfo historyNameInfo;
    String avatarPath;

    public CompanyBusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    public void setBusinessInfo(CompanyBusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    public CompanyHistoryNameInfo getHistoryNameInfo() {
        return this.historyNameInfo;
    }

    public void setHistoryNameInfo(CompanyHistoryNameInfo historyNameInfo) {
        this.historyNameInfo = historyNameInfo;
    }

    public String getPartnerType() {
        return this.partnerType;
    }

    public void setPartnerType(String partnerType) {
        this.partnerType = partnerType;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getRiskText(String[] status) {
        StringBuilder riskTextBuilder = new StringBuilder("\u5176\u4e2d\uff1a");
        Arrays.stream(status).forEach(item -> this.getRiskInfos().stream().filter(riskInfo -> riskInfo.getDataType().equals(item)).findAny().ifPresent(riskInfo -> riskTextBuilder.append(riskInfo.getDataType()).append(String.format(ResManager.loadKDString((String)"%s\u6761", (String)"CompanyInfo_1", (String)"scmc-scmdi-marketpulse", (Object[])new Object[0]), riskInfo.getBaseData().size())).append(" | ")));
        return riskTextBuilder.substring(0, riskTextBuilder.length() - 3);
    }

    public Integer getRiskTotalNumber() {
        return this.riskInfos.stream().mapToInt(riskInfo -> riskInfo.getBaseData().size()).sum();
    }

    public List<BaseInfo<?>> getRiskInfos() {
        return this.riskInfos;
    }

    public void addRiskInfo(BaseInfo<?> riskInfo) {
        this.riskInfos.add(riskInfo);
    }

    public <T extends BaseInfo<?>> T getRiskInfoByRiskType(String riskType) {
        BaseInfo iRiskInfo = this.riskInfos.stream().filter(riskInfo -> riskType.equals(riskInfo.getDataType())).findFirst().orElse(null);
        return (T)iRiskInfo;
    }

    public void setRiskInfos(List<BaseInfo<?>> riskInfos) {
        this.riskInfos = riskInfos;
    }

    public String getAvatarPath() {
        return this.avatarPath;
    }

    public void setAvatarPath(String avatarPath) {
        this.avatarPath = avatarPath;
    }
}

