/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.common.enums;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.scmc.scmdi.marketpulse.business.partnerinfo.BasePartnerInfos;
import kd.scmc.scmdi.marketpulse.business.partnerinfo.CustomAndSupplierInfos;
import kd.scmc.scmdi.marketpulse.business.partnerinfo.CustomInfos;
import kd.scmc.scmdi.marketpulse.business.partnerinfo.SupplierInfos;
import org.apache.commons.lang.StringUtils;

public enum PartnerEnum {
    Supplier(SupplierInfos::new, new String[]{"\u4f9b\u5e94\u5546"}),
    Custom(CustomInfos::new, new String[]{"\u5ba2\u6237"}),
    CustomAndSupplier(CustomAndSupplierInfos::new, new String[]{"\u4f9b\u5e94\u5546", "\u5ba2\u6237"});

    private final Supplier<BasePartnerInfos> partnerInfosSupplier;
    private final String[] partnerTypes;

    public BasePartnerInfos getPartnerInfosSupplier() {
        return this.partnerInfosSupplier.get();
    }

    public String[] getPartnerTypes() {
        return this.partnerTypes;
    }

    private PartnerEnum(Supplier<BasePartnerInfos> partnerInfosSupplier, String[] partnerTypes) {
        this.partnerInfosSupplier = partnerInfosSupplier;
        this.partnerTypes = partnerTypes;
    }

    public static PartnerEnum getByPartnerTypes(String[] partnerTypes) {
        Set<String> codeSet = PartnerEnum.convertArrayToSet(partnerTypes);
        Optional<PartnerEnum> partnerEnum = Arrays.stream(PartnerEnum.values()).filter(partner -> codeSet.equals(PartnerEnum.convertArrayToSet(partner.getPartnerTypes()))).findFirst();
        if (partnerEnum.isPresent()) {
            return partnerEnum.get();
        }
        String message = ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u8be5\u4f01\u4e1a\u7c7b\u578b\u8fc7\u6ee4\u3002", (String)"PartnerEnum_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        throw new KDBizException(message);
    }

    public static Set<String> convertArrayToSet(String[] codes) {
        return Arrays.stream(codes).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(HashSet::new));
    }
}

