/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.plugin.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.marketpulse.business.service.CompanyInfosService;
import kd.scmc.scmdi.marketpulse.common.CompanyInfo;
import kd.scmc.scmdi.marketpulse.common.PartnerInfo;
import kd.scmc.scmdi.marketpulse.common.enums.RiskDataFetcherEnum;
import kd.scmc.scmdi.marketpulse.common.vo.BaseInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyAbnormalInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyChattelInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyIllegalInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyPledgeInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyPunishInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanySimpleCancelInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyAbnormalItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyChattelInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyHistoryNameInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyIllegalInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyPledgeInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanyPunishInfoItem;
import kd.scmc.scmdi.marketpulse.common.vo.info.item.CompanySimpleCancelInfoItem;
import org.apache.commons.collections.CollectionUtils;

public class BusinessInfoDetailPlugin
extends AbstractFormPlugin
implements TipsListener {
    public static final String COMPANYNAME = "companyname";
    public static final String ABNORMAL_ENTRYENTITY = "abnormal_entryentity";
    public static final String COMPANY_ID = "company_id";
    public static final String ABNORMAL_ID = "abnormal_id";
    public static final String SCMDI_ABNORMAL_DETAIL = "scmdi_abnormal_detail";
    public static final String CHATTEL_ENTRYENTITY = "chattel_entryentity";
    public static final String SCMDI_CHATTEL_DETAIL = "scmdi_chattel_detail";
    public static final String CHATTEL_ID = "chattel_id";
    public static final String ILLEGAL_ENTRYENTITY = "illegal_entryentity";
    public static final String ILLEGAL_ID = "illegal_id";
    public static final String SCMDI_ILLEGAL_DETAIL = "scmdi_illegal_detail";
    public static final String PLEDGE_ENTRYENTITY = "pledge_entryentity";
    public static final String PLEDGE_ID = "pledge_id";
    public static final String SCMDI_PLEDGE_DETAIL = "scmdi_pledge_detail";
    public static final String PUNISH_ENTRYNETITY = "punish_entrynetity";
    public static final String PUNISH_ID = "punish_id";
    public static final String SCMDI_PUNISH_DETAIL = "scmdi_punish_detail";
    public static final String SIMPLE_CANCEL_ENTRYENTITY = "simple_cancel_entryentity";
    public static final String SIMPLE_CANCEL_ID = "simple_cancel_id";
    public static final String SCMDI_SIMPLE_CANCEL_DETAI = "scmdi_simple_cancel_detai";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label label = (Label)this.getControl("historyname");
        label.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("partnerInfo");
        PartnerInfo partnerInfo = (PartnerInfo)jsonObject.toJavaObject((TypeReference)new TypeReference<PartnerInfo>(){});
        if (partnerInfo == null) {
            return;
        }
        CompanyInfo companyInfo = new CompanyInfosService().getSingleCompanyInfos(partnerInfo);
        this.initData(companyInfo);
        this.buildStatisticChart(companyInfo);
    }

    private void initData(CompanyInfo companyInfo) {
        IDataModel model = this.getView().getModel();
        String companyName = companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyName();
        model.setValue(COMPANYNAME, (Object)companyName);
        String partnerType = companyInfo.getPartnerType();
        model.setValue("partner_type", (Object)partnerType);
        String companyStatus = companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyStatus();
        model.setValue("company_status", (Object)companyStatus);
        this.setHistoryName(companyInfo);
        model.setValue(COMPANY_ID, (Object)companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyId());
        this.initRiskCountEntry(companyInfo);
        this.getModel().setValue("update_time", (Object)companyInfo.getBusinessInfo().getBusinessInfoItem().getUpdateTime());
        this.getModel().setValue("datasource", (Object)companyInfo.getDataSource());
        CompanyAbnormalInfo companyAbnormalInfo = (CompanyAbnormalInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_ABNORMAL.getDataType());
        this.initAbnormalEntry(model, companyAbnormalInfo);
        CompanyIllegalInfo companyIllegalInfo = (CompanyIllegalInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_ILLEGAL.getDataType());
        this.initIllegalEntry(companyIllegalInfo);
        CompanyChattelInfo companyChattelInfo = (CompanyChattelInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_CHATTEL.getDataType());
        this.initChattelEntry(companyChattelInfo);
        CompanyPledgeInfo companyPledgeInfo = (CompanyPledgeInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_PLEDGE.getDataType());
        this.initPledgeEntry(companyPledgeInfo);
        CompanyPunishInfo companyPunishInfo = (CompanyPunishInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_PUNISH.getDataType());
        this.initPunishEntry(companyPunishInfo);
        CompanySimpleCancelInfo companySimpleCancelInfo = (CompanySimpleCancelInfo)companyInfo.getRiskInfoByRiskType(RiskDataFetcherEnum.COMPANY_SIMPLE_CANCEL.getDataType());
        this.initSimpleCancelEntry(companySimpleCancelInfo);
    }

    private void initRiskCountEntry(CompanyInfo companyInfo) {
        List<BaseInfo<?>> riskInfos = companyInfo.getRiskInfos();
        if (CollectionUtils.isEmpty(riskInfos)) {
            return;
        }
        BusinessInfoDetailPlugin.sortRiskInfos(riskInfos);
        this.getModel().batchCreateNewEntryRow("risk_count_entry", riskInfos.size());
        this.getModel().endInit();
        for (int i = 0; i < riskInfos.size(); ++i) {
            int count = riskInfos.get(i).getBaseData().size();
            this.getModel().setValue("count", (Object)count, i);
            this.getModel().setValue("risk_type", (Object)riskInfos.get(i).getDataType(), i);
        }
        this.getModel().endInit();
    }

    private static void sortRiskInfos(List<BaseInfo<?>> riskInfos) {
        if (CollectionUtils.isNotEmpty(riskInfos)) {
            riskInfos.sort((previous, last) -> {
                List riskTypes = Arrays.stream(RiskDataFetcherEnum.values()).map(RiskDataFetcherEnum::getDataType).collect(Collectors.toList());
                return riskTypes.indexOf(previous.getDataType()) - riskTypes.indexOf(last.getDataType());
            });
        }
    }

    private void buildStatisticChart(CompanyInfo companyInfo) {
        Map<String, Integer> riskTotalCountMap = companyInfo.getRiskInfos().stream().collect(Collectors.groupingBy(BaseInfo::getDataType, Collectors.summingInt(risk -> risk.getBaseData().size())));
        Control pieChartAp = this.getView().getControl("riskpie");
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        pieChart.setShowLegend(true);
        pieChart.setLegendVertical(true);
        pieChart.setLegendAlign(XAlign.right, YAlign.center);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("triggerOn", (Object)"click");
        PieSeries series = pieChart.createSeries("");
        riskTotalCountMap.forEach((k, v) -> series.addData(k, (Number)(v == 0 ? null : v), null));
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(true);
        label.setPosition(Position.right);
        label.setFormatter("{b} : {c}  ({d}%)");
        series.setLabel(label);
        this.getView().updateView("statistic_chart");
    }

    private void setHistoryName(CompanyInfo companyInfo) {
        Set historyNames = companyInfo.getHistoryNameInfo().getBaseData().stream().map(CompanyHistoryNameInfoItem::getHistoryName).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(historyNames)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"historynameflex"});
            return;
        }
        this.getPageCache().put("historyNames", JSON.toJSONString(historyNames));
    }

    public void initAbnormalEntry(IDataModel model, CompanyAbnormalInfo companyAbnormalInfo) {
        List companyAbnormalItems = companyAbnormalInfo.getBaseData();
        this.updateControlTitle(companyAbnormalItems, ABNORMAL_ENTRYENTITY);
        if (CollectionUtils.isEmpty(companyAbnormalItems)) {
            return;
        }
        model.batchCreateNewEntryRow(ABNORMAL_ENTRYENTITY, companyAbnormalItems.size());
        for (int i = 0; i < companyAbnormalItems.size(); ++i) {
            model.setValue(ABNORMAL_ID, (Object)((CompanyAbnormalItem)companyAbnormalItems.get(i)).getId(), i);
            String includedDate = ((CompanyAbnormalItem)companyAbnormalItems.get(i)).getIncludedDate();
            model.setValue("abnormal_inclu_date", (Object)includedDate, i);
            model.setValue("abnormal_inclu_authority", (Object)((CompanyAbnormalItem)companyAbnormalItems.get(i)).getIncludedAuthority(), i);
            model.setValue("abnormal_inclu_reason", (Object)((CompanyAbnormalItem)companyAbnormalItems.get(0)).getIncludedReason(), i);
            String removedDate = ((CompanyAbnormalItem)companyAbnormalItems.get(i)).getRemovedDate();
            model.setValue("abnormal_remov_date", (Object)removedDate, i);
            String removedReason = ((CompanyAbnormalItem)companyAbnormalItems.get(i)).getRemovedReason();
            model.setValue("abnormal_remov_reason", (Object)removedReason, i);
            String removedAuthority = ((CompanyAbnormalItem)companyAbnormalItems.get(i)).getRemovedAuthority();
            model.setValue("abnormal_remov_authority", (Object)removedAuthority, i);
        }
        this.getView().updateView(ABNORMAL_ENTRYENTITY);
    }

    public void initIllegalEntry(CompanyIllegalInfo companyIllegalInfo) {
        IDataModel model = this.getModel();
        List baseData = companyIllegalInfo.getBaseData();
        this.updateControlTitle(baseData, ILLEGAL_ENTRYENTITY);
        if (CollectionUtils.isEmpty(baseData)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ILLEGAL_ENTRYENTITY, baseData.size());
        for (int i = 0; i < baseData.size(); ++i) {
            model.setValue(ILLEGAL_ID, (Object)((CompanyIllegalInfoItem)baseData.get(i)).getId(), i);
            String includedDate = ((CompanyIllegalInfoItem)baseData.get(i)).getIncludedDate();
            model.setValue("illegal_inclu_date", (Object)includedDate, i);
            String includedAuthority = ((CompanyIllegalInfoItem)baseData.get(i)).getIncludedAuthority();
            model.setValue("illegal_inclu_authority", (Object)includedAuthority, i);
            String includedReason = ((CompanyIllegalInfoItem)baseData.get(i)).getIncludedReason();
            model.setValue("illegal_inclu_reason", (Object)includedReason, i);
            String removedDate = ((CompanyIllegalInfoItem)baseData.get(i)).getRemovedDate();
            model.setValue("illegal_remov_date", (Object)removedDate, i);
            String removedReason = ((CompanyIllegalInfoItem)baseData.get(i)).getRemovedReason();
            model.setValue("illegal_remov_reason", (Object)removedReason, i);
            String removedAuthority = ((CompanyIllegalInfoItem)baseData.get(i)).getRemovedAuthority();
            model.setValue("illegal_remov_authority", (Object)removedAuthority, i);
        }
        this.getView().updateView(ILLEGAL_ENTRYENTITY);
    }

    private void updateControlTitle(List<?> baseData, String entryKey) {
        if (baseData == null || baseData.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{entryKey});
            return;
        }
        HashMap<String, String> text = new HashMap<String, String>(1);
        String localeValue = ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)entryKey)).getDisplayName().getLocaleValue();
        HashMap<String, HashMap<String, String>> updateTitleCommand = new HashMap<String, HashMap<String, String>>(1);
        text.put(RequestContext.get().getLang().name(), localeValue + "\uff08" + baseData.size() + "\uff09");
        updateTitleCommand.put("text", text);
        this.getView().updateControlMetadata(entryKey, updateTitleCommand);
    }

    private void initChattelEntry(CompanyChattelInfo companyChattelInfo) {
        IDataModel model = this.getModel();
        List baseData = companyChattelInfo.getBaseData();
        this.updateControlTitle(baseData, CHATTEL_ENTRYENTITY);
        if (CollectionUtils.isEmpty(baseData)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(CHATTEL_ENTRYENTITY, baseData.size());
        for (int i = 0; i < baseData.size(); ++i) {
            String chattelCode = ((CompanyChattelInfoItem)baseData.get(i)).getChattelCode();
            model.setValue("chattel_code", (Object)chattelCode, i);
            String chattelDate = ((CompanyChattelInfoItem)baseData.get(i)).getChattelDate();
            model.setValue("chattel_date", (Object)chattelDate, i);
            String authority = ((CompanyChattelInfoItem)baseData.get(i)).getAuthority();
            model.setValue("chattel_authority", (Object)authority, i);
            String debType = ((CompanyChattelInfoItem)baseData.get(i)).getDebType();
            model.setValue("chattel_debt_type", (Object)debType, i);
            String debtAmount = ((CompanyChattelInfoItem)baseData.get(i)).getDebtAmount();
            model.setValue("chattel_debt_amount", (Object)debtAmount, i);
            String guaranteeScope = ((CompanyChattelInfoItem)baseData.get(i)).getGuaranteeScope();
            model.setValue("chattel_guarantee_scope", (Object)guaranteeScope, i);
            model.setValue(CHATTEL_ID, (Object)((CompanyChattelInfoItem)baseData.get(i)).getId(), i);
        }
        this.getView().updateView(CHATTEL_ENTRYENTITY);
    }

    private void initPledgeEntry(CompanyPledgeInfo companyPledgeInfo) {
        IDataModel model = this.getModel();
        List baseData = companyPledgeInfo.getBaseData();
        this.updateControlTitle(baseData, PLEDGE_ENTRYENTITY);
        if (CollectionUtils.isEmpty(baseData)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(PLEDGE_ENTRYENTITY, baseData.size());
        for (int i = 0; i < baseData.size(); ++i) {
            model.setValue(PLEDGE_ID, (Object)((CompanyPledgeInfoItem)baseData.get(i)).getId(), i);
            String publicDate = ((CompanyPledgeInfoItem)baseData.get(i)).getPublicDate();
            model.setValue("pledge_public_date", (Object)publicDate, i);
            String pledgor = ((CompanyPledgeInfoItem)baseData.get(i)).getPledgor();
            model.setValue("pledge_pledgor", (Object)pledgor, i);
            String pawnee = ((CompanyPledgeInfoItem)baseData.get(i)).getPawnee();
            model.setValue("pledge_pawnee", (Object)pawnee, i);
            String pledgeStatus = ((CompanyPledgeInfoItem)baseData.get(i)).getPledgeStatus();
            model.setValue("pledge_status", (Object)pledgeStatus, i);
            String pledgeEquity = ((CompanyPledgeInfoItem)baseData.get(i)).getPledgeEquity();
            model.setValue("pledge_equity", (Object)pledgeEquity, i);
            String pledgeDate = ((CompanyPledgeInfoItem)baseData.get(i)).getPledgeDate();
            model.setValue("pledge_date", (Object)pledgeDate, i);
        }
        this.getView().updateView(PLEDGE_ENTRYENTITY);
    }

    private void initPunishEntry(CompanyPunishInfo companyPunishInfo) {
        IDataModel model = this.getModel();
        List baseData = companyPunishInfo.getBaseData();
        this.updateControlTitle(baseData, PUNISH_ENTRYNETITY);
        if (CollectionUtils.isEmpty(baseData)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(PUNISH_ENTRYNETITY, baseData.size());
        for (int i = 0; i < baseData.size(); ++i) {
            model.setValue(PUNISH_ID, (Object)((CompanyPunishInfoItem)baseData.get(i)).getId(), i);
            String punishDate = ((CompanyPunishInfoItem)baseData.get(i)).getPunishDate();
            model.setValue("punish_date", (Object)punishDate, i);
            String punishCode = ((CompanyPunishInfoItem)baseData.get(i)).getPunishCode();
            model.setValue("punish_code", (Object)punishCode, i);
            String illegalType = ((CompanyPunishInfoItem)baseData.get(i)).getIllegalType();
            model.setValue("illegal_type", (Object)illegalType, i);
            String punishContent = ((CompanyPunishInfoItem)baseData.get(i)).getPunishContent();
            model.setValue("punish_content", punishContent != null ? punishContent.replaceAll("\n", "") : null, i);
            String authority = ((CompanyPunishInfoItem)baseData.get(i)).getAuthority();
            model.setValue("punish_authority", (Object)authority, i);
            String publicDate = ((CompanyPunishInfoItem)baseData.get(i)).getPublicDate();
            model.setValue("punish_public_date", (Object)publicDate, i);
        }
        this.getView().updateView(PUNISH_ENTRYNETITY);
    }

    private void initSimpleCancelEntry(CompanySimpleCancelInfo companySimpleCancelInfo) {
        IDataModel model = this.getModel();
        List baseData = companySimpleCancelInfo.getBaseData();
        this.updateControlTitle(baseData, SIMPLE_CANCEL_ENTRYENTITY);
        if (CollectionUtils.isEmpty(baseData)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(SIMPLE_CANCEL_ENTRYENTITY, baseData.size());
        for (int i = 0; i < baseData.size(); ++i) {
            model.setValue(SIMPLE_CANCEL_ID, (Object)((CompanySimpleCancelInfoItem)baseData.get(i)).getId(), i);
            String simpleCancelTitle = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelTitle();
            model.setValue("simple_cancel_title", (Object)simpleCancelTitle, i);
            String simpleCancelStartDate = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelStartDate();
            model.setValue("simple_cancel_startdate", (Object)simpleCancelStartDate, i);
            String simpleCancelEndDate = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelEndDate();
            model.setValue("simple_cancel_enddate", (Object)simpleCancelEndDate, i);
            String simpleCancelCompanyName = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelCompanyName();
            model.setValue("simple_cancel_company_nam", (Object)simpleCancelCompanyName, i);
            String simpleCancelCompanyCode = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelCompanyCode();
            model.setValue("simplecancel_company_code", (Object)simpleCancelCompanyCode, i);
            String simpleCancelCreditNo = ((CompanySimpleCancelInfoItem)baseData.get(i)).getSimpleCancelCreditNo();
            model.setValue("simple_cancel_credit_no", (Object)simpleCancelCreditNo, i);
        }
        this.getView().updateView(SIMPLE_CANCEL_ENTRYENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey;
        super.afterDoOperation(eventArgs);
        switch (operateKey = eventArgs.getOperateKey()) {
            case "abnormal_detail_op": {
                this.goToView(ABNORMAL_ENTRYENTITY, ABNORMAL_ID, SCMDI_ABNORMAL_DETAIL);
                break;
            }
            case "chattel_detail_op": {
                this.goToView(CHATTEL_ENTRYENTITY, CHATTEL_ID, SCMDI_CHATTEL_DETAIL);
                break;
            }
            case "illegal_detail_op": {
                this.goToView(ILLEGAL_ENTRYENTITY, ILLEGAL_ID, SCMDI_ILLEGAL_DETAIL);
                break;
            }
            case "pledge_detail_op": {
                this.goToView(PLEDGE_ENTRYENTITY, PLEDGE_ID, SCMDI_PLEDGE_DETAIL);
                break;
            }
            case "punish_detail_op": {
                this.goToView(PUNISH_ENTRYNETITY, PUNISH_ID, SCMDI_PUNISH_DETAIL);
                break;
            }
            case "simple_detail_op": {
                this.goToView(SIMPLE_CANCEL_ENTRYENTITY, SIMPLE_CANCEL_ID, SCMDI_SIMPLE_CANCEL_DETAI);
                break;
            }
        }
    }

    public void goToView(String entryEntity, String riskItemId, String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        int index = this.getModel().getEntryCurrentRowIndex(entryEntity);
        formShowParameter.setCustomParam(COMPANY_ID, this.getModel().getValue(COMPANY_ID));
        formShowParameter.setCustomParam(riskItemId, this.getModel().getValue(riskItemId, index));
        formShowParameter.setFormId(formId);
        String displayName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
        formShowParameter.setCaption(this.getModel().getValue(COMPANYNAME) + "-" + displayName);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void beforeShowTips(BeforeShowTipsEvent event) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("historyNames", (Object)this.getPageCache().get("historyNames"));
        event.setFormshowParameter(showParameter);
    }

    public void afterShowTips(AfterShowTipsEvent event) {
    }
}

