/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.marketpulse.plugin.form;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.util.StringUtil;
import kd.scmc.scmdi.marketpulse.business.helper.EntityCacheHelper;
import kd.scmc.scmdi.marketpulse.business.service.CompanyInfosService;
import kd.scmc.scmdi.marketpulse.common.CompanyFilterCondition;
import kd.scmc.scmdi.marketpulse.common.CompanyInfo;
import kd.scmc.scmdi.marketpulse.common.PartnerInfo;
import kd.scmc.scmdi.marketpulse.common.enums.PartnerEnum;
import kd.scmc.scmdi.marketpulse.common.enums.RiskDataFetcherEnum;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyBusinessInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyHistoryNameInfo;
import org.apache.commons.collections.CollectionUtils;

public class BusinessInfoListPlugin
extends AbstractFormPlugin {
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String COMPANY_NAME_FILTER = "company_name_filter";
    public static final String RISK_ITEMS_FILTER = "risk_items_filter";
    public static final String PARTNER_TYPE_FILTER = "partner_type_filter";
    public static final String COMPANY_NAME = "company_name";
    public static final String CREDIT_NO = "credit_no";
    public static final String PARTNER_TYPE = "partner_type";
    public static final String PAGE_NUM = "pageNum";
    public static final String START_INDEX = "startIndex";
    public static final String GOBACK = "goback";
    public static final String GOTO = "goto";
    public static final String LAST_LOADING_DATA = "lastLoadingData";
    public static final String IS_CONTINUE_LOADING = "isContinueLoading";
    public static final String TOTAL_COUNT = "totalcount";
    public static final String PAGE_SIZE_KEY = "page_size";
    public static final String SCMDI_BUSINESSINFO_DETAIL = "scmdi_businessinfo_detail";
    public static final String DETAIL = "detail";
    public static final String HISTORYNAME = "historyname";
    public static final String EXSIT_HISTORYNAME = "exsit_historyname";
    public static final String COMPANY_ID = "company_id";
    public static final String PAGE_ID_RELATION = "pageIdRelation";
    public static final String DETAIL_VECTORAP = "detail_vectorap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        CompanyFilterCondition companyFilterCondition = this.initCompanyFilterCondition();
        this.initFilterControl(companyFilterCondition);
        this.setTotalCount(companyFilterCondition.getPartners().size());
        CompanyInfosService companyInfosService = new CompanyInfosService(companyFilterCondition);
        List<CompanyInfo> companyInfos = companyInfosService.getBatchCompanyInfos(this.getView());
        int lastedStartIndex = companyInfosService.getLastedStartIndex();
        this.setStartLoadDataIndex(lastedStartIndex);
        this.setEntryValue(companyInfos);
    }

    public void initData() {
        this.setStartLoadDataPageNum(0);
        this.initLastLoadingData();
        this.setPageSizeText();
        this.setStartLoadDataIndex(0);
        this.setPageNum(1);
        EntityCacheHelper.savePcEntityToPageCache(this.getView(), null);
    }

    public void initLastLoadingData() {
        this.getPageCache().put(LAST_LOADING_DATA, null);
    }

    private void setPageSizeText() {
        String pageSizeText = ResManager.loadKDString((String)"%s\u6761/\u9875", (String)"BusinessInfoListPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[]{this.getPageSize()});
        this.getModel().setValue(PAGE_SIZE_KEY, (Object)pageSizeText);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPagingKeyEnable();
    }

    private void setPagingKeyEnable() {
        this.setGoBackEnable();
        this.setGoToEnable();
    }

    public CompanyFilterCondition initCompanyFilterCondition() {
        String[] riskItems = (String[])Arrays.stream(RiskDataFetcherEnum.values()).map(RiskDataFetcherEnum::getDataType).toArray(String[]::new);
        List<PartnerInfo> customersAndSuppliers = PartnerEnum.CustomAndSupplier.getPartnerInfosSupplier().getPartnerInfos();
        String[] partnerTypes = PartnerEnum.CustomAndSupplier.getPartnerTypes();
        CompanyFilterCondition companyFilterCondition = new CompanyFilterCondition();
        companyFilterCondition.setRiskItems(riskItems);
        companyFilterCondition.setPartners(customersAndSuppliers);
        companyFilterCondition.setPartnerTypes(partnerTypes);
        companyFilterCondition.setPageSize(this.getPageSize());
        companyFilterCondition.setStartIndex(this.getStartLoadDataIndex());
        companyFilterCondition.setPageNum(this.getPageNum());
        return companyFilterCondition;
    }

    public void initFilterControl(CompanyFilterCondition companyFilterCondition) {
        List<PartnerInfo> partners = companyFilterCondition.getPartners();
        String[] partnerNames = (String[])partners.stream().map(PartnerInfo::getName).toArray(String[]::new);
        String[] riskItems = companyFilterCondition.getRiskItems();
        String[] partnerTypes = companyFilterCondition.getPartnerTypes();
        this.buildFilterCombItems(partnerNames, COMPANY_NAME_FILTER);
        this.buildFilterCombItems(riskItems, RISK_ITEMS_FILTER);
        this.buildFilterCombItems(partnerTypes, PARTNER_TYPE_FILTER);
    }

    public void buildFilterCombItems(String[] values, String filterControlKey) {
        List<ComboItem> partnerComboItems = BusinessInfoListPlugin.getComboItemsByNames(values);
        MulComboEdit mulComboEdit = (MulComboEdit)this.getView().getControl(filterControlKey);
        mulComboEdit.setComboItems(partnerComboItems);
        StringBuilder value = new StringBuilder();
        partnerComboItems.stream().map(ComboItem::getValue).collect(Collectors.toList()).forEach(partnerComboItem -> value.append(',').append((String)partnerComboItem));
        this.getModel().beginInit();
        this.getModel().setValue(filterControlKey, (Object)value);
        this.getModel().endInit();
        this.getView().updateView(filterControlKey);
    }

    private static List<ComboItem> getComboItemsByNames(String[] names) {
        return new HashSet<String>(Arrays.asList(names)).stream().map(name -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(name));
            comboItem.setCaption(new LocaleString(String.valueOf(name)));
            return comboItem;
        }).collect(Collectors.toList());
    }

    private int getPageSize() {
        CardEntry entry = (CardEntry)this.getControl(ENTRY_ENTITY);
        return entry.getPageRow();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (IS_CONTINUE_LOADING.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.updateEntry();
            this.setPagingKeyEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (StringUtil.equals((String)String.valueOf(newValue), (String)String.valueOf(oldValue))) {
            return;
        }
        this.initData();
        switch (key) {
            case "partner_type_filter": {
                this.setStartLoadDataIndex(0);
                if (newValue == null) {
                    this.initCompanyNameFilter();
                    return;
                }
                String[] partnerCodes = String.valueOf(newValue).split(",");
                List<PartnerInfo> companyPartnerInfos = PartnerEnum.getByPartnerTypes(partnerCodes).getPartnerInfosSupplier().getPartnerInfos();
                this.setTotalCount(companyPartnerInfos.size());
                String[] companyNames = (String[])companyPartnerInfos.stream().map(PartnerInfo::getName).toArray(String[]::new);
                this.buildFilterCombItems(companyNames, COMPANY_NAME_FILTER);
                this.updateEntryFromCache();
                break;
            }
            case "company_name_filter": {
                String[] companyFilterNames = this.getMulFilterArrays(COMPANY_NAME_FILTER);
                this.setTotalCount(companyFilterNames.length);
                this.updateEntryFromCache();
                break;
            }
            case "risk_items_filter": {
                if (this.getMulFilterArrays(COMPANY_NAME_FILTER).length == 0) {
                    return;
                }
                this.updateEntryFromCache();
                break;
            }
        }
    }

    private void initCompanyNameFilter() {
        this.setTotalCount(0);
        this.setPagingKeyEnable();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        MulComboEdit mulComboEdit = (MulComboEdit)this.getView().getControl(COMPANY_NAME_FILTER);
        mulComboEdit.setComboItems(null);
        this.getModel().beginInit();
        this.getModel().setValue(COMPANY_NAME_FILTER, null);
        this.getModel().endInit();
        this.getView().updateView(COMPANY_NAME_FILTER);
    }

    private void setTotalCount(int size) {
        this.getPageCache().put(TOTAL_COUNT, String.valueOf(size));
    }

    private void setEntryValue(List<CompanyInfo> companyDetailInfos) {
        if (companyDetailInfos.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, companyDetailInfos.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        this.getModel().beginInit();
        String[] riskStatus = this.getMulFilterArrays(RISK_ITEMS_FILTER);
        for (int i = 0; i < companyDetailInfos.size(); ++i) {
            CompanyBusinessInfo businessInfo = companyDetailInfos.get(i).getBusinessInfo();
            if (businessInfo != null) {
                this.getModel().setValue(COMPANY_ID, (Object)businessInfo.getBusinessInfoItem().getCompanyId(), i);
                this.getModel().setValue(COMPANY_NAME, (Object)businessInfo.getBusinessInfoItem().getCompanyName(), i);
                this.getModel().setValue(CREDIT_NO, (Object)businessInfo.getBusinessInfoItem().getCreditNo(), i);
                String updateTime = businessInfo.getBusinessInfoItem().getUpdateTime();
                this.getModel().setValue("update_time", (Object)updateTime, i);
            }
            this.getModel().setValue("avatar", (Object)companyDetailInfos.get(i).getAvatarPath(), i);
            this.getModel().setValue(PARTNER_TYPE, (Object)companyDetailInfos.get(i).getPartnerType(), i);
            this.getModel().setValue("company_status", (Object)companyDetailInfos.get(i).getBusinessInfo().getBusinessInfoItem().getCompanyStatus(), i);
            CompanyHistoryNameInfo historyNameInfo = companyDetailInfos.get(i).getHistoryNameInfo();
            boolean isPresentHistoryName = historyNameInfo != null && CollectionUtils.isNotEmpty(historyNameInfo.getBaseData());
            this.getModel().setValue(EXSIT_HISTORYNAME, (Object)isPresentHistoryName, i);
            cardEntry.setChildVisible(isPresentHistoryName, i, new String[]{HISTORYNAME});
            this.getView().getModel().setValue("risk_details", (Object)companyDetailInfos.get(i).getRiskText(riskStatus), i);
            int riskTotalNumber = companyDetailInfos.get(i).getRiskTotalNumber();
            this.getView().getModel().setValue("qty", (Object)riskTotalNumber, i);
            this.getView().getModel().setValue("datasource", (Object)companyDetailInfos.get(i).getDataSource(), i);
        }
        this.saveEntity();
        this.getView().getModel().endInit();
    }

    private void saveEntity() {
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(this.getView(), this.getModel().getDataEntityType().getName());
        if (pcEntityFromCache == null) {
            pcEntityFromCache = this.getModel().getDataEntity();
        }
        DynamicObjectCollection dynamicObjectCollection = pcEntityFromCache.getDynamicObjectCollection(ENTRY_ENTITY);
        List<DynamicObject> saveEntity = this.getCombineEntry(dynamicObjectCollection);
        pcEntityFromCache.set(ENTRY_ENTITY, saveEntity);
        EntityCacheHelper.savePcEntityToPageCache(this.getView(), pcEntityFromCache);
    }

    private List<DynamicObject> getCombineEntry(DynamicObjectCollection dynamicObjectCollection) {
        int endIndex = Math.min((this.getPageNum() - 1) * this.getPageSize(), dynamicObjectCollection.size());
        List saveEntity = dynamicObjectCollection.subList(0, endIndex);
        if (saveEntity.size() == 0) {
            saveEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        } else {
            saveEntity.addAll(this.getModel().getEntryEntity(ENTRY_ENTITY));
        }
        return saveEntity;
    }

    private Integer getTotalCount() {
        String totalCountStr = this.getPageCache().get(TOTAL_COUNT);
        return Integer.valueOf(totalCountStr);
    }

    private String getPageIdByCompanyId(String companyId) {
        return this.getPageIdRelation().get(companyId);
    }

    private Map<String, String> getPageIdRelation() {
        String billIdAndPageId = this.getView().getPageCache().get(PAGE_ID_RELATION);
        if (org.apache.commons.lang.StringUtils.isBlank((String)billIdAndPageId)) {
            return new HashMap<String, String>(4);
        }
        return (Map)JSON.parseObject((String)billIdAndPageId, Map.class);
    }

    private void cachePageIdRelation(String companyId, String pageId) {
        Map<String, String> pageIdRelation = this.getPageIdRelation();
        pageIdRelation.put(companyId, pageId);
        String billIdAndPageIdStr = JSON.toJSONString(pageIdRelation);
        this.getPageCache().put(PAGE_ID_RELATION, billIdAndPageIdStr);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (button.getKey()) {
            case "detail": 
            case "detail_vectorap": {
                int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
                String companyId = (String)this.getModel().getValue(COMPANY_ID, index);
                String pageId = this.getPageIdByCompanyId(companyId);
                if (StringUtils.isNotBlank((CharSequence)pageId) && this.getView().getViewNoPlugin(pageId) != null) {
                    IFormView openedView = this.getView().getViewNoPlugin(pageId);
                    openedView.activate();
                    this.getView().sendFormAction(openedView);
                    break;
                }
                String companyName = (String)this.getModel().getValue(COMPANY_NAME, index);
                String creditNo = (String)this.getModel().getValue(CREDIT_NO, index);
                String partnerType = (String)this.getModel().getValue(PARTNER_TYPE, index);
                FormShowParameter detailShowParameter = new FormShowParameter();
                PartnerInfo partnerInfo = new PartnerInfo(companyName, partnerType, creditNo, companyId);
                detailShowParameter.setCustomParam("partnerInfo", (Object)partnerInfo);
                detailShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                detailShowParameter.setFormId(SCMDI_BUSINESSINFO_DETAIL);
                detailShowParameter.setCaption(companyName);
                this.getView().showForm(detailShowParameter);
                this.cachePageIdRelation(companyId, detailShowParameter.getPageId());
                break;
            }
            case "goto": {
                this.setPageNum(this.getPageNum() + 1);
                this.initLastLoadingData();
                this.updateEntryFromCache();
                break;
            }
            case "goback": {
                this.setPageNum(this.getPageNum() - 1);
                this.initLastLoadingData();
                this.updateEntryFromCache();
                break;
            }
        }
    }

    private void updateEntryFromCache() {
        DynamicObject entityFromCache = EntityCacheHelper.getPcEntityFromCache(this.getView(), this.getModel().getDataEntityType().getName());
        DynamicObjectCollection dynamicObjectCollection = entityFromCache == null ? new DynamicObjectCollection() : entityFromCache.getDynamicObjectCollection(ENTRY_ENTITY);
        int pageStartIndex = Math.max(0, this.getPageNum() - 1) * this.getPageSize();
        if (pageStartIndex >= dynamicObjectCollection.size()) {
            this.updateEntry();
        } else {
            int pageEndIndex = Math.min(pageStartIndex + this.getPageSize(), dynamicObjectCollection.size());
            List dynamicObjects = dynamicObjectCollection.subList(pageStartIndex, pageEndIndex);
            DynamicObjectCollection updateDyColl = new DynamicObjectCollection(dynamicObjectCollection.getDynamicObjectType(), (Object)this.getModel().getDataEntity(), dynamicObjects);
            this.getModel().updateEntryCache(updateDyColl);
            this.setEntryFieldVisible(updateDyColl);
            this.getView().updateView(ENTRY_ENTITY);
        }
        this.setPagingKeyEnable();
    }

    private void setEntryFieldVisible(DynamicObjectCollection entryEntity) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            Boolean isPresentHistoryName = ((DynamicObject)entryEntity.get(i)).getBoolean(EXSIT_HISTORYNAME);
            cardEntry.setChildVisible(isPresentHistoryName.booleanValue(), i, new String[]{HISTORYNAME});
        }
    }

    public CompanyFilterCondition getCompanyFilterCondition() {
        String[] partnerTypes = this.getMulFilterArrays(PARTNER_TYPE_FILTER);
        String[] riskItems = this.getMulFilterArrays(RISK_ITEMS_FILTER);
        String[] names = this.getMulFilterArrays(COMPANY_NAME_FILTER);
        List<PartnerInfo> allPartnerInfos = PartnerEnum.getByPartnerTypes(partnerTypes).getPartnerInfosSupplier().getPartnerInfos();
        List<PartnerInfo> partnerInfos = allPartnerInfos.stream().filter(partnerInfo -> Arrays.asList(names).contains(partnerInfo.getName())).collect(Collectors.toList());
        CompanyFilterCondition companyFilterCondition = new CompanyFilterCondition();
        companyFilterCondition.setPartnerTypes(partnerTypes);
        companyFilterCondition.setRiskItems(riskItems);
        companyFilterCondition.setPartners(partnerInfos);
        companyFilterCondition.setPageSize(this.getPageSize());
        companyFilterCondition.setStartIndex(this.getStartLoadDataIndex());
        return companyFilterCondition;
    }

    public String[] getMulFilterArrays(String fieldName) {
        Object value = this.getModel().getValue(fieldName);
        if (value == null) {
            return new String[0];
        }
        String[] fieldNames = String.valueOf(value).split(",");
        return (String[])Arrays.stream(fieldNames).filter(name -> !"".equals(name)).toArray(String[]::new);
    }

    private void updateEntry() {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        CompanyInfosService companyInfosService = new CompanyInfosService(this.getCompanyFilterCondition());
        List<CompanyInfo> companyInfos = companyInfosService.getBatchCompanyInfos(this.getView());
        this.setStartLoadDataIndex(companyInfosService.getLastedStartIndex());
        this.setEntryValue(companyInfos);
        this.getView().updateView(ENTRY_ENTITY);
        this.setStartLoadDataPageNum(this.getPageNum());
    }

    public void setStartLoadDataPageNum(int pageNum) {
        this.getPageCache().put("startLoadDataPage", String.valueOf(pageNum));
    }

    public int getStartLoadDataPageNum() {
        String startLoadDataPage = this.getPageCache().get("startLoadDataPage");
        if (StringUtils.isBlank((CharSequence)startLoadDataPage)) {
            return 1;
        }
        return Integer.parseInt(startLoadDataPage);
    }

    private void setGoBackEnable() {
        this.getView().setEnable(Boolean.valueOf(this.getPageNum() > 1), new String[]{GOBACK});
    }

    private void setGoToEnable() {
        this.getView().setEnable(Boolean.valueOf(this.getPageNum() < this.getStartLoadDataPageNum() || this.getStartLoadDataIndex() < this.getTotalCount()), new String[]{GOTO});
    }

    public int getPageNum() {
        String pageNum = this.getPageCache().get(PAGE_NUM);
        if (StringUtils.isBlank((CharSequence)pageNum)) {
            return 1;
        }
        return Math.max(Integer.parseInt(pageNum), 1);
    }

    public void setPageNum(int pageNum) {
        this.getPageCache().put(PAGE_NUM, String.valueOf(pageNum));
    }

    public void setStartLoadDataIndex(int pageStartIndex) {
        this.getPageCache().put(START_INDEX, String.valueOf(pageStartIndex));
    }

    public int getStartLoadDataIndex() {
        String startIndex = this.getPageCache().get(START_INDEX);
        if (StringUtils.isBlank((CharSequence)startIndex)) {
            return 0;
        }
        return Math.max(Integer.parseInt(startIndex), 0);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DETAIL, GOBACK, GOTO, DETAIL_VECTORAP});
    }
}

