/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum WarningLevelColorEnum {
    LOW("\u4f4e", "10", "#C665FF"),
    MEDIUM("\u4e2d", "20", "#FF991C"),
    HIGH("\u9ad8", "30", "#FB2323");

    private final String title;
    private final String value;
    private final String backgroundColor;

    private WarningLevelColorEnum(String title, String value, String backgroundColor) {
        this.title = title;
        this.value = value;
        this.backgroundColor = backgroundColor;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public static String getTitle(String value) {
        String name = null;
        for (WarningLevelColorEnum warningLevelColorEnum : WarningLevelColorEnum.values()) {
            if (!value.equals(warningLevelColorEnum.getValue())) continue;
            name = warningLevelColorEnum.getTitle();
            break;
        }
        return name;
    }

    public String getValue() {
        return this.value;
    }

    public static Map<String, Object> getCustomProperties(String title) {
        Map<String, Object> map;
        switch (title) {
            case "\u4f4e": {
                map = WarningLevelColorEnum.getColorMap(LOW.getBackgroundColor());
                break;
            }
            case "\u4e2d": {
                map = WarningLevelColorEnum.getColorMap(MEDIUM.getBackgroundColor());
                break;
            }
            case "\u9ad8": {
                map = WarningLevelColorEnum.getColorMap(HIGH.getBackgroundColor());
                break;
            }
            default: {
                map = new HashMap<String, Object>(1);
            }
        }
        return map;
    }

    private static Map<String, Object> getColorMap(String backgroundColor) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("bc", backgroundColor);
        return map;
    }
}

