/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommonUtils {
    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return ((String)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean isAllNullOrEmpty(Object ... objects) {
        if (objects == null) {
            return true;
        }
        return Arrays.stream(objects).allMatch(CommonUtils::isNullOrEmpty);
    }

    public static boolean isAnyNullOrEmpty(Object ... objects) {
        if (objects == null) {
            return true;
        }
        return Arrays.stream(objects).anyMatch(CommonUtils::isNullOrEmpty);
    }

    public static <E> List<E> getDuplicateElements(List<E> list) {
        return list.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> entry.getKey()).collect(Collectors.toList());
    }

    public static List<String> split(String orientString, String ... splitors) {
        List<Object> list = Lists.newArrayList((Object[])new String[]{orientString});
        for (String splitor : splitors) {
            list = CommonUtils.split(list, splitor);
        }
        list = list.stream().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return list;
    }

    private static List<String> split(List<String> list, String splitor) {
        ArrayList newList = Lists.newArrayList();
        for (String s : list) {
            String[] split = s.split(splitor);
            newList.addAll(Arrays.asList(split));
        }
        return newList;
    }

    public static String subString(String value, int maxLength) {
        return StringUtils.isNotEmpty((CharSequence)value) && value.length() > maxLength ? value.substring(0, maxLength - 1) + "\u2026" : value;
    }
}

