/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class HomePageDateUtils {
    public static Date getSixMonthAgoByDate(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime sixMonthAgoDateTime = dateTime.minusMonths(6L);
        Date sixMonthAgo = Date.from(sixMonthAgoDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return sixMonthAgo;
    }

    public static Date getYesterdayByDate(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime yesterdayDateTime = dateTime.minusDays(1L);
        Date yesterday = Date.from(yesterdayDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return yesterday;
    }

    public static List<String> getYearMonthBetween(Date startDate, Date endDate) {
        LocalDate localStartDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localEndDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ArrayList<String> yearMonth = new ArrayList<String>(6);
        YearMonth startYearMonth = YearMonth.from(localStartDate);
        YearMonth endYearMonth = YearMonth.from(localEndDate);
        while (!startYearMonth.isAfter(endYearMonth)) {
            yearMonth.add(startYearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));
            startYearMonth = startYearMonth.plusMonths(1L);
        }
        return yearMonth;
    }

    public static Date getFirstDayOfFiveMonth(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime fiveMonthAgoDateTime = dateTime.minusMonths(5L);
        LocalDateTime localDateTime = fiveMonthAgoDateTime.withDayOfMonth(1);
        Date sixMonthAgo = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        Date dayStartTime = HomePageDateUtils.getDayStartTime(sixMonthAgo);
        return dayStartTime;
    }

    public static Date getYearAgoByDate(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime yearAgoDateTime = dateTime.minusYears(1L);
        Date yearAgo = Date.from(yearAgoDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return yearAgo;
    }

    public static Date getMonthAgoByDate() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        if (month == 0) {
            calendar.add(1, -1);
            calendar.set(1, 11);
        } else {
            calendar.add(2, -1);
        }
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }
}

