/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ScmdiBusinessDataServiceHelper {
    private static final String TRACER_TYPE = ScmdiBusinessDataServiceHelper.class.getName();
    private static final String PARAM_ENTITYNAME = "entityname";
    private static final String PARAM_SELECTFIELDS = "selectFields";
    private static final String PARAM_FILTERS = "filters";
    private static final String BUSINESS_DATA_SERVICE_HELPER_LOAD = "MobileBusinessDataServiceHelper.count";

    public static int count(String entityName, QFilter[] filters) {
        ORM orm = ORM.create();
        int count = orm.count(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, (Distinctable)WithDistinctable.get());
        return count;
    }

    public static int countWithPermission(String entityName, QFilter[] filters, String appId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACER_TYPE, (String)"loadWithPermission");){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag("appId", appId);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
                span.fireEvent(null);
            }
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            Long userId = RequestContext.get().getCurrUserId();
            QFilter filter = permissionService.getViewPermFilter(userId, appId, entityName);
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            Collections.addAll(list, filters);
            list.add(filter);
            int n = ScmdiBusinessDataServiceHelper.count(entityName, list.toArray(new QFilter[list.size()]));
            return n;
        }
    }

    public static DynamicObject[] loadWithPermission(String entityName, String selectProperties, QFilter[] filters, String orderBy, int pageIndex, int pageSize, String appId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACER_TYPE, (String)"loadWithPermission");){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addTag("orderBy", orderBy);
                span.addTag("pageIndex", String.valueOf(pageIndex));
                span.addTag("pageSize", String.valueOf(pageSize));
                span.addTag("appId", appId);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
                span.fireEvent(null);
            }
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            Long userId = RequestContext.get().getCurrUserId();
            QFilter filter = permissionService.getViewPermFilter(userId, appId, entityName);
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            Collections.addAll(list, filters);
            list.add(filter);
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])list.toArray(new QFilter[list.size()]), (String)orderBy, (int)pageIndex, (int)pageSize);
            return dynamicObjectArray;
        }
    }
}

