/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class ExcelUtils {
    private static Log log = LogFactory.getLog(ExcelUtils.class);
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public static BigDecimal getBigDecimal(XSSFCell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.BLANK) {
            return null;
        }
        if (cellType == CellType._NONE) {
            return null;
        }
        if (cellType == CellType.NUMERIC) {
            return BigDecimal.valueOf(cell.getNumericCellValue());
        }
        if (cellType == CellType.STRING) {
            return new BigDecimal(cell.getStringCellValue());
        }
        return null;
    }

    public static String getStringValue(XSSFCell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.BLANK) {
            return null;
        }
        if (cellType == CellType._NONE) {
            return null;
        }
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cellType == CellType.NUMERIC) {
            return cell.getNumericCellValue() + "";
        }
        if (cellType == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        return null;
    }

    public static boolean isRowEmpty(Row row) {
        if (row.getLastCellNum() == -1) {
            return true;
        }
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    public static CellStyle getTitleStyle(SXSSFWorkbook workbook) {
        Font headerFont = workbook.createFont();
        headerFont.setColor(IndexedColors.BLACK.index);
        headerFont.setBold(true);
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerCellStyle.setFont(headerFont);
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setBorderTop(BorderStyle.THICK);
        headerCellStyle.setBorderBottom(BorderStyle.THICK);
        return headerCellStyle;
    }

    public static CellStyle getDimensionDataStyle(SXSSFWorkbook workbook) {
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        DataFormat fmt = workbook.createDataFormat();
        headerCellStyle.setDataFormat(fmt.getFormat("@"));
        return headerCellStyle;
    }

    public static CellStyle getValueDataStyle(SXSSFWorkbook workbook) {
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        return headerCellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadExcel(Workbook workbook, IFormView view, String fileName) {
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            in = new ByteArrayInputStream(out.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(fileName, (InputStream)in, timeout);
            String tempFileId = UrlUtil.getParam((String)tempUrl, (String)"id");
            HashMap<String, String> refEntityMap = new HashMap<String, String>(2);
            refEntityMap.put("entityNum", view.getEntityId());
            refEntityMap.put("permissionItemId", "47150e89000000ac");
            refEntityMap.put("appId", view.getFormShowParameter().getServiceAppId());
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntityMap), timeout);
            view.download(tempUrl);
        }
        catch (IOException e1) {
            log.error((Throwable)e1);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                workbook.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }
}

