/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils.mapper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.scmdi.common.utils.mapper.annotation.DynamicField;
import kd.scmc.scmdi.common.utils.mapper.annotation.DynamicOrientValue;
import kd.scmc.scmdi.common.utils.mapper.convertor.AbstractTypeConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.ConvertContext;
import kd.scmc.scmdi.common.utils.mapper.convertor.ConvertInfo;
import kd.scmc.scmdi.common.utils.mapper.convertor.FormViewCglibEnhancedFunction;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.DynamicCollectionConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.DynamicToLongConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.DynamicToObjectConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.DynamicToStringConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.LocaleDynamicObjectCollectionStringConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.MulBasedataDynamicObjectCollectionConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.MultiLanguageStringConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.MultiSelectArrayConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.StringToEnumerationConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.impl.StringToMapConvertor;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DynamicDataMapper {
    private static final Log log = LogFactory.getLog(DynamicDataMapper.class);
    private static final List<AbstractTypeConvertor> convertors = new ArrayList<AbstractTypeConvertor>();

    public static <T> T convert(DynamicObject dynamicObject, Class<T> tClass) {
        ConvertContext convertContext = new ConvertContext();
        convertContext.setFunction(t -> {
            try {
                return t.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("DynamicDataMapper.map class instance error", e);
            }
        });
        return DynamicDataMapper.convert(convertContext, dynamicObject, tClass);
    }

    public static <T> T convert(DynamicObject dynamicObject, Class<T> tClass, IFormView view) {
        ConvertContext convertContext = new ConvertContext();
        FormViewCglibEnhancedFunction<Object> function = new FormViewCglibEnhancedFunction<Object>(convertContext, view);
        convertContext.setFunction(function);
        return DynamicDataMapper.convert(convertContext, dynamicObject, tClass);
    }

    public static <T> T convert(ConvertContext convertContext, DynamicObject dynamicObject, Class<T> pojoClass) {
        Field[] fields;
        if (dynamicObject == null) {
            return null;
        }
        Object pojoObject = convertContext.getFunction().apply(pojoClass);
        for (Field pojoField : fields = FieldUtils.getAllFields(pojoClass)) {
            Object setValue;
            pojoField.setAccessible(true);
            DynamicOrientValue dynamicOrientValue = pojoField.getAnnotation(DynamicOrientValue.class);
            if (dynamicOrientValue != null) {
                setValue = dynamicObject;
            } else {
                Object dynamicFieldValue;
                String dynamicFieldName = DynamicDataMapper.getDynamicFieldName(pojoField);
                if (dynamicObject.containsProperty(dynamicFieldName)) {
                    dynamicFieldValue = dynamicObject.get(dynamicFieldName);
                    DynamicDataMapper.addPropertyChangeListener(convertContext, dynamicObject, pojoObject, pojoField, dynamicFieldName);
                } else {
                    dynamicFieldValue = null;
                }
                setValue = DynamicDataMapper.convertDynamicFieldValueToPojoFieldValue(convertContext, pojoField, dynamicFieldName, dynamicFieldValue);
            }
            DynamicDataMapper.setPojoFieldValue(pojoObject, pojoField, setValue);
        }
        return (T)pojoObject;
    }

    private static <T> void addPropertyChangeListener(ConvertContext convertContext, DynamicObject dynamicObject, T pojoObject, Field pojoField, String dynamicFieldName) {
        dynamicObject.addPropertyChangeListener(evt -> {
            if (!evt.getPropertyName().equals(dynamicFieldName)) {
                return;
            }
            DynamicDataMapper.setPojoFieldValue(pojoObject, pojoField, DynamicDataMapper.convertDynamicFieldValueToPojoFieldValue(convertContext, pojoField, dynamicFieldName, evt.getNewValue()));
        });
    }

    private static <T> void setPojoFieldValue(T pojoObject, Field pojoField, Object setValue) {
        try {
            pojoField.set(pojoObject, setValue);
        }
        catch (Exception e) {
            throw new RuntimeException(pojoField + " field set error:" + setValue, e);
        }
    }

    private static Object convertDynamicFieldValueToPojoFieldValue(ConvertContext convertContext, Field pojoField, String dynamicFieldName, Object dynamicFieldValue) {
        Object setValue;
        Class<?> pojoFieldType = pojoField.getType();
        if (dynamicFieldValue == null) {
            setValue = null;
        } else {
            Class<?> dynamicFieldClass = dynamicFieldValue.getClass();
            ConvertInfo convertInfo = new ConvertInfo(convertContext);
            convertInfo.setDynamicFieldClass(dynamicFieldClass);
            convertInfo.setPojoFieldType(pojoFieldType);
            convertInfo.setPojoField(pojoField);
            convertInfo.setDynamicFieldName(dynamicFieldName);
            convertInfo.setDynamicFieldValue(dynamicFieldValue);
            Optional<AbstractTypeConvertor> matchedConvertor = convertors.stream().filter(cvt -> cvt.compatible(convertInfo)).findFirst();
            if (matchedConvertor.isPresent()) {
                setValue = matchedConvertor.get().convert(convertInfo);
            } else if (pojoFieldType.isAssignableFrom(dynamicFieldClass)) {
                setValue = dynamicFieldValue;
            } else {
                if (pojoFieldType.isPrimitive()) {
                    throw new RuntimeException("this field is primitive:" + pojoFieldType.getName());
                }
                throw new RuntimeException(dynamicFieldName + " of type " + dynamicFieldClass.getName() + " ( value:" + dynamicFieldValue + ") cannot be casted to " + pojoFieldType.getName());
            }
        }
        return setValue;
    }

    public static String getDynamicFieldName(Field pojoField) {
        String dynamicFieldName;
        pojoField.setAccessible(true);
        String pojoFieldName = pojoField.getName();
        DynamicField pojoFieldAnnotation = pojoField.getAnnotation(DynamicField.class);
        if (pojoFieldAnnotation == null) {
            dynamicFieldName = pojoFieldName;
            dynamicFieldName = DynamicDataMapper.camelToSnake(dynamicFieldName);
        } else {
            dynamicFieldName = pojoFieldAnnotation.value();
        }
        return dynamicFieldName;
    }

    private static String camelToSnake(String dynamicFieldName) {
        String ret = dynamicFieldName.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2");
        return ret.toLowerCase();
    }

    public static <T> List<T> convertCollection(DynamicObjectCollection dynamicObjects, Class<T> tClass) {
        if (dynamicObjects == null) {
            return new ArrayList();
        }
        return dynamicObjects.stream().map(d -> DynamicDataMapper.convert(d, tClass)).collect(Collectors.toList());
    }

    public static <T> List<T> convertCollection(DynamicObject[] dynamicObjects, Class<T> tClass) {
        if (dynamicObjects == null) {
            return new ArrayList();
        }
        return Arrays.stream(dynamicObjects).map(d -> DynamicDataMapper.convert(d, tClass)).collect(Collectors.toList());
    }

    static {
        convertors.add(new MultiSelectArrayConvertor());
        convertors.add(new LocaleDynamicObjectCollectionStringConvertor());
        convertors.add(new MultiLanguageStringConvertor());
        convertors.add(new MulBasedataDynamicObjectCollectionConvertor());
        convertors.add(new DynamicCollectionConvertor());
        convertors.add(new StringToMapConvertor());
        convertors.add(new StringToEnumerationConvertor());
        convertors.add(new DynamicToStringConvertor());
        convertors.add(new DynamicToLongConvertor());
        convertors.add(new DynamicToObjectConvertor());
    }
}

