/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils.mapper.convertor.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.utils.mapper.convertor.AbstractTypeConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.ConvertContext;
import kd.scmc.scmdi.common.utils.mapper.convertor.ConvertInfo;

public class DynamicCollectionConvertor
extends AbstractTypeConvertor<DynamicObjectCollection, List> {
    @Override
    public List convert(ConvertInfo<DynamicObjectCollection, List> convertInfo) {
        ArrayList result = new ArrayList(convertInfo.getDynamicFieldValue().size());
        Type genericType = convertInfo.getPojoField().getGenericType();
        ConvertContext convertContext = convertInfo.getConvertContext();
        convertContext.putMapping(convertInfo.getDynamicFieldName(), result);
        convertContext.putFieldMapping(convertInfo.getDynamicFieldName(), convertInfo.getPojoField());
        try {
            Class<?> aClass = Class.forName(((ParameterizedType)genericType).getActualTypeArguments()[0].getTypeName());
            for (DynamicObject dynamicObject : convertInfo.getDynamicFieldValue()) {
                Object mappedResult = DynamicDataMapper.convert(convertContext, dynamicObject, aClass);
                result.add(mappedResult);
                convertContext.putRelation(mappedResult, result);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

