/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.common.utils.mapper.convertor.impl;

import java.lang.reflect.Field;
import kd.scmc.scmdi.common.utils.mapper.annotation.DynamicEnumValue;
import kd.scmc.scmdi.common.utils.mapper.convertor.AbstractTypeConvertor;
import kd.scmc.scmdi.common.utils.mapper.convertor.ConvertInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class StringToEnumerationConvertor
extends AbstractTypeConvertor<String, Enum> {
    @Override
    public Enum convert(ConvertInfo<String, Enum> convertInfo) {
        ?[] enumConstants;
        if (StringUtils.isEmpty((CharSequence)convertInfo.getDynamicFieldValue())) {
            return null;
        }
        Class<?> type = convertInfo.getPojoField().getType();
        Field[] fieldsWithAnnotation = FieldUtils.getFieldsWithAnnotation(type, DynamicEnumValue.class);
        if (fieldsWithAnnotation == null || fieldsWithAnnotation.length == 0) {
            return Enum.valueOf(type, convertInfo.getDynamicFieldValue());
        }
        Field field = fieldsWithAnnotation[0];
        field.setAccessible(true);
        for (Object enumValue : enumConstants = type.getEnumConstants()) {
            try {
                Object o = field.get(enumValue);
                if (!convertInfo.getDynamicFieldValue().equals(o)) continue;
                return (Enum)enumValue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(convertInfo.getPojoField().getName() + " of value " + convertInfo.getDynamicFieldValue() + " cannot be casted to " + type.getName());
    }
}

