/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.form.common.formula.DymUtils;
import kd.scmc.scmdi.form.vo.warning.WarningRule;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class FormulaFilter {
    public static final boolean filter(String entityNumber, DynamicObject entryObj, String filterFormula) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return false;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        return FormulaFilter.filter(mainEntityType, entryObj, filterFormula);
    }

    public static boolean filter(MainEntityType mainEntityType, DynamicObject entryObj, String filterFormula) {
        if (StringUtils.isBlank((CharSequence)filterFormula)) {
            return true;
        }
        String entryName = entryObj.getDataEntityType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, mainEntityType);
        rowDataModel.setRowContext(entryObj);
        ExpressionParameter expressionParameter = new ExpressionParameter(filterFormula, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>(vars.size());
        for (String var : vars) {
            Object val;
            try {
                val = DymUtils.getPropValue(mainEntityType, entryObj, var);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (val instanceof Object[] && ((Object[])val).length != 0) {
                val = ((Object[])val)[0];
            }
            if (val instanceof OrmLocaleValue) {
                val = ((OrmLocaleValue)val).getLocaleValue();
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).getPkValue();
            }
            params.put(var, val);
        }
        Set funcs = expressionParameter.getBOSExpression().getFuncs();
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions((Set)funcs, (FunctionManage)FunctionManage.get(), (ExpressionContext)new BOSExpressionContext(rowDataModel));
        return (Boolean)FormulaEngine.execExcelFormula((String)filterFormula, params, (UDFunction[])functions);
    }

    public static String filterText(String entityNumber, DynamicObject warningObject, String filterFormula, WarningRule ruleRow) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String entryName = warningObject.getDataEntityType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, mainEntityType);
        rowDataModel.setRowContext(warningObject);
        ExpressionParameter expressionParameter = new ExpressionParameter(filterFormula, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>(vars.size());
        for (String var : vars) {
            Object val;
            try {
                val = DymUtils.getPropValue(mainEntityType, warningObject, var);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (val instanceof Object[] && ((Object[])val).length != 0) {
                val = ((Object[])val)[0];
            }
            if (val instanceof OrmLocaleValue) {
                val = ((OrmLocaleValue)val).getLocaleValue();
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).getPkValue();
            }
            params.put(var, val);
        }
        Set funcs = expressionParameter.getBOSExpression().getFuncs();
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions((Set)funcs, (FunctionManage)FunctionManage.get(), (ExpressionContext)new BOSExpressionContext(rowDataModel));
        FormulaEngine.execExcelFormula((String)filterFormula, params, (UDFunction[])functions);
        String script0 = ruleRow.getFilterConditionFormulaTag();
        String script1 = ruleRow.getFilterConditionReadTag();
        List split0 = CommonUtils.split((String)script0, (String[])new String[]{"  and  ", "  or  "});
        List split1 = CommonUtils.split((String)script1, (String[])new String[]{"  and  ", "  or  "});
        HashMap<String, List> varMap1 = new HashMap<String, List>();
        HashMap<String, List> varMap2 = new HashMap<String, List>();
        HashMap<Integer, List> segmentVariableMap = new HashMap<Integer, List>();
        for (int i = 0; i < split0.size(); ++i) {
            String s0 = (String)split0.get(i);
            List split = CommonUtils.split((String)s0, (String[])new String[]{"<", "=", ">", "\\(", "\\)", ",", " "});
            for (String var : vars) {
                if (!split.contains(var)) continue;
                List list1 = varMap1.getOrDefault(var, new ArrayList());
                List list2 = varMap2.getOrDefault(var, new ArrayList());
                list1.add(i);
                list2.add(split.indexOf(var));
                varMap1.put(var, list1);
                varMap2.put(var, list2);
                List variables = segmentVariableMap.getOrDefault(i, new ArrayList());
                variables.add(var);
                segmentVariableMap.put(i, variables);
            }
        }
        ArrayList<String> resultStringList = new ArrayList<String>(segmentVariableMap.size());
        List filterRows = ruleRow.getDeserializedFilterCondition().getFilterRow();
        int index = 0;
        for (Map.Entry entry : segmentVariableMap.entrySet()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRows.get(index);
            List variables = (List)entry.getValue();
            String s = (String)split1.get((Integer)entry.getKey());
            s = s.replaceAll("\\(", "");
            s = s.replaceAll("\\)", "");
            List ss = CommonUtils.split((String)s, (String[])new String[]{" "});
            for (String variable : variables) {
                Object o = params.get(variable);
                o = FormulaFilter.getValue(o);
                if (((List)varMap2.get(variable)).contains(0)) {
                    ss.set(0, (String)ss.get(0) + "\u3010" + o + "\u3011");
                }
                if (!((List)varMap2.get(variable)).contains(1)) continue;
                ss.set(2, (String)ss.get(2) + "\u3010" + o + "\u3011");
            }
            s = ss.stream().collect(Collectors.joining(" "));
            boolean isLastRow = filterRows.size() - 1 == index;
            s = simpleFilterRow.getLeftBracket() + s + simpleFilterRow.getRightBracket();
            if (!isLastRow) {
                s = s + (simpleFilterRow.getLogic().equals("0") ? " \r\n\u5e76\u4e14" : " \r\n\u6216\u8005");
            }
            resultStringList.add(s);
            ++index;
        }
        return resultStringList.stream().collect(Collectors.joining(" "));
    }

    private static String getValue(Object x) {
        if (CommonUtils.isNullOrEmpty((Object)x)) {
            return ResManager.loadKDString((String)"\u7a7a\u503c", (String)"FormulaFilter_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? ResManager.loadKDString((String)"\u662f", (String)"FormulaFilter_YES", (String)"scmc-scmdi-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FormulaFilter_NO", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        }
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).stripTrailingZeros().toPlainString();
        }
        if (x instanceof Date) {
            return new DateTime(x).toString("yyyy-MM-dd");
        }
        if (x instanceof DynamicObject) {
            return ((DynamicObject)x).getString("name");
        }
        String s = x.toString();
        if (s.length() < 20) {
            return s;
        }
        return s.substring(0, 20) + "\u2026";
    }
}

