/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.formula;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.scmdi.business.metric.MetricDataHelper;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.form.common.formula.FormulaFilter;
import kd.scmc.scmdi.form.common.helper.WarningResultHandler;
import kd.scmc.scmdi.form.enumeration.warning.ExecType;
import kd.scmc.scmdi.form.vo.ridding.WarningRidding;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;
import kd.scmc.scmdi.form.vo.warning.WarningExecuteResult;
import kd.scmc.scmdi.form.vo.warning.WarningRule;

public class RuleHandler {
    private final WarnConfig warnConfig;
    private final WarningResultHandler warningResultHandler;

    public RuleHandler(Long ruleId) {
        this.warnConfig = (WarnConfig)DynamicDataMapper.convert((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"scmdi_early_warning"), WarnConfig.class);
        this.warningResultHandler = new WarningResultHandler(this.warnConfig);
    }

    private DynamicObject record(boolean isManual) {
        DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)"scmdi_warning_record");
        target.set("warning_config", (Object)this.warnConfig.getDynamicObject());
        target.set("exec_type", (Object)(isManual ? ExecType.MANUAL.name() : ExecType.AUTO.name()));
        target.set("warning_start_time", (Object)new Date());
        target.set("warning_object", (Object)this.warnConfig.getWarningObject().getId());
        WarningRidding warningRidding = this.warnConfig.getWarningRidding();
        target.set("ridding_config", (Object)(warningRidding == null ? null : warningRidding.getId()));
        target.set("billstatus", (Object)"C");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)target.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{target});
        if (operationResult != null && !operationResult.isSuccess()) {
            String errors = ((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.joining(","));
            String message = String.format(ResManager.loadKDString((String)"\u9884\u8b66\u6267\u884c\u8bb0\u5f55\u4fdd\u5b58\u5f02\u5e38\uff1a%1$s", (String)"RuleHandler_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), errors);
            throw new KDBizException(message);
        }
        return target;
    }

    public WarningExecuteResult executeRule(boolean isManual) {
        DynamicObject record = this.record(isManual);
        String warningObjectEntityNumber = this.warnConfig.getWarningObject().getNumber();
        AtomicLong totalCount = new AtomicLong();
        AtomicLong warnCount = new AtomicLong();
        AtomicLong duplicatedCount = new AtomicLong();
        List<WarningRule> ruleEntry = this.warnConfig.getSortedRuleEntry();
        MetricMapping metricMapping = MetricDataHelper.getMetricMapping((String)warningObjectEntityNumber);
        MetricDataHelper.getMetricsData((MetricMapping)metricMapping, metricData -> metricData.forEach(mapResult -> {
            for (int i = 0; i < ruleEntry.size(); ++i) {
                String expression;
                boolean warnConditionMatched;
                WarningRule ruleRow = (WarningRule)ruleEntry.get(i);
                if (ruleRow.getDeserializedFilterCondition() == null || !(warnConditionMatched = FormulaFilter.filter(warningObjectEntityNumber, mapResult, expression = ruleRow.getFilterConditionFormulaTag()))) continue;
                warnCount.getAndIncrement();
                String filterConditionRead = FormulaFilter.filterText(warningObjectEntityNumber, mapResult, expression, ruleRow);
                boolean duplicated = this.warningResultHandler.executeRowRule(record, (DynamicObject)mapResult, filterConditionRead, metricMapping, ruleRow);
                if (!duplicated) break;
                duplicatedCount.getAndIncrement();
                break;
            }
            totalCount.getAndIncrement();
        }));
        this.warningResultHandler.autoCancelResult();
        WarningExecuteResult warningExecuteResult = new WarningExecuteResult();
        warningExecuteResult.setDuplicatedCount(duplicatedCount.get());
        warningExecuteResult.setTotalDataCount(totalCount.get());
        warningExecuteResult.setWarningCount(warnCount.get());
        record.set("judge_data_count", (Object)warningExecuteResult.getTotalDataCount());
        record.set("warning_data_count", (Object)warningExecuteResult.getWarningCount());
        record.set("ridding_count", (Object)warningExecuteResult.getDuplicatedCount());
        record.set("warning_end_time", (Object)new Date());
        long seconds = (record.getDate("warning_end_time").getTime() - record.getDate("warning_start_time").getTime()) / 1000L;
        warningExecuteResult.setDurationInSeconds(seconds);
        record.set("warning_duration_second", (Object)seconds);
        OperationServiceHelper.executeOperate((String)"save", (String)record.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{record});
        return warningExecuteResult;
    }
}

