/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.pojo.OtcDigitalCardInfo;
import kd.scmc.scmdi.common.pojo.ProcessTimeInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;

public class OtcProcessHelper {
    public static OtcDigitalCardInfo getDigitalCardInfo(Long processId) {
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        Date qoqEndDate = HomePageDateUtils.getSixMonthAgoByDate((Date)endDate);
        Date qoqStartDate = HomePageDateUtils.getSixMonthAgoByDate((Date)startDate);
        Date yoyEndDate = HomePageDateUtils.getYearAgoByDate((Date)endDate);
        Date yoyStartDate = HomePageDateUtils.getYearAgoByDate((Date)startDate);
        ProcessTimeInfo nowProcessData = OtcProcessHelper.getProcessHistoryData(processId, startDate, endDate);
        ProcessTimeInfo qoqProcessData = OtcProcessHelper.getProcessHistoryData(processId, qoqStartDate, qoqEndDate);
        ProcessTimeInfo yoyProcessData = OtcProcessHelper.getProcessHistoryData(processId, yoyStartDate, yoyEndDate);
        OtcDigitalCardInfo cardInfo = new OtcDigitalCardInfo();
        if (nowProcessData == null) {
            return cardInfo;
        }
        cardInfo.setTotalTime(nowProcessData.getTotalTime());
        cardInfo.setAvgTime(nowProcessData.getAvgTime());
        cardInfo.setRunTime(nowProcessData.getCount());
        if (qoqProcessData != null) {
            BigDecimal qoqTotalTimeRate = OtcProcessHelper.getRate(nowProcessData.getTotalTime(), qoqProcessData.getTotalTime());
            BigDecimal qoqAvgTimeRate = OtcProcessHelper.getRate(nowProcessData.getAvgTime(), qoqProcessData.getAvgTime());
            BigDecimal qoqCountRate = OtcProcessHelper.getRate(nowProcessData.getCount(), qoqProcessData.getCount());
            cardInfo.setQoqTotalTimeRate(qoqTotalTimeRate);
            cardInfo.setQoqAvgTimeRate(qoqAvgTimeRate);
            cardInfo.setQoqRunTimeRate(qoqCountRate);
        }
        if (yoyProcessData != null) {
            BigDecimal yoyTotalTimeRate = OtcProcessHelper.getRate(nowProcessData.getTotalTime(), yoyProcessData.getTotalTime());
            BigDecimal yoyAvgTimeRate = OtcProcessHelper.getRate(nowProcessData.getAvgTime(), yoyProcessData.getAvgTime());
            BigDecimal yoyCountRate = OtcProcessHelper.getRate(nowProcessData.getCount(), yoyProcessData.getCount());
            cardInfo.setYoyTotalTimeRate(yoyTotalTimeRate);
            cardInfo.setYoyAvgTimeRate(yoyAvgTimeRate);
            cardInfo.setYoyRunTimeRate(yoyCountRate);
        }
        return cardInfo;
    }

    private static BigDecimal getRate(BigDecimal currentData, BigDecimal lastData) {
        if (lastData == null || lastData.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return currentData.subtract(lastData).divide(lastData, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(0, RoundingMode.HALF_UP);
    }

    private static ProcessTimeInfo getProcessHistoryData(Long processId, Date startDate, Date enddate) {
        QFilter qFilter = new QFilter("processdefinitionid", "=", (Object)processId);
        qFilter.and(new QFilter("createdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("endtime", "<=", (Object)enddate));
        DataSet history = QueryServiceHelper.queryDataSet((String)OtcProcessHelper.class.getName(), (String)"wf_hiprocinst", (String)"id,processdefinitionid,realdurationinmillis", (QFilter[])new QFilter[]{qFilter}, null);
        int count = history.copy().count("id", false);
        if (count == 0) {
            return null;
        }
        DataSet totalTimeDataSet = history.groupBy(new String[]{"processdefinitionid"}).sum("realdurationinmillis").finish();
        Integer durationMillis = 0;
        if (totalTimeDataSet.hasNext()) {
            Row next = totalTimeDataSet.next();
            durationMillis = next.getInteger("realdurationinmillis");
        }
        totalTimeDataSet.close();
        BigDecimal totalTime = new BigDecimal(durationMillis).divide(new BigDecimal("3600000"), 2, RoundingMode.HALF_UP);
        BigDecimal avgTime = totalTime.divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
        ProcessTimeInfo processTimeInfo = new ProcessTimeInfo();
        processTimeInfo.setTotalTime(totalTime);
        processTimeInfo.setCount(new BigDecimal(count));
        processTimeInfo.setAvgTime(avgTime);
        return processTimeInfo;
    }
}

