/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scmc.scmdi.business.judge.core.RuleEntryEditor;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.vo.bos.BosEntity;
import kd.scmc.scmdi.common.vo.bos.BosUser;
import kd.scmc.scmdi.common.vo.bos.UseStatusEnum;
import kd.scmc.scmdi.form.common.utils.DynamicToMapUtils;
import kd.scmc.scmdi.form.common.utils.StringTemplateUtils;
import kd.scmc.scmdi.form.enumeration.solution.ProcessStatusEnum;
import kd.scmc.scmdi.form.enumeration.solution.ProcessWayEnum;
import kd.scmc.scmdi.form.enumeration.warning.ExecType;
import kd.scmc.scmdi.form.enumeration.warning.UpgradePolicy;
import kd.scmc.scmdi.form.enumeration.warning.UpgradeStatus;
import kd.scmc.scmdi.form.enumeration.warning.WarningLevelEnum;
import kd.scmc.scmdi.form.handler.upgrade.UpgradeRuleProvider;
import kd.scmc.scmdi.form.vo.warning.DynamicField;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;
import kd.scmc.scmdi.form.vo.warning.WarningResult;
import kd.scmc.scmdi.form.vo.warning.WarningRule;
import org.apache.commons.lang3.StringUtils;

public class WarningResultHandler {
    private final WarnConfig warnConfig;
    public static final String MASTERID = "masterid";
    public static final String NAME = "name";
    private static final Set<String> IGNORED_PROPERTIES_WARNING = Sets.newHashSet((Object[])new String[]{"id", "billno", "creator", "createtime", "modifier", "modifytime", "auditor", "auditdate"});
    private static final Set<String> IGNORED_PROPERTIES_UPGRADE = Sets.newHashSet((Object[])new String[]{"id", "title", "content", "exec_type", "notified_users", "warninglevel", "processor", "processingtime", "orient_result_identity", "duplicated_count", "upgrade_status"});

    public WarningResultHandler(WarnConfig warnConfig) {
        this.warnConfig = warnConfig;
    }

    public DynamicObject getWarningResult(DynamicObject record, DynamicObject matchedWarningData, String filterConditionRead, MetricMapping metricMapping, WarningRule warningRule) {
        Map<String, Object> contextMap = this.getContextMap(matchedWarningData, warningRule);
        String titleTemplate = warningRule.getMonitorNotifyTitle();
        String contentTemplate = warningRule.getMonitorNotifyContentTag();
        String title = StringTemplateUtils.getTextFromTemplate(titleTemplate, contextMap);
        String content = StringTemplateUtils.getTextFromTemplate(contentTemplate, contextMap);
        BosEntity warningResultPersist = this.warnConfig.getWarningResultPersist();
        DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)warningResultPersist.getNumber());
        target.set("billno", (Object)record.getString("billno"));
        target.set("warning_record", record.getPkValue());
        target.set("warning_config", (Object)this.warnConfig.getDynamicObject());
        target.set("warninglevel", (Object)warningRule.getWarningLevel());
        target.set("warning_object", (Object)this.warnConfig.getWarningObject().getId());
        target.set("warning_title", (Object)CommonUtils.subString((String)title, (int)255));
        target.set("warning_title_tag", (Object)title);
        target.set("warning_content", (Object)content);
        target.set("filter_condition_read_tag", (Object)filterConditionRead);
        target.set("processingstatus", (Object)ProcessStatusEnum.UNPROCESSED.getStatusCode());
        target.set("upgrade_status", (Object)UpgradeStatus.N.name());
        target.set("exec_type", (Object)record.getString("exec_type"));
        if (RequestContext.get() != null) {
            target.set("creator", (Object)RequestContext.get().getCurrUserId());
        }
        DataEntityPropertyCollection fromProperties = matchedWarningData.getDataEntityType().getProperties();
        DataEntityPropertyCollection targetProperties = target.getDataEntityType().getProperties();
        fromProperties.forEach(fromProperty -> {
            if (!IGNORED_PROPERTIES_WARNING.contains(fromProperty.getName()) && targetProperties.containsKey((Object)fromProperty.getName())) {
                target.set(fromProperty.getName(), fromProperty.getValue((Object)matchedWarningData));
            }
        });
        target.set("warning_result_object", (Object)warningResultPersist.getNumber());
        Map<String, Object> dynamicFields = WarningResultHandler.getDynamicFields(matchedWarningData, metricMapping, fromProperties);
        target.set("dynamic_fields_tag", (Object)JSON.toJSONString(dynamicFields));
        String fingerPrint = metricMapping.generateFingerPrint(target);
        target.set("fingerprint_tag", (Object)fingerPrint);
        String fingerPrintHashCode = String.valueOf(fingerPrint.hashCode());
        target.set("fingerprint_hash", (Object)fingerPrintHashCode);
        target.set("processingway", (Object)ProcessWayEnum.NOT_HAVE.getValue());
        target.set("ismark", (Object)true);
        return target;
    }

    public Boolean executeRowRule(DynamicObject record, DynamicObject matchedWarningData, String filterConditionRead, MetricMapping metricMapping, WarningRule warningRule) {
        DynamicObject target = this.getWarningResult(record, matchedWarningData, filterConditionRead, metricMapping, warningRule);
        this.getNeedMarkData(metricMapping, target, this.warnConfig);
        Optional<WarningResult> duplicatedData = this.getDuplicatedData(metricMapping, warningRule, target, this.warnConfig);
        this.handleUpGrade(record, metricMapping, warningRule, target, duplicatedData);
        if (!duplicatedData.isPresent()) {
            OperationServiceHelper.executeOperate((String)"save", (String)target.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{target});
        }
        return duplicatedData.isPresent();
    }

    public void handleUpGrade(DynamicObject record, MetricMapping metricMapping, WarningRule warningRule, DynamicObject target, Optional<WarningResult> duplicatedData) {
        boolean duplicated = duplicatedData.isPresent();
        if (duplicated) {
            DynamicObject orientData = this.setDuplicated(duplicatedData.get());
            this.recordRiddingLog(record, orientData, target, metricMapping);
            this.upgrade(orientData);
        } else {
            String title = target.getString("warning_title_tag");
            String content = target.getString("warning_content");
            this.notifyToUsers(title, content, warningRule.getMonitorNotifyUsers(), warningRule.getMonitorNotifyTypes(), target);
        }
    }

    public Optional<WarningResult> getDuplicatedData(MetricMapping metricMapping, WarningRule warningRule, DynamicObject warningResult, WarnConfig config) {
        Optional<WarningResult> duplicatedData;
        boolean ridding;
        boolean bl = ridding = config.getEnableWarningRidding() != false && config.getWarningRidding().getEnable() == UseStatusEnum.ENABLED;
        if (ridding) {
            String fingerPrint = warningResult.getString("fingerprint_tag");
            String fingerPrintHashCode = String.valueOf(fingerPrint.hashCode());
            BosEntity warningResultPersist = config.getWarningResultPersist();
            DynamicObject[] orientDataList = BusinessDataServiceHelper.load((String)warningResultPersist.getNumber(), (String)(metricMapping.getBizFieldKeys().stream().collect(Collectors.joining(",")) + ",warning_config,createtime,fingerprint_tag,duplicated_count,upgrade_status,warninglevel"), (QFilter[])new QFilter[]{new QFilter("fingerprint_hash", "=", (Object)fingerPrintHashCode), new QFilter("warning_config", "=", (Object)config.getId()), new QFilter("warninglevel", "=", (Object)warningRule.getWarningLevel()), new QFilter("exec_type", "!=", (Object)ExecType.UPGRADE.name()), new QFilter("processingstatus", "=", (Object)ProcessStatusEnum.UNPROCESSED.getStatusCode())});
            duplicatedData = DynamicDataMapper.convertCollection((DynamicObject[])orientDataList, WarningResult.class).stream().filter(orientData -> orientData.checkFingerPrint(fingerPrint)).sorted((d1, d2) -> d2.getCreatetime().compareTo(d1.getCreatetime())).findFirst();
        } else {
            duplicatedData = Optional.empty();
        }
        return duplicatedData;
    }

    public void getNeedMarkData(MetricMapping metricMapping, DynamicObject warningResult, WarnConfig config) {
        Boolean needMark = config.getEnableAutoCancel();
        if (needMark != null && needMark.booleanValue()) {
            DynamicObject[] needMarkData;
            String fingerPrint = warningResult.getString("fingerprint_tag");
            String fingerPrintHashCode = String.valueOf(fingerPrint.hashCode());
            BosEntity warningResultPersist = config.getWarningResultPersist();
            for (DynamicObject result : needMarkData = BusinessDataServiceHelper.load((String)warningResultPersist.getNumber(), (String)(String.join((CharSequence)",", metricMapping.getBizFieldKeys()) + ",warning_config,createtime,fingerprint_tag,duplicated_count,upgrade_status,warninglevel,ismark"), (QFilter[])new QFilter[]{new QFilter("fingerprint_hash", "=", (Object)fingerPrintHashCode), new QFilter("warning_config", "=", (Object)config.getId()), new QFilter("processingstatus", "=", (Object)ProcessStatusEnum.UNPROCESSED.getStatusCode())})) {
                result.set("ismark", (Object)true);
            }
            SaveServiceHelper.update((DynamicObject[])needMarkData);
        }
    }

    public void autoCancelResult() {
        DynamicObject[] changeMarkData;
        Boolean enableAutoCancel = this.warnConfig.getEnableAutoCancel();
        if (enableAutoCancel == null || Boolean.FALSE.equals(enableAutoCancel)) {
            return;
        }
        DynamicObject[] needCancelData = this.getNeedCancelData();
        if (needCancelData.length > 0) {
            ArrayList<Long> idList = new ArrayList<Long>(needCancelData.length);
            for (DynamicObject data2 : needCancelData) {
                data2.set("processingway", (Object)ProcessWayEnum.AUTO_CANCEL.getValue());
                data2.set("processingstatus", (Object)ProcessStatusEnum.PROCESSED.getStatusCode());
                data2.set("processor", (Object)1L);
                data2.set("processingtime", (Object)new Date());
                idList.add((Long)data2.getPkValue());
            }
            this.queryAndRecordProcessLog(needCancelData, idList);
            SaveServiceHelper.update((DynamicObject[])needCancelData);
        }
        if ((changeMarkData = BusinessDataServiceHelper.load((String)this.warnConfig.getWarningResultPersist().getNumber(), (String)"id,billno,processingway,ismark", (QFilter[])new QFilter[]{new QFilter("ismark", "=", (Object)true)})).length > 0) {
            Arrays.stream(changeMarkData).forEach(data -> data.set("ismark", (Object)false));
            SaveServiceHelper.update((DynamicObject[])changeMarkData);
        }
    }

    private DynamicObject[] getNeedCancelData() {
        String entityNumber = this.warnConfig.getWarningResultPersist().getNumber();
        Long id = this.warnConfig.getId();
        QFilter idFilter = new QFilter("warning_config", "=", (Object)id);
        QFilter markFilter = new QFilter("ismark", "=", (Object)false);
        QFilter wayFilter = new QFilter("processingway", "=", (Object)ProcessWayEnum.NOT_HAVE.getValue());
        DynamicObject[] needCancelData = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,billno,processingway,processingstatus,ismark,processor,processingtime", (QFilter[])new QFilter[]{idFilter, markFilter, wayFilter});
        return needCancelData;
    }

    private void queryAndRecordProcessLog(DynamicObject[] needCancelData, List<Long> idList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(needCancelData.length);
        QFilter qFilter = new QFilter("warnresult", "in", idList);
        DynamicObject[] processLogData = BusinessDataServiceHelper.load((String)"scmdi_warning_process_log", (String)"id,warnresult,entryentity.operateway,entryentity.processtime,entryentity.processby,entryentity.processway", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject data : needCancelData) {
            Object pkValue = data.getPkValue();
            boolean flag = false;
            for (DynamicObject processLog : processLogData) {
                Long warningResult = processLog.getLong("warnresult");
                if (warningResult.compareTo((Long)pkValue) != 0) continue;
                this.recordProcessLog(processLog);
                list.add(processLog);
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"scmdi_warning_process_log");
            log.set("warnresult", pkValue);
            this.recordProcessLog(log);
            list.add(log);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private void recordProcessLog(DynamicObject processLog) {
        DynamicObjectCollection logEntry = processLog.getDynamicObjectCollection("entryentity");
        DynamicObject logRow = logEntry.addNew();
        logRow.set("operateway", (Object)"2");
        logRow.set("processtime", (Object)new Date());
        logRow.set("processby", (Object)1L);
        logRow.set("processway", (Object)"1");
    }

    public static String getPropertyValue(Object property) {
        if (property == null) {
            return "";
        }
        if (property instanceof DynamicObject) {
            DynamicObject baseData = (DynamicObject)property;
            return String.valueOf(baseData.getPkValue());
        }
        if (property instanceof BigDecimal) {
            return ((BigDecimal)property).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(property);
    }

    public static String getDisplayValue(IDataEntityProperty entityProperty, Object property) {
        if (property == null) {
            return "-";
        }
        if (property instanceof DynamicObject) {
            BasedataProp basedataProp = (BasedataProp)entityProperty;
            return basedataProp.getDisplayValue(property);
        }
        if (property instanceof BigDecimal) {
            return ((BigDecimal)property).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(property);
    }

    private static Map<String, Object> getDynamicFields(DynamicObject warningObject, MetricMapping metricMapping, DataEntityPropertyCollection fromProperties) {
        List metricMappingEntry = metricMapping.getMetricMappingEntry();
        List metricAndDimensionFields = metricMappingEntry.stream().filter(entry -> fromProperties.containsKey((Object)entry.getBizEntityFieldKey())).map(property -> {
            DynamicField dynamicField = new DynamicField();
            dynamicField.setFieldName(property.getBizEntityFieldName());
            dynamicField.setKey(property.getBizEntityFieldKey());
            dynamicField.setValue(WarningResultHandler.getPropertyValue(warningObject.get(property.getBizEntityFieldKey())));
            IDataEntityProperty entityProperty = (IDataEntityProperty)fromProperties.get((Object)property.getBizEntityFieldKey());
            dynamicField.setDisplayValue(WarningResultHandler.getDisplayValue(entityProperty, warningObject.get(property.getBizEntityFieldKey())));
            if (entityProperty != null) {
                dynamicField.setFiledType(entityProperty.getClass().getName());
            }
            if (entityProperty instanceof BasedataProp) {
                String baseEntityId = ((BasedataProp)entityProperty).getBaseEntityId();
                dynamicField.setBaseDataEntityId(baseEntityId);
            }
            return dynamicField;
        }).collect(Collectors.toList());
        HashMap<String, Object> dynamicFields = new HashMap<String, Object>(1);
        dynamicFields.put("fromMetric", metricAndDimensionFields);
        return dynamicFields;
    }

    private void recordRiddingLog(DynamicObject record, DynamicObject orientData, DynamicObject target, MetricMapping metricMapping) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"scmdi_warn_ridding_log");
        log.set("warning_record", (Object)record);
        log.set("createtime", (Object)new Date());
        log.set("warning_object", target.get("warning_object"));
        log.set("filter_condition_read_tag", target.get("filter_condition_read_tag"));
        log.set("warninglevel", target.get("warninglevel"));
        log.set("rdiding_data_table", (Object)orientData.getDataEntityType().getName());
        log.set("rdiding_data", orientData.getPkValue());
        log.set("creator", target.get("creator"));
        List mappingEntries = metricMapping.getMetricMappingEntry();
        DynamicObjectCollection logEntry = log.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = target.getDataEntityType().getProperties();
        AtomicInteger seq = new AtomicInteger();
        mappingEntries.forEach(metricMappingEntry -> {
            String bizEntityFieldKey = metricMappingEntry.getBizEntityFieldKey();
            if (!properties.containsKey((Object)bizEntityFieldKey)) {
                return;
            }
            DynamicObject entryRow = logEntry.addNew();
            Object value = target.get(bizEntityFieldKey);
            value = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
            entryRow.set("field_key", (Object)bizEntityFieldKey);
            entryRow.set("field_name", (Object)metricMappingEntry.getBizEntityFieldName());
            entryRow.set("field_value", value);
            entryRow.set("field_class_type", (Object)((IDataEntityProperty)properties.get((Object)bizEntityFieldKey)).getPropertyType().getName());
            entryRow.set("metric_field_type", (Object)metricMappingEntry.getFieldType().name());
            if (properties.get((Object)bizEntityFieldKey) instanceof BasedataProp) {
                entryRow.set("entity_type", (Object)((BasedataProp)properties.get((Object)bizEntityFieldKey)).getComplexType().getName());
            }
            entryRow.set("seq", (Object)seq.getAndIncrement());
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private DynamicObject setDuplicated(WarningResult warningResult) {
        String tableName = warningResult.getDynamicObject().getDataEntityType().getAlias();
        DB.execute((DBRoute)new DBRoute("scm"), (String)("update " + tableName + " set fduplicated_count=fduplicated_count+1 where fid=?"), (Object[])new Object[]{warningResult.getId()});
        return BusinessDataServiceHelper.loadSingle((Object)warningResult.getId(), (String)warningResult.getDynamicObject().getDataEntityType().getName());
    }

    private void notifyToUsers(String title, String content, List<BosUser> notifyUsers, List<String> monitorNotifyTypes, DynamicObject target) {
        List<Long> userIds = notifyUsers.stream().map(BosUser::getId).collect(Collectors.toList());
        MessageInfo info = new MessageInfo();
        info.setTitle(title);
        info.setContent(content);
        info.setUserIds(userIds);
        info.setType("warning");
        info.setEntityNumber(this.warnConfig.getDynamicObject().getDataEntityType().getName());
        LocaleString messageTag = new LocaleString();
        messageTag.setLocaleValue_en("bec");
        messageTag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e2d\u5fc3", (String)"PreWarningRuleCalculateObj_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        info.setMessageTag((ILocaleString)messageTag);
        info.setNotifyType(monitorNotifyTypes.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t) && !t.equals("message_center")).collect(Collectors.joining(",")));
        info.setTplScene(ResManager.loadKDString((String)"\u6d88\u606f\u573a\u666f\u7f16\u7801", (String)"PreWarningRuleCalculateObj_1", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        info.setTemplateNumber(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"PreWarningRuleCalculateObj_2", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        MessageCenterServiceHelper.sendMessage((MessageInfo)info);
        WarningResultHandler.setNotifyUsers(target, userIds);
    }

    private static void setNotifyUsers(DynamicObject target, List<Long> userIds) {
        DynamicObject[] userEntities = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds.toArray(new Long[userIds.size()]))});
        DynamicObjectCollection users = target.getDynamicObjectCollection("notified_users");
        DynamicObjectCollection targetUserCollection = new DynamicObjectCollection();
        for (DynamicObject targetUser : userEntities) {
            DynamicObject tempDyObj = new DynamicObject(users.getDynamicObjectType());
            tempDyObj.set("fbasedataid", (Object)targetUser);
            targetUserCollection.add((Object)tempDyObj);
        }
        target.set("notified_users", (Object)targetUserCollection);
    }

    private Map<String, Object> getContextMap(DynamicObject matchedWarningData, WarningRule warningRule) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("cfg", DynamicToMapUtils.convertDynamicObjectToMap(this.warnConfig.getDynamicObject()));
        Map<String, Object> runtimeMap = DynamicToMapUtils.convertDynamicObjectToMap(matchedWarningData);
        resultMap.put("runtime", runtimeMap);
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        ruleMap.put("warninglevel", WarningLevelEnum.getDescByValue(warningRule.getWarningLevel()));
        resultMap.put("rule", ruleMap);
        return resultMap;
    }

    private boolean upgradeRuleMatched(DynamicObject warningResult) {
        if (!this.warnConfig.getUpgradeEnabled().booleanValue()) {
            return false;
        }
        String upgradeStatus = warningResult.getString("upgrade_status");
        if (upgradeStatus.equals(UpgradeStatus.Y.name())) {
            return false;
        }
        RuleEntryEditor ruleEntryEditor = UpgradeRuleProvider.getRuleEntryEditor();
        return ruleEntryEditor.judge(this.warnConfig.getDynamicObject(), warningResult);
    }

    public void upgrade(DynamicObject orientResult) {
        if (this.upgradeRuleMatched(orientResult)) {
            this.addUpgradeWarningResult(orientResult);
        }
    }

    private void addUpgradeWarningResult(DynamicObject orientResult) {
        Integer warningLevel = Integer.valueOf(orientResult.getString("warninglevel"));
        UpgradePolicy upgradePolicy = this.warnConfig.getUpgradePolicy();
        Integer nextLevel = upgradePolicy.getNextLevel(warningLevel, this.warnConfig);
        if (nextLevel == null) {
            return;
        }
        DynamicObject wholeWarningResult = BusinessDataServiceHelper.loadSingle((Object)orientResult.getPkValue(), (String)orientResult.getDataEntityType().getName());
        wholeWarningResult.set("upgrade_status", (Object)UpgradeStatus.Y.name());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{wholeWarningResult});
        WarningResult warningResult = (WarningResult)DynamicDataMapper.convert((DynamicObject)wholeWarningResult, WarningResult.class);
        WarningResult orientWarningResult = warningResult.getOrientWarningResult();
        IDataEntityType dataEntityType = wholeWarningResult.getDataEntityType();
        DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)dataEntityType.getName());
        DataEntityPropertyCollection fromProperties = dataEntityType.getProperties();
        fromProperties.forEach(fromProperty -> {
            if (!IGNORED_PROPERTIES_UPGRADE.contains(fromProperty.getName())) {
                target.set(fromProperty.getName(), fromProperty.getValue((Object)wholeWarningResult));
            }
        });
        target.set("exec_type", (Object)ExecType.UPGRADE.name());
        String title = ResManager.loadKDString((String)"\u3010\u9884\u8b66\u5347\u7ea7\u3011", (String)"WarningResultHandler_UPGRADE_title", (String)"scmc-scmdi-form", (Object[])new Object[0]) + orientWarningResult.getWarningTitle();
        String content = orientWarningResult.getWarningContent() + ResManager.loadKDString((String)"\u3010\u5f53\u524d\u6d88\u606f\u4e3a\u9884\u8b66\u81ea\u52a8\u5347\u7ea7\u540e\u6240\u53d1\u9001\u6d88\u606f\u3011", (String)"WarningResultHandler_UPGRADE_content", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        target.set("warning_title", (Object)CommonUtils.subString((String)title, (int)255));
        target.set("warning_title_tag", (Object)title);
        target.set("warning_content", (Object)content);
        target.set("warninglevel", (Object)nextLevel);
        target.set("orient_result_identity", orientResult.getPkValue());
        target.set("createtime", (Object)new Date());
        target.set("upgrade_status", (Object)UpgradeStatus.N.name());
        List<String> upgradeNotifyType = this.warnConfig.getUpgradeNotifyType();
        List<BosUser> upgradeNotifyUser = this.warnConfig.getUpgradeNotifyUser();
        if (CommonUtils.isAnyNullOrEmpty((Object[])new Object[]{upgradeNotifyType, upgradeNotifyUser})) {
            String primitiveWarningLevel = this.getPrimitiveWarningLevel(orientResult);
            WarningRule warningRule = this.warnConfig.getRuleEntry().stream().filter(w -> w.getWarningLevel().equals(primitiveWarningLevel)).findFirst().get();
            this.notifyToUsers(title, content, warningRule.getMonitorNotifyUsers(), warningRule.getMonitorNotifyTypes(), target);
        } else {
            this.notifyToUsers(title, content, upgradeNotifyUser, upgradeNotifyType, target);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)dataEntityType.getName(), (DynamicObject[])new DynamicObject[]{target});
    }

    private String getPrimitiveWarningLevel(DynamicObject warningResult) {
        String entityKey = warningResult.getDataEntityType().getName();
        long orientResultId = warningResult.getLong("orient_result_identity");
        if (orientResultId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)orientResultId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityKey, (String)"orient_result_identity,warninglevel", (QFilter[])qFilter.toArray());
            return this.getPrimitiveWarningLevel(dynamicObject);
        }
        return warningResult.getString("warninglevel");
    }
}

