/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.common.vo.bos.BosEntity;
import kd.scmc.scmdi.form.common.utils.StringTemplateUtils;
import kd.scmc.scmdi.form.common.utils.TreeUtils;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;
import org.joda.time.DateTime;

public class DynamicToMapUtils {
    private static final Map<Class<? extends DynamicProperty>, BiFunction<DynamicProperty, Object, Object>> HANDLER_MAP = new LinkedHashMap<Class<? extends DynamicProperty>, BiFunction<DynamicProperty, Object, Object>>();

    public static Map<String, Object> convertDynamicObjectToMap(DynamicObject dynamicObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        properties.forEach(property -> {
            Object value = property.getValue((Object)dynamicObject);
            Optional<Map.Entry> first = HANDLER_MAP.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(property.getClass())).findFirst();
            if (first.isPresent()) {
                map.put(property.getName(), ((BiFunction)first.get().getValue()).apply((DynamicProperty)property, value));
                return;
            }
            map.put(property.getName(), value);
        });
        return map;
    }

    public static List<TreeNode> getTreeNodes(WarnConfig warnConfig) {
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>();
        TreeNode node = TreeUtils.of(ResManager.loadKDString((String)"\u9884\u8b66\u65b9\u6848", (String)"EarlyWarningConfigPlugin_6", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        rootNodes.add(node);
        node.addChild(TreeUtils.of(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801", (String)"EarlyWarningConfigPlugin_7", (String)"scmc-scmdi-form", (Object[])new Object[0]), DynamicToMapUtils.getMapSupplier("cfg['number']")));
        node.addChild(TreeUtils.of(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"EarlyWarningConfigPlugin_8", (String)"scmc-scmdi-form", (Object[])new Object[0]), DynamicToMapUtils.getMapSupplier("cfg['name']")));
        TreeNode warningObjectNodeRoot = TreeUtils.of(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61", (String)"EarlyWarningConfigPlugin_10", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        node.addChild(warningObjectNodeRoot);
        BosEntity warnObj = warnConfig.getWarningObject();
        TreeNode warningObjectNode = TreeUtils.of(warnObj.getName());
        warningObjectNodeRoot.addChild(warningObjectNode);
        List<TreeNode> extracted = DynamicToMapUtils.getExpandedWarningObjectTree(warnObj.getNumber(), 0, 3, "runtime");
        warningObjectNode.addChildren(extracted);
        TreeNode warningRuleNodeRoot = TreeUtils.of(ResManager.loadKDString((String)"\u9884\u8b66\u89c4\u5219", (String)"EarlyWarningConfigPlugin_20", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        node.addChild(warningRuleNodeRoot);
        TreeNode warningLevel = TreeUtils.of(ResManager.loadKDString((String)"\u9884\u8b66\u7ea7\u522b", (String)"EarlyWarningConfigPlugin_21", (String)"scmc-scmoc-form", (Object[])new Object[0]), DynamicToMapUtils.getMapSupplier("rule['warninglevel']"));
        warningRuleNodeRoot.addChild(warningLevel);
        return rootNodes;
    }

    private static List<TreeNode> getExpandedWarningObjectTree(String entityNumber, int currentDepth, int maxDepth, String contextRoot) {
        MainEntityType warningObjectEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        Set warningObjectEntityFields = warningObjectEntityType.getAllFields().entrySet();
        return warningObjectEntityFields.stream().filter(warningObjectEntityField -> {
            IDataEntityProperty fieldProperty = (IDataEntityProperty)warningObjectEntityField.getValue();
            if (fieldProperty.getParent() instanceof EntryType) {
                return false;
            }
            if (fieldProperty instanceof FlexProp) {
                return false;
            }
            return fieldProperty instanceof TextProp || fieldProperty instanceof DecimalProp || fieldProperty instanceof BasedataProp;
        }).map(mapEntry -> {
            IDataEntityProperty fieldProperty = (IDataEntityProperty)mapEntry.getValue();
            TreeNode warningObjectFieldNode = TreeUtils.of(fieldProperty.getDisplayName().toString());
            String dataGetKey = contextRoot + "?.get('" + (String)mapEntry.getKey() + "')";
            if (fieldProperty instanceof BasedataProp) {
                if (maxDepth > currentDepth) {
                    warningObjectFieldNode.addChildren(DynamicToMapUtils.getExpandedWarningObjectTree(((BasedataProp)fieldProperty).getBaseEntityId(), currentDepth + 1, maxDepth, dataGetKey));
                }
            } else {
                warningObjectFieldNode.setData(DynamicToMapUtils.getMapSupplier(dataGetKey).get());
            }
            warningObjectFieldNode.setIsOpened(false);
            warningObjectFieldNode.setExpend(false);
            return warningObjectFieldNode;
        }).collect(Collectors.toList());
    }

    private static Supplier getMapSupplier(String expressionText) {
        Supplier<Map> mapSupplier = () -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expressionText", StringTemplateUtils.wrapVariable(expressionText));
            return map;
        };
        return mapSupplier;
    }

    static {
        HANDLER_MAP.put(ComboProp.class, (arg1, arg2) -> {
            ComboProp comboProp = (ComboProp)arg1;
            String itemByName = comboProp.getItemByName((String)arg2);
            return itemByName;
        });
        HANDLER_MAP.put(MuliLangTextProp.class, (arg1, arg2) -> arg2.toString());
        HANDLER_MAP.put(EntryProp.class, (arg1, arg2) -> {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)arg2;
            return dynamicObjectCollection.stream().map(DynamicToMapUtils::convertDynamicObjectToMap).collect(Collectors.toList());
        });
        HANDLER_MAP.put(DynamicLocaleProperty.class, (arg1, arg2) -> {
            Optional<DynamicObject> any = ((LocaleDynamicObjectCollection)arg2).stream().filter(l -> l.get("localeid").equals("zh_CN")).findAny();
            try {
                return any.isPresent() ? any.get().get("name") : "null";
            }
            catch (Exception e) {
                return "\u7a7a\u503c";
            }
        });
        HANDLER_MAP.put(BasedataProp.class, (arg1, arg2) -> arg2 == null ? new HashMap() : DynamicToMapUtils.convertDynamicObjectToMap((DynamicObject)arg2));
        HANDLER_MAP.put(DateTimeProp.class, (arg1, arg2) -> arg2 == null ? "" : new DateTime(arg2).toString("yyyy-MM-dd"));
        HANDLER_MAP.put(DecimalProp.class, (arg1, arg2) -> {
            if (arg2 == null) {
                return "0";
            }
            BigDecimal decimal = new BigDecimal(arg2.toString());
            if (decimal.doubleValue() == (double)decimal.longValue()) {
                return decimal.longValue();
            }
            return decimal.doubleValue();
        });
        HANDLER_MAP.put(DecimalProp.class, (arg1, arg2) -> {
            if (arg2 == null) {
                return "0";
            }
            BigDecimal decimal = new BigDecimal(arg2.toString());
            if (decimal.doubleValue() == (double)decimal.longValue()) {
                return decimal.longValue();
            }
            return decimal.doubleValue();
        });
    }
}

