/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.utils;

import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public class StringTemplateUtils {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    public static String getTextFromTemplate(String template, Map<String, ? extends Object> map) {
        template = template.trim();
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext templateParserContext = new TemplateParserContext(PREFIX, SUFFIX);
        Expression expression = parser.parseExpression(template, (ParserContext)templateParserContext);
        SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
        map.entrySet().forEach(v -> context.setVariable((String)v.getKey(), v.getValue()));
        Object text = expression.getValue((EvaluationContext)context, String.class);
        return text.toString();
    }

    public static String wrapVariable(String variable) {
        return "${#" + variable + SUFFIX;
    }
}

