/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;

public class TreeUtils {
    public static TreeNode of(String text) {
        return TreeUtils.of(text, new HashMap<String, Object>());
    }

    public static TreeNode of(String text, Map<String, Object> map) {
        TreeNode node = new TreeNode();
        node.setId(map == null || map.isEmpty() ? UUID.randomUUID().toString() : map.toString());
        node.setLeaf(true);
        node.setText(text);
        node.setLongText(text);
        node.setExpend(true);
        node.setIsOpened(true);
        node.setData(map);
        return node;
    }

    public static TreeNode of(String text, Supplier<Map<String, Object>> supplier) {
        return TreeUtils.of(text, supplier.get());
    }

    private static TreeNode getTreeOfMeta(String entityKey, int currentDepth) {
        if (currentDepth > 1) {
            return null;
        }
        MainEntityType metricEntity = MetadataServiceHelper.getDataEntityType((String)entityKey);
        TreeNode warningObjectNode = TreeUtils.of(metricEntity.getDisplayName().getLocaleValue());
        Set metricFields = metricEntity.getAllFields().entrySet();
        metricFields.stream().forEach(metricField -> {
            BasedataProp materialProp;
            TreeNode treeOfMeta;
            LocaleString displayName = ((IDataEntityProperty)metricField.getValue()).getDisplayName();
            if (displayName == null) {
                return;
            }
            IDataEntityProperty value = (IDataEntityProperty)metricField.getValue();
            if (value instanceof CreaterProp || value instanceof ModifierProp) {
                return;
            }
            TreeNode warningObjectFieldNode = TreeUtils.of(displayName.toString());
            warningObjectFieldNode.setIsOpened(true);
            warningObjectFieldNode.setExpend(true);
            if (!(value instanceof FlexProp) && value instanceof BasedataProp && (treeOfMeta = TreeUtils.getTreeOfMeta((materialProp = (BasedataProp)value).getBaseEntityId(), currentDepth + 1)) != null) {
                warningObjectFieldNode.addChildren(treeOfMeta.getChildren());
            }
            warningObjectNode.addChild(warningObjectFieldNode);
        });
        return warningObjectNode;
    }
}

