/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.utils.colsselect;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.scmc.scmdi.form.common.utils.colsselect.DataSourceConfigHelper;
import kd.scmc.scmdi.form.common.utils.colsselect.PropertyNode;
import org.apache.commons.lang3.StringUtils;

public interface IColsSelectStrategy {
    public static final Integer PROPERTY_MAX_LEVEL = 6;

    default public boolean fixedFilter(IDataEntityProperty pro) {
        return StringUtils.isNotBlank((CharSequence)pro.getAlias());
    }

    default public TreeNode getTreeNode(String parentId, String id, String text) {
        return new TreeNode(parentId, id, text);
    }

    public void buildHeadPropNode(PropertyNode var1, IDataEntityProperty var2);

    default public String getTreeNodeProType(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        String treeNodeType = null;
        if (prop instanceof BasedataProp) {
            treeNodeType = ((BasedataProp)prop).getBaseEntityId();
        } else if (prop instanceof DateTimeProp) {
            treeNodeType = ((SimpleDateFormat)((DateTimeProp)prop).getDateFormat()).toPattern();
        } else if (prop instanceof ISimpleProperty && ((ISimpleProperty)prop).isPrimaryKey()) {
            IDataEntityType parentProp = prop.getParent();
            if (parentProp instanceof MainEntityType) {
                treeNodeType = ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u4e3b\u952e", (String)"IColsSelectStrategy_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            } else if (parentProp instanceof EntryType) {
                treeNodeType = ResManager.loadKDString((String)"\u5206\u5f55\u4e3b\u952e", (String)"IColsSelectStrategy_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            }
        } else {
            treeNodeType = prop.getClass().getTypeName();
        }
        return StringUtils.isEmpty((CharSequence)treeNodeType) ? prop.getClass().getSimpleName() : treeNodeType;
    }

    default public void setTxtFieldLenAndEntryKey(TreeNode treeNode, IDataEntityProperty field) {
        int minLength = field instanceof TextProp ? ((TextProp)field).getMinLenth() : 0;
        int maxLength = field instanceof TextProp ? ((TextProp)field).getMaxLenth() : 0;
        Map<String, String> entityTypeMap = DataSourceConfigHelper.getEntityTypeMap(field);
        Map.Entry<String, String> entityType = entityTypeMap.entrySet().iterator().next();
        String entryKey = entityType.getKey();
        String entryName = entityType.getValue();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("minlength", minLength);
        data.put("maxlength", maxLength);
        data.put("entrykey", entryKey);
        data.put("entryname", entryName);
        data.put("fieldName", field.getName());
        treeNode.setData(data);
    }

    default public int getPropertyMaxLevel() {
        return PROPERTY_MAX_LEVEL;
    }
}

