/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.common.utils.colsselect;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.form.common.utils.colsselect.IColsSelectStrategy;
import kd.scmc.scmdi.form.common.utils.colsselect.PcColumnSelectStrategy;
import kd.scmc.scmdi.form.common.utils.colsselect.PropertyNode;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType mainEntityType;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"MetaHelper:\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaHelper_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        this.mainEntityType = mainEntityType;
        this.strategy = strategy == null ? new PcColumnSelectStrategy() : strategy;
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree().getTreeNode());
    }

    public PropertyNode buildTree() {
        Map allFields = this.mainEntityType.getAllFields();
        HashMap<String, PropertyNode> propNodeMap = new HashMap<String, PropertyNode>();
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        PropertyNode propRoot = new PropertyNode();
        TreeNode root = new TreeNode(null, rootId, this.mainEntityType.getDisplayName().getLocaleValue());
        treeNodeMap.put(rootId, root);
        root.setIsOpened(true);
        propRoot.setType((IMetadata)this.mainEntityType);
        propRoot.setTreeNode(root);
        propRoot.setFieldKey(rootId);
        propNodeMap.put(rootId, propRoot);
        for (IDataEntityProperty pro : allFields.values()) {
            IDataEntityType parent = pro.getParent();
            if (parent == null) continue;
            this.buildAllPropNodeTree(propNodeMap, treeNodeMap, propRoot, root, parent, pro);
        }
        return propRoot;
    }

    private void buildAllPropNodeTree(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> treeNodeMap, PropertyNode propRoot, TreeNode root, IDataEntityType parent, IDataEntityProperty pro) {
        this.strategy.buildHeadPropNode(propRoot, pro);
    }
}

