/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.enumeration.metric;

import java.util.Map;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.form.plugin.form.metric.MetricDefinitionFormPlugin;
import kd.scmc.scmdi.form.vo.metric.MetricDefinitionEntryVo;

public enum DimensionTypeEnum {
    BILL(true){

        @Override
        public void selectDimensionObject(IFormView view, MetricDefinitionEntryVo metricDefinitionEntryVo) {
            DimensionTypeEnum.selectForm(view, "BillFormModel", metricDefinitionEntryVo);
        }
    }
    ,
    BASE_DATA(true){

        @Override
        public void selectDimensionObject(IFormView view, MetricDefinitionEntryVo metricDefinitionEntryVo) {
            DimensionTypeEnum.selectForm(view, "BaseFormModel", metricDefinitionEntryVo);
        }
    }
    ,
    DATE(true){

        @Override
        public void selectDimensionObject(IFormView view, MetricDefinitionEntryVo metricDefinitionEntryVo) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("metric_object_date_type");
            showParameter.getCustomParams().put("date_type", metricDefinitionEntryVo.getDimensionObjectJson().get("dateType"));
            showParameter.setCloseCallBack(new CloseCallBack(MetricDefinitionFormPlugin.class.getName(), "metric_object_date_type"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
    }
    ,
    TEXT(false){};

    private final boolean objectRequired;

    private DimensionTypeEnum(boolean objectRequired) {
        this.objectRequired = objectRequired;
    }

    public boolean isObjectRequired() {
        return this.objectRequired;
    }

    private static void selectForm(IFormView view, String formType, MetricDefinitionEntryVo entry) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack(MetricDefinitionFormPlugin.class.getName(), "METRIC_OBJECT_FORM_TYPE"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(false);
        showParameter.setMustInput(true);
        showParameter.setBillFormId("bos_entityobject");
        showParameter.setLookUp(true);
        showParameter.setFormId("bos_treelistf7");
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        if (listFilterParameter == null) {
            listFilterParameter = new ListFilterParameter();
        }
        listFilterParameter.setFilter(new QFilter("modeltype", "=", (Object)formType));
        showParameter.setListFilterParameter(listFilterParameter);
        Map<String, Object> dimensionObjectJson = entry.getDimensionObjectJson();
        showParameter.setSelectedRow(CommonUtils.isAllNullOrEmpty((Object[])new Object[]{dimensionObjectJson}) ? null : dimensionObjectJson.get("formType"));
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        view.showForm((FormShowParameter)showParameter);
    }

    public void onChanged(IFormView view, int index) {
        view.setEnable(Boolean.valueOf(this.objectRequired), index, new String[]{"dimension_object"});
    }

    public void selectDimensionObject(IFormView view, MetricDefinitionEntryVo metricDefinitionEntryVo) {
    }
}

