/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.enumeration.warning;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.scmc.scmdi.form.enumeration.warning.WeekDaysEnum;
import org.joda.time.DateTime;

public enum MonitorSlotEnum {
    DAY(false){

        @Override
        public String getCron(DateTime hourMinute, List<String> selectedDays) {
            return "0 " + hourMinute.getMinuteOfHour() + " " + hourMinute.getHourOfDay() + " * * ?";
        }

        @Override
        public void onOptionSelected(IFormView view) {
            view.setVisible(Boolean.valueOf(false), new String[]{"monitor_day"});
        }
    }
    ,
    WEEK(true){

        @Override
        public String getCron(DateTime hourMinute, List<String> selectedDays) {
            if (selectedDays == null || selectedDays.isEmpty()) {
                return "";
            }
            return "0 " + hourMinute.getMinuteOfHour() + " " + hourMinute.getHourOfDay() + " ? * " + selectedDays.stream().map(s -> s.toUpperCase().substring(0, 3)).collect(Collectors.joining(","));
        }

        @Override
        public void onOptionSelected(IFormView view) {
            List collect = Arrays.asList(WeekDaysEnum.values()).stream().map(w -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(w.name());
                comboItem.setCaption(new LocaleString(w.getName()));
                return comboItem;
            }).collect(Collectors.toList());
            MonitorSlotEnum.setMonitorDay(view, collect);
        }
    }
    ,
    MONTH(true){

        @Override
        public String getCron(DateTime hourMinute, List<String> selectedDays) {
            if (selectedDays == null || selectedDays.isEmpty()) {
                return "";
            }
            return "0 " + hourMinute.getMinuteOfHour() + " " + hourMinute.getHourOfDay() + " " + selectedDays.stream().collect(Collectors.joining(",")) + " * ?";
        }

        @Override
        public void onOptionSelected(IFormView view) {
            List collect = IntStream.rangeClosed(1, 31).mapToObj(w -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(String.valueOf(w));
                comboItem.setCaption(new LocaleString(w + ResManager.loadKDString((String)"\u65e5", (String)"MonitorSlotEnum_0", (String)"scmc-scmdi-form", (Object[])new Object[0])));
                return comboItem;
            }).collect(Collectors.toList());
            MonitorSlotEnum.setMonitorDay(view, collect);
        }
    };

    private final boolean showMonitorDayField;

    private MonitorSlotEnum(boolean showMonitorDayField) {
        this.showMonitorDayField = showMonitorDayField;
    }

    public abstract void onOptionSelected(IFormView var1);

    private static void setMonitorDay(IFormView view, List<ComboItem> items) {
        view.setVisible(Boolean.valueOf(true), new String[]{"monitor_day"});
        ComboEdit comboEdit = (ComboEdit)view.getControl("monitor_day");
        comboEdit.setComboItems(items);
        comboEdit.setMustInput(true);
    }

    public boolean isShowMonitorDayField() {
        return this.showMonitorDayField;
    }

    public abstract String getCron(DateTime var1, List<String> var2);
}

