/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.enumeration.warning;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;

public enum UpgradePolicy {
    STEP("STEP"){

        @Override
        public Integer getNextLevel(Integer currentLevel, List<Integer> levelList, WarnConfig warnConfig) {
            Integer nextLevel = levelList.stream().filter(l -> l > currentLevel).findFirst().orElse(null);
            return nextLevel;
        }
    }
    ,
    SPECIFIED("SPECIFIED"){

        @Override
        public Integer getNextLevel(Integer currentLevel, List<Integer> levelList, WarnConfig warnConfig) {
            Integer nextLevel = Integer.valueOf(warnConfig.getSpecifiedWarningLevel());
            if (nextLevel <= currentLevel) {
                return null;
            }
            return nextLevel;
        }
    };

    final String value;

    private UpgradePolicy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    protected abstract Integer getNextLevel(Integer var1, List<Integer> var2, WarnConfig var3);

    public Integer getNextLevel(Integer currentLevel, WarnConfig warnConfig) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"scmdi_warnresult_template");
        ComboProp combo = (ComboProp)type.getAllFields().get("warninglevel");
        List comboItems = combo.getComboItems();
        List<Integer> levelList = comboItems.stream().map(ValueMapItem::getValue).map(Integer::valueOf).sorted().collect(Collectors.toList());
        return this.getNextLevel(currentLevel, levelList, warnConfig);
    }
}

