/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.homepage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.common.entity.DigitalCardInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.plugin.form.itoanalysis.AbstractItoAnalysisPlugin;

public class InvItoMetricCardPlugin
extends AbstractItoAnalysisPlugin {
    public void registerListener(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.getModelerId();
        this.buildFilterCondition();
        this.buildChart();
    }

    public void buildChart() {
        this.buildDigitalCard();
    }

    private void buildDigitalCard() {
        DigitalCardInfo itoDigitalCardData = new DigitalCardInfo();
        itoDigitalCardData.setStockTurnOver(new BigDecimal("0.95"));
        itoDigitalCardData.setStockTurnOverYOYRate(new BigDecimal("32.24"));
        itoDigitalCardData.setStockTurnOverQOQRate(new BigDecimal("1"));
        itoDigitalCardData.setTurnOverDay(new BigDecimal("10.26"));
        itoDigitalCardData.setTurnOverDayYOYRate(new BigDecimal("-3.35"));
        itoDigitalCardData.setTurnOverDayQOQRate(new BigDecimal("-5.68"));
        itoDigitalCardData.setSaleCost(new BigDecimal("589643.00"));
        itoDigitalCardData.setSaleCostYOYRate(new BigDecimal("2.34"));
        itoDigitalCardData.setSaleCostQOQRate(new BigDecimal("6.94"));
        itoDigitalCardData.setInvCost(new BigDecimal("45635.68"));
        itoDigitalCardData.setInvCostYOYRate(new BigDecimal("-4.56"));
        itoDigitalCardData.setInvCostQOQRate(new BigDecimal("3.25"));
        Label ito = (Label)this.getView().getControl("itocurrentvalue");
        Label itoYoy = (Label)this.getView().getControl("ito_yoy");
        Label itoQoq = (Label)this.getView().getControl("ito_qoq");
        Label turnOverDay = (Label)this.getView().getControl("tdcurrentvalue");
        Label turnOverDayYoy = (Label)this.getView().getControl("td_yoy");
        Label turnOverDayQoq = (Label)this.getView().getControl("td_qoq");
        Label saleCost = (Label)this.getView().getControl("salecostcurrentvalue");
        Label saleCostYoy = (Label)this.getView().getControl("salecost_yoy");
        Label saleCostQoq = (Label)this.getView().getControl("salecost_qoq");
        Label invCost = (Label)this.getView().getControl("invcostcurrentvalue");
        Label invCostYoy = (Label)this.getView().getControl("invcost_yoy");
        Label invCostQoq = (Label)this.getView().getControl("invcost_qoq");
        String itoText = itoDigitalCardData.getStockTurnOver() == null ? "-" : itoDigitalCardData.getStockTurnOver().toPlainString();
        ito.setText(itoText);
        BigDecimal stockTurnOverYOYRate = itoDigitalCardData.getStockTurnOverYOYRate();
        this.setIconVisible(stockTurnOverYOYRate, "ito_yoy_increase", "ito_yoy_decreases", "ito_yoy1");
        String itoYoyText = stockTurnOverYOYRate == null ? "-" : stockTurnOverYOYRate.toPlainString();
        itoYoy.setText(itoYoyText);
        BigDecimal stockTurnOverQOQRate = itoDigitalCardData.getStockTurnOverQOQRate();
        this.setIconVisible(stockTurnOverQOQRate, "ito_qoq_increase", "ito_qoq_decreases", "ito_qoq1");
        String itoQoqText = stockTurnOverQOQRate == null ? "-" : stockTurnOverQOQRate.toPlainString();
        itoQoq.setText(itoQoqText);
        String turnOverDayText = itoDigitalCardData.getTurnOverDay() == null ? "-" : itoDigitalCardData.getTurnOverDay().toPlainString();
        turnOverDay.setText(turnOverDayText);
        BigDecimal turnOverDayYOYRate = itoDigitalCardData.getTurnOverDayYOYRate();
        this.setIconVisible(turnOverDayYOYRate, "td_yoy_increase", "td_yoy_decreases", "td_yoy1");
        String turnOverDayYoyText = turnOverDayYOYRate == null ? "-" : turnOverDayYOYRate.toPlainString();
        turnOverDayYoy.setText(turnOverDayYoyText);
        BigDecimal turnOverDayQOQRate = itoDigitalCardData.getTurnOverDayQOQRate();
        this.setIconVisible(turnOverDayQOQRate, "td_qoq_increase", "td_qoq_decreases", "td_qoq1");
        String turnOverDayQoqText = turnOverDayQOQRate == null ? "-" : turnOverDayQOQRate.toPlainString();
        turnOverDayQoq.setText(turnOverDayQoqText);
        String saleCostText = itoDigitalCardData.getSaleCost() == null ? "-" : itoDigitalCardData.getSaleCost().toPlainString();
        saleCost.setText(saleCostText);
        BigDecimal saleCostYOYRate = itoDigitalCardData.getSaleCostYOYRate();
        this.setIconVisible(saleCostYOYRate, "salecost_yoy_increase", "salecost_yoy_decreases", "salecost_yoy1");
        String saleCostYoyText = saleCostYOYRate == null ? "-" : saleCostYOYRate.toPlainString();
        saleCostYoy.setText(saleCostYoyText);
        BigDecimal saleCostQOQRate = itoDigitalCardData.getSaleCostQOQRate();
        this.setIconVisible(saleCostQOQRate, "salecost_qoq_increase", "salecost_qoq_decreases", "salecost_qoq1");
        String saleCostQoqText = saleCostQOQRate == null ? "-" : saleCostQOQRate.toPlainString();
        saleCostQoq.setText(saleCostQoqText);
        String invCostText = itoDigitalCardData.getInvCost() == null ? "-" : itoDigitalCardData.getInvCost().toPlainString();
        invCost.setText(invCostText);
        BigDecimal invCostYOYRate = itoDigitalCardData.getInvCostYOYRate();
        this.setIconVisible(invCostYOYRate, "invcost_yoy_increase", "invcost_yoy_decreases", "invcost_yoy1");
        String invCostYoyText = invCostYOYRate == null ? "-" : invCostYOYRate.toPlainString();
        invCostYoy.setText(invCostYoyText);
        BigDecimal invCostQOQRate = itoDigitalCardData.getInvCostQOQRate();
        this.setIconVisible(invCostQOQRate, "invcost_qoq_increase", "invcost_qoq_decreases", "invcost_qoq1");
        String invCostQoqText = invCostQOQRate == null ? "-" : invCostQOQRate.toPlainString();
        invCostQoq.setText(invCostQoqText);
    }

    private void setIconVisible(BigDecimal rate, String increaseKey, String decreasesKey, String percent) {
        if (rate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
            return;
        }
        int rateSize = rate.compareTo(BigDecimal.ZERO);
        if (rateSize > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{increaseKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{decreasesKey});
        } else if (rateSize < 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{decreasesKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
        }
    }

    private void getModelerId() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("scmdi_metric_cal_ito");
        list.add("scmdi_metric_cal_itogroup");
        QFilter[] filters = new QFilter[]{new QFilter("biz_entity", "in", list), new QFilter("enable", "=", (Object)"1")};
        Map metricsMapping = BusinessDataServiceHelper.loadFromCache((String)"scmdi_metrics_mapping", (String)"biz_entity,metric_entity_identity", (QFilter[])filters);
        IPageCache pageCache = this.getPageCache();
        for (DynamicObject dynamicObject : metricsMapping.values()) {
            DynamicObject entity = dynamicObject.getDynamicObject("biz_entity");
            pageCache.put((String)entity.getPkValue(), dynamicObject.getString("metric_entity_identity"));
        }
    }

    public void buildEntryEntity() {
    }

    public void buildFilterCondition() {
        this.setFilterConditionDefaultValue();
    }

    public FilterConditionInfo getFilterConditionInfo() {
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map coll = PeriodHelper.getCollByStartPeriodAndEndPeriod((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        List periodId = coll.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        List periodName = coll.values().stream().map(period -> period.getString("name")).collect(Collectors.toList());
        Map qoqPeriod = PeriodHelper.getQOQPeriod((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        Map qoqColl = PeriodHelper.getCollByStartPeriodAndEndPeriod((DynamicObject)((DynamicObject)qoqPeriod.get("startPeriod")), (DynamicObject)((DynamicObject)qoqPeriod.get("endPeriod")));
        List qoqPeriodId = qoqColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        Map yoyPeriod = PeriodHelper.getYOYPeriod((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        Map yoyColl = PeriodHelper.getCollByStartPeriodAndEndPeriod((DynamicObject)((DynamicObject)yoyPeriod.get("startPeriod")), (DynamicObject)((DynamicObject)yoyPeriod.get("endPeriod")));
        List yoyPeriodId = yoyColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        FilterConditionInfo filterConditionInfo = new FilterConditionInfo();
        filterConditionInfo.setCalOrg(Long.valueOf(calOrg.getLong("id")));
        if (costAccount != null) {
            filterConditionInfo.setCostAccount(Long.valueOf(costAccount.getLong("id")));
        }
        filterConditionInfo.setPeriod(periodId);
        filterConditionInfo.setPeriodName(periodName);
        filterConditionInfo.setQoqPeriod(qoqPeriodId);
        filterConditionInfo.setYoyPeriod(yoyPeriodId);
        filterConditionInfo.setMetricModel(this.getPageCache().get("scmdi_metric_cal_ito"));
        filterConditionInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return filterConditionInfo;
    }
}

