/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.homepage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.column.QtyColumnDesc;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.FieldSort;
import kd.bos.list.ListShowParameter;
import org.apache.commons.lang3.StringUtils;

public class WarnResultInfoCardPlugin
extends AbstractFormPlugin
implements CountDownListener {
    private static final String VIEW_MORE = "view_more";
    private static final String HANDLE_WARN = "warn_handle";
    private static final String COUNT_DOWN = "count_down";
    private static final String WARN_RES_INV_DETAIL_PAGE = "scmdi_warn_res_inv_detail";
    private static final String WARN_HANDLE_LIST_PAGE = "scmdi_wwb_list";
    private static final String BILL_LIST = "billlistap";
    private static final String CACHED_DETAIL_PAGE_ID = "cached_page_id";
    private static final String CACHED_HANDLE_PAGE_ID = "cached_handle_page_id";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VIEW_MORE, HANDLE_WARN});
        CountDown countDown = (CountDown)this.getView().getControl(COUNT_DOWN);
        countDown.addCountDownListener((CountDownListener)this);
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.addBeforeBindDataListener(evt -> billList.setSortSetting(this.getFieldSort()));
        this.deleteTailZero(BILL_LIST, "avbbaseqty");
        super.registerListener(e);
    }

    private void deleteTailZero(String list, String field) {
        BillList billList = (BillList)this.getControl(list);
        billList.addPackageDataListener(evt -> {
            String key;
            Object source = evt.getSource();
            if (source instanceof QtyColumnDesc && field.equals(key = ((QtyColumnDesc)source).getKey())) {
                String valueString = ((BigDecimal)evt.getRowData().get(key)).toPlainString();
                BigDecimal value = new BigDecimal(valueString);
                if (value.compareTo(new BigDecimal(0)) == 0) {
                    evt.setFormatValue((Object)"");
                    return;
                }
                evt.setFormatValue((Object)value);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.setSortSetting(this.getFieldSort());
        this.deleteTailZero(BILL_LIST, "avbbaseqty");
    }

    private List<FieldSort> getFieldSort() {
        ArrayList<FieldSort> result = new ArrayList<FieldSort>();
        result.add(new FieldSort("processingstatus", SortType.ASC));
        result.add(new FieldSort("warninglevel", SortType.DESC));
        result.add(new FieldSort("createtime", SortType.ASC));
        return result;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (VIEW_MORE.equals(source.getKey())) {
            this.openTabForm(WARN_RES_INV_DETAIL_PAGE, CACHED_DETAIL_PAGE_ID);
        } else if (HANDLE_WARN.equals(source.getKey())) {
            this.openTabForm(WARN_HANDLE_LIST_PAGE, CACHED_HANDLE_PAGE_ID);
        }
    }

    private void openTabForm(String pageNum, String pageIdCache) {
        String pageId = this.getPageCache().get(pageIdCache);
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            this.openNewForm(pageNum, pageIdCache);
        } else {
            IFormView view = this.getView().getViewNoPlugin(pageId);
            if (view == null) {
                this.openNewForm(pageNum, pageIdCache);
            } else {
                view.activate();
                this.getView().sendFormAction(view);
            }
        }
    }

    private void openNewForm(String pageNum, String pageIdCache) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (WARN_HANDLE_LIST_PAGE.equals(pageNum)) {
            formShowParameter = new ListShowParameter();
            ((ListShowParameter)formShowParameter).setBillFormId(pageNum);
        } else {
            formShowParameter.setFormId(pageNum);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = this.getNewPageId(pageIdCache);
        formShowParameter.setPageId(pageId);
        this.getView().showForm(formShowParameter);
    }

    public void afterBindData(EventObject e) {
        this.startCount();
        super.afterBindData(e);
    }

    public void onCountDownEnd(CountDownEvent evt) {
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.refresh();
        this.startCount();
        super.onCountDownEnd(evt);
    }

    private void startCount() {
        CountDown countdown = (CountDown)this.getView().getControl(COUNT_DOWN);
        countdown.setDuration(600);
        countdown.start();
    }

    private String getNewPageId(String pageIdCache) {
        String pageId = UUID.randomUUID().toString();
        this.getPageCache().put(pageIdCache, pageId);
        return pageId;
    }
}

