/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.homepage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.list.column.QtyColumnDesc;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.FieldSort;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WarnResultInvDetailPagePlugin
extends AbstractFormPlugin
implements ListRowClickListener {
    private static final String WARN_RESULT_LIST = "warn_result_list";
    private static final String INV_INFO_LIST = "inv_info_list";
    private static final String INV_WARN_RESULT_BILL = "scmdi_warnresult_invqty";
    private static final String CACHED_SELECTED_ROW = "cached_selec";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList warnList = (BillList)this.getControl(WARN_RESULT_LIST);
        warnList.addListRowClickListener((ListRowClickListener)this);
        this.deleteTailZero(WARN_RESULT_LIST, "avbbaseqty");
        this.deleteTailZero(INV_INFO_LIST, "baseqty");
        this.deleteTailZero(INV_INFO_LIST, "lockbaseqty");
        BillList invInfoList = (BillList)this.getControl(INV_INFO_LIST);
        invInfoList.addPackageDataListener(evt -> {
            Object source = evt.getSource();
            if (source instanceof DynamicTextColumnDesc) {
                BigDecimal lockBaseQty;
                DynamicObject rowData = evt.getRowData();
                BigDecimal baseQty = rowData.getBigDecimal("baseqty");
                BigDecimal avbQty = baseQty.subtract(lockBaseQty = rowData.getBigDecimal("lockbaseqty"));
                if (avbQty.compareTo(new BigDecimal(0)) == 0) {
                    evt.setFormatValue((Object)"");
                    return;
                }
                evt.setFormatValue((Object)avbQty);
            }
        });
    }

    private void deleteTailZero(String list, String field) {
        BillList billList = (BillList)this.getControl(list);
        billList.addPackageDataListener(evt -> {
            String key;
            Object source = evt.getSource();
            if (source instanceof QtyColumnDesc && field.equals(key = ((QtyColumnDesc)source).getKey())) {
                String valueString = ((BigDecimal)evt.getRowData().get(key)).toPlainString();
                BigDecimal value = new BigDecimal(valueString);
                if (value.compareTo(new BigDecimal(0)) == 0) {
                    evt.setFormatValue((Object)"");
                    return;
                }
                evt.setFormatValue((Object)value);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList warnList = (BillList)this.getControl(WARN_RESULT_LIST);
        warnList.setSortSetting(this.getFieldSort());
        this.deleteTailZero(WARN_RESULT_LIST, "avbbaseqty");
    }

    private List<FieldSort> getFieldSort() {
        ArrayList<FieldSort> result = new ArrayList<FieldSort>();
        result.add(new FieldSort("processingstatus", SortType.ASC));
        result.add(new FieldSort("warninglevel", SortType.DESC));
        result.add(new FieldSort("createtime", SortType.ASC));
        return result;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
    }

    private void initData() {
        BillList warnList = (BillList)this.getControl(WARN_RESULT_LIST);
        ListSelectedRowCollection allRowCollection = warnList.getCurrentListAllRowCollection();
        if (allRowCollection.isEmpty()) {
            return;
        }
        warnList.selectRows(new int[]{0});
        long pkValue = (Long)allRowCollection.get(0).getPrimaryKeyValue();
        this.setInvListFilter(pkValue);
    }

    private void setInvListFilter(long selectedBillNo) {
        QFilter warnResultFilter = new QFilter("id", "=", (Object)selectedBillNo);
        DynamicObject warnResult = BusinessDataServiceHelper.loadSingle((String)INV_WARN_RESULT_BILL, (String)"org, materielid", (QFilter[])new QFilter[]{warnResultFilter});
        if (warnResult == null || warnResult.getDynamicObject("materielid") == null || warnResult.getDynamicObject("org") == null) {
            return;
        }
        String materialNumber = warnResult.getDynamicObject("materielid").getDynamicObject("masterid").getString("number");
        String orgNumber = warnResult.getDynamicObject("org").getString("number");
        QFilter invInfoFilter = new QFilter("material.number", "=", (Object)materialNumber).and("org.number", "=", (Object)orgNumber);
        BillList invInfoList = (BillList)this.getControl(INV_INFO_LIST);
        invInfoList.setFilter(invInfoFilter);
        this.getView().updateView(INV_INFO_LIST);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        if (evt.getCurrentListSelectedRow() == null) {
            String rowStr = this.getPageCache().get(CACHED_SELECTED_ROW);
            if (rowStr != null && !rowStr.isEmpty()) {
                BillList warnList = (BillList)this.getControl(WARN_RESULT_LIST);
                warnList.selectRows(Integer.parseInt(rowStr));
            }
            return;
        }
        this.getPageCache().put(CACHED_SELECTED_ROW, String.valueOf(evt.getRow()));
        long selectedBillPk = (Long)evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        this.setInvListFilter(selectedBillPk);
    }
}

