/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.homepage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.form.enumeration.solution.ProcessStatusEnum;
import kd.scmc.scmdi.form.enumeration.warning.WarningLevelEnum;
import kd.scmc.scmdi.form.plugin.form.homepage.OrgWarnRelation;
import kd.scmc.scmdi.form.plugin.form.homepage.Warn;

public class WarnResultLogisticCardPlugin
extends AbstractFormPlugin
implements CountDownListener {
    private static final String HISTOGRAM_CHART = "histogramchartap";
    private static final String RING_CHART = "piechartap";
    private static final String COUNT_DOWN = "countdownap";
    private static final String WARNING_LEVEL_HIGH_BTN = "level_high";
    private static final String WARNING_LEVEL_MID_BTN = "level_mid";
    private static final String WARNING_LEVEL_LOW_BTN = "level_low";
    private static final String WARN_RESULT_BILL = "scmdi_warnresult_invqty";
    private static final String SEARCH_FIELDS = "warninglevel, org, warning_config";
    private static final String CACHED_DATA = "cached_data";
    private static final String CACHED_WARNING_LEVEL = "cached_level";
    private static final String CACHED_ORG_ID = "cached_org";
    private static final String BTN_BAC_COLOR_SELECT = "#5582F3";
    private static final String BTN_BAC_COLOR = "#ffffff";
    private static final String BTN_FORCE_COLOR_SELECT = "#ffffff";
    private static final String BTN_FORCE_COLOR = "#212121";
    private static final Map<String, Object> SELECTED_BTN_STYLE_MAP = new HashMap<String, Object>();
    private static final Map<String, Object> BTN_STYLE_MAP = new HashMap<String, Object>();

    public void registerListener(EventObject e) {
        CountDown countDown = (CountDown)this.getView().getControl(COUNT_DOWN);
        countDown.addCountDownListener((CountDownListener)this);
        this.addClickListeners(new String[]{WARNING_LEVEL_HIGH_BTN, WARNING_LEVEL_MID_BTN, WARNING_LEVEL_LOW_BTN});
        ((HistogramChart)this.getControl(HISTOGRAM_CHART)).addClickListener((ClickListener)this);
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.setChart(WarningLevelEnum.HIGH);
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        CountDown countdown = (CountDown)this.getView().getControl(COUNT_DOWN);
        countdown.setDuration(600);
        countdown.start();
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "level_high": {
                this.setChart(WarningLevelEnum.HIGH);
                break;
            }
            case "level_mid": {
                this.setChart(WarningLevelEnum.MID);
                break;
            }
            case "level_low": {
                this.setChart(WarningLevelEnum.LOW);
                break;
            }
            case "histogramchartap": {
                ChartClickEvent cce = (ChartClickEvent)evt;
                String orgName = cce.getName();
                this.refreshRingChartWhenHisClicked(orgName);
                break;
            }
        }
    }

    public void onCountDownEnd(CountDownEvent evt) {
        this.getDataFromDB();
        super.onCountDownEnd(evt);
    }

    private void setWarnLevelBTNStyle(WarningLevelEnum warningLevel) {
        this.getView().updateControlMetadata(WARNING_LEVEL_HIGH_BTN, BTN_STYLE_MAP);
        this.getView().updateControlMetadata(WARNING_LEVEL_MID_BTN, BTN_STYLE_MAP);
        this.getView().updateControlMetadata(WARNING_LEVEL_LOW_BTN, BTN_STYLE_MAP);
        this.getView().updateControlMetadata("level_" + warningLevel.name().toLowerCase(), SELECTED_BTN_STYLE_MAP);
    }

    private void setChart(WarningLevelEnum warningLevel) {
        this.setWarnLevelBTNStyle(warningLevel);
        List<OrgWarnRelation> dataList = this.getDataFromCache(warningLevel);
        List<OrgWarnRelation> handledData = this.getRequiredNumberDataByOrder(dataList, Comparator.comparing(OrgWarnRelation::getWarnTotalNumber).reversed().thenComparing(OrgWarnRelation::getOrgNumber), 10);
        this.refreshHistogramChart(handledData, warningLevel);
        this.setSelectedOrg("");
        if (!handledData.isEmpty()) {
            OrgWarnRelation orgWarnRelation = new OrgWarnRelation("default_org", "", "");
            handledData.forEach(data -> data.getWarnList().forEach(orgWarnRelation::addWarn));
            this.refreshRingChart(orgWarnRelation);
        } else {
            this.refreshRingChart(null);
        }
        this.putWarningLevelIntoPageCache(warningLevel);
    }

    private void refreshHistogramChart(List<OrgWarnRelation> data, WarningLevelEnum warningLevel) {
        HistogramChart barChart = (HistogramChart)this.getControl(HISTOGRAM_CHART);
        barChart.setMargin(Position.top, "18px");
        barChart.setMargin(Position.bottom, "10px");
        barChart.addTooltip("trigger", (Object)"item");
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        String formatter = "{b}<br />\u9884\u8b66\u7ea7\u522b\uff1a" + warningLevel.getDesc() + "<br />\u9884\u8b66\u6570\u91cf\uff1a{c}";
        barChart.addTooltip("formatter", (Object)formatter);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barChart.addFuncPath(toolTipFuncPath);
        barChart.setShowTooltip(true);
        Axis xAxis = barChart.createXAxis("\u7ec4\u7ec7", AxisType.category);
        Axis yAxis = barChart.createYAxis("", AxisType.value);
        String[] xData = new String[data.size()];
        Number[] yData = new Integer[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            xData[i] = data.get(i).getOrgName();
            yData[i] = data.get(i).getWarnTotalNumber();
        }
        xAxis.setPropValue("data", (Object)xData);
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>();
        String dataFormatter = "function(value){if(value.length > 8){return value.substr(0,4) + '\\n' + value.substr(4, 3) + '...';}else if(value.length > 4){ return value.substr(0,4) + '\\n' + value.substr(4, value.length); }else{ return value; }}";
        axisLabelMap.put("formatter", dataFormatter);
        axisLabelMap.put("interval", 0);
        xAxis.setPropValue("axisLabel", axisLabelMap);
        ArrayList<Object> xAxisFuncPath = new ArrayList<Object>();
        xAxisFuncPath.add("xAxis");
        xAxisFuncPath.add(0);
        xAxisFuncPath.add("axisLabel");
        xAxisFuncPath.add("formatter");
        barChart.addFuncPath(xAxisFuncPath);
        BarSeries barChartSeries = barChart.createSeries("\u6570\u91cf");
        barChartSeries.setData(yData);
        barChartSeries.setPropValue("barMaxWidth", (Object)"25");
        barChart.refresh();
    }

    private void refreshRingChartWhenHisClicked(String orgName) {
        if (orgName == null || "".equals(orgName)) {
            return;
        }
        String cachedOrg = this.getPageCache().get(CACHED_ORG_ID);
        if (("\uff1a" + orgName).equals(cachedOrg)) {
            this.setChart(this.getWarningLevelFromPageCache());
            this.setSelectedOrg("");
            return;
        }
        this.setSelectedOrg("\uff1a" + orgName);
        List<OrgWarnRelation> dataFromCache = this.getDataFromCache(null);
        OrgWarnRelation orgWarnRelation = null;
        for (OrgWarnRelation relation : dataFromCache) {
            if (!relation.getOrgName().equals(orgName)) continue;
            orgWarnRelation = relation;
            break;
        }
        if (orgWarnRelation == null) {
            return;
        }
        this.refreshRingChart(orgWarnRelation);
    }

    private void setSelectedOrg(String orgName) {
        this.getModel().setValue("selected_org", (Object)orgName);
        this.getPageCache().put(CACHED_ORG_ID, orgName);
    }

    private void refreshRingChart(OrgWarnRelation data) {
        PieChart pieChart = (PieChart)this.getControl(RING_CHART);
        if (data == null) {
            pieChart.clearData();
            pieChart.refresh();
            return;
        }
        List<Warn> ringChartData = this.handleRingChartData(data.getWarnList());
        pieChart.clearData();
        pieChart.setShowLegend(true);
        pieChart.setLegendVertical(true);
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.setLegendPropValue("left", (Object)"60%");
        pieChart.setLegendPropValue("top", (Object)"center");
        String dataFormatter = "function(name) {if(!name) {return ''} if(name.length > 18) { return name.slice(0, 18) + '...'} return name;}";
        pieChart.setLegendPropValue("formatter", (Object)dataFormatter);
        ArrayList<String> legendFunc = new ArrayList<String>();
        legendFunc.add("legend");
        legendFunc.add("formatter");
        pieChart.addFuncPath(legendFunc);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("triggerOn", (Object)"click");
        PieSeries series = pieChart.createSeries("");
        ringChartData.forEach(warn -> series.addData(warn.getWarnName(), (Number)warn.getWarnHappenNumber(), null));
        series.setRadius("48%", "65%");
        series.setCenter("30%", "50%");
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        label.setFormatter("\u9884\u8b66\u6570\u91cf\uff1a{c}\n\u5360\u6bd4\uff1a{d}%");
        label.setColor(BTN_FORCE_COLOR);
        Label normalLabel = new Label();
        normalLabel.setPosition(Position.right);
        normalLabel.setShow(false);
        HashMap<String, Label> labelMap = new HashMap<String, Label>();
        labelMap.put("emphasis", label);
        labelMap.put("normal", normalLabel);
        series.setPropValue("label", labelMap);
        pieChart.setTitlePropValue("left", (Object)"25%");
        pieChart.setTitlePropValue("top", (Object)"43%");
        pieChart.setTitlePropValue("text", (Object)("    " + data.getWarnTotalNumber() + "\n\u9884\u8b66\u6570\u91cf"));
        pieChart.refresh();
    }

    private List<Warn> handleRingChartData(List<Warn> data) {
        ArrayList<Warn> result = new ArrayList();
        List<Warn> dataByOrder = this.getRequiredNumberDataByOrder(data, Comparator.comparing(Warn::getWarnHappenNumber).reversed(), data.size());
        if (dataByOrder.size() > 5) {
            Warn warn = new Warn("other", "\u5176\u4ed6");
            int otherNumber = 0;
            for (int i = 4; i < dataByOrder.size(); ++i) {
                otherNumber += dataByOrder.get(i).getWarnHappenNumber();
            }
            warn.setWarnHappenNumber(otherNumber);
            result.addAll(dataByOrder.subList(0, 4));
            result.add(warn);
        } else {
            result = dataByOrder;
        }
        return result;
    }

    private <T> List<T> getRequiredNumberDataByOrder(List<T> data, Comparator<T> comparator, int number) {
        List sortedList = data.stream().sorted(comparator).collect(Collectors.toList());
        return sortedList.subList(0, Math.min(sortedList.size(), number));
    }

    private List<OrgWarnRelation> getDataFromCache(WarningLevelEnum warningLevel) {
        Map map;
        JSONArray dataArray;
        if (warningLevel == null) {
            warningLevel = this.getWarningLevelFromPageCache();
        }
        ArrayList<OrgWarnRelation> result = new ArrayList<OrgWarnRelation>();
        String dataStr = this.getPageCache().get(CACHED_DATA);
        if (dataStr == null || "".equals(dataStr)) {
            this.getDataFromDB();
            dataStr = this.getPageCache().get(CACHED_DATA);
        }
        if ((dataArray = (JSONArray)(map = (Map)JSON.parseObject((String)dataStr, Map.class)).get(warningLevel.getValue())) == null) {
            return Collections.emptyList();
        }
        dataArray.forEach(data -> {
            OrgWarnRelation orgWarnRelation = (OrgWarnRelation)((JSONObject)data).toJavaObject(OrgWarnRelation.class);
            JSONArray warns = ((JSONObject)data).getJSONArray("warnList");
            List warnList = warns.toJavaList(Warn.class);
            orgWarnRelation.setWarnList(warnList);
            result.add(orgWarnRelation);
        });
        return result;
    }

    private void putWarningLevelIntoPageCache(WarningLevelEnum warningLevelEnum) {
        this.getPageCache().put(CACHED_WARNING_LEVEL, warningLevelEnum.name());
    }

    private WarningLevelEnum getWarningLevelFromPageCache() {
        String name = this.getPageCache().get(CACHED_WARNING_LEVEL);
        return WarningLevelEnum.valueOf(name);
    }

    private void getDataFromDB() {
        QFilter dataFilter = this.createDataFilter();
        DynamicObject[] warnResults = BusinessDataServiceHelper.load((String)WARN_RESULT_BILL, (String)SEARCH_FIELDS, (QFilter[])new QFilter[]{dataFilter});
        this.handleOriginData(warnResults);
    }

    private QFilter createDataFilter() {
        return new QFilter("processingstatus", "=", (Object)ProcessStatusEnum.UNPROCESSED.getStatusCode());
    }

    private void handleOriginData(DynamicObject[] originData) {
        Map<String, List<DynamicObject>> dataMap = this.groupDataByWarningLevel(originData);
        HashMap resultMap = new HashMap();
        dataMap.forEach((key, value) -> resultMap.put(key, this.groupDataByOrg((List<DynamicObject>)value)));
        this.getPageCache().put(CACHED_DATA, JSON.toJSONString(resultMap));
    }

    private Map<String, List<DynamicObject>> groupDataByWarningLevel(DynamicObject[] originData) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        Arrays.stream(originData).forEach(data -> {
            String warningLevel = data.getString("warninglevel");
            ArrayList<DynamicObject> dynamicObjects = (ArrayList<DynamicObject>)result.get(warningLevel);
            if (dynamicObjects == null) {
                dynamicObjects = new ArrayList<DynamicObject>();
            }
            dynamicObjects.add((DynamicObject)data);
            result.put(warningLevel, dynamicObjects);
        });
        return result;
    }

    private List<OrgWarnRelation> groupDataByOrg(List<DynamicObject> originData) {
        ArrayList<OrgWarnRelation> result = new ArrayList<OrgWarnRelation>();
        originData.forEach(data -> {
            if (data.getDynamicObject("org") == null || data.getDynamicObject("warning_config") == null) {
                return;
            }
            String orgId = data.getDynamicObject("org").getString("id");
            String orgNumber = data.getDynamicObject("org").getString("number");
            String orgName = data.getDynamicObject("org").getString("name");
            Optional<OrgWarnRelation> relation = result.stream().filter(item -> orgId.equals(item.getOrgId())).findFirst();
            String warnId = data.getDynamicObject("warning_config").getString("id");
            String warnName = data.getDynamicObject("warning_config").getString("name");
            if (relation.isPresent()) {
                relation.get().addWarn(warnId, warnName);
            } else {
                OrgWarnRelation orgWarnRelation = new OrgWarnRelation(orgId, orgName, orgNumber);
                orgWarnRelation.addWarn(warnId, warnName);
                result.add(orgWarnRelation);
            }
        });
        return result;
    }

    static {
        SELECTED_BTN_STYLE_MAP.put("fc", "#ffffff");
        SELECTED_BTN_STYLE_MAP.put("bc", BTN_BAC_COLOR_SELECT);
        BTN_STYLE_MAP.put("fc", BTN_FORCE_COLOR);
        BTN_STYLE_MAP.put("bc", "#ffffff");
    }
}

