/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.mapping;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.qing.modeler.api.response.FieldType;
import com.kingdee.bos.qing.modeler.api.response.ModelField;
import com.kingdee.bos.qing.modeler.api.response.ModelMeta;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.metric.MetricServiceHolder;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.business.metric.vo.MetricMappingEntry;
import kd.scmc.scmdi.common.vo.bos.BosEntity;
import kd.scmc.scmdi.form.common.utils.colsselect.MetricBizEntityColumnSelectStrategy;
import kd.scmc.scmdi.form.common.utils.colsselect.PageUtils;
import kd.scmc.scmdi.form.plugin.form.AbstractPojoPlugin;
import org.apache.commons.lang3.StringUtils;

public class MetricMappingEditPlugin
extends AbstractPojoPlugin<MetricMapping>
implements BeforeF7SelectListener {
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String INHERIT_PATH = "inheritpath";
    public static final String BOS_FORM_META = "bos_formmeta";
    public static final String NAME = "name";
    public static final String TEXT = "text";
    public static final String BIZ_ENTITY = "biz_entity";
    public static final String METRIC_ENTITY_IDENTITY = "metric_entity_identity";
    public static final String METRIC_ENTITY_NAME = "metric_entity_name";
    public static final String METRIC_TEMPLATE_ENTITY = "scmdi_metric_template";
    public static final String BIZ_ENTITY_FIELD_NAME = "biz_entity_field_name";
    public static final String BIZ_ENTITY_FIELD_KEY = "biz_entity_field_key";
    public static final String METRIC_MAPPING_ENTRY = "metric_mapping_entry";
    public static final String METRIC_FIELD_NAME = "metric_field_name";
    public static final String METRIC_FIELD_KEY = "metric_field_key";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizEntity = (BasedataEdit)this.getControl(BIZ_ENTITY);
        bizEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BIZ_ENTITY_FIELD_NAME, METRIC_FIELD_NAME});
    }

    public void beforeClick(BeforeClickEvent e) {
        String key;
        super.beforeClick(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "biz_entity_field_name": {
                this.checkBizEntityInfo(e);
                break;
            }
            case "metric_field_name": {
                this.checkMetricEntityInfo(e);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
        this.setMetricDetailOptions();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setDisableStatus();
    }

    private void setDisableStatus() {
        this.getView().getModel().setValue("enable", (Object)0);
        this.getView().getModel().setValue("disabler", (Object)RequestContext.get().getCurrUserId());
        this.getView().getModel().setValue("disabledate", (Object)new Date());
    }

    private void setEnable() {
        IFormView view = this.getView();
        Boolean isPreSet = ((MetricMapping)this.getPojo()).getSysPreset();
        view.setEnable(Boolean.valueOf(isPreSet == false), new String[]{NUMBER, NAME, BIZ_ENTITY, METRIC_ENTITY_IDENTITY, "metric_desc", "sys_preset"});
        int size = view.getModel().getDataEntity(true).getDynamicObjectCollection(METRIC_MAPPING_ENTRY).size();
        for (int i = 0; i < size; ++i) {
            view.setEnable(Boolean.valueOf(isPreSet == false), i, new String[]{BIZ_ENTITY_FIELD_NAME, METRIC_FIELD_KEY});
        }
        view.setVisible(Boolean.valueOf(isPreSet == false), new String[]{"bar_save", "advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDisableStatus();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object metricId = formShowParameter.getCustomParam("metricId");
        if (metricId != null) {
            this.getModel().setValue("metricdefid", metricId);
        }
    }

    private void checkBizEntityInfo(BeforeClickEvent e) {
        IFormView view = this.getView();
        BosEntity bizEntity = ((MetricMapping)this.getPojo()).getBizEntity();
        if (bizEntity == null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f9b\u5e94\u94fe\u6307\u6807\u201d\u3002", (String)"MetricDefinitionEditPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            e.setCancel(true);
        }
    }

    private void checkMetricEntityInfo(BeforeClickEvent e) {
        IFormView view = this.getView();
        String mobFormDy = ((MetricMapping)this.getPojo()).getMetricEntityIdentity();
        if (StringUtils.isEmpty((CharSequence)mobFormDy)) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8f7b\u5efa\u6a21\u6307\u6807\u201d\u3002", (String)"MetricDefinitionEditPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            e.setCancel(true);
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "biz_entity_field_name": {
                this.clickFieldName(((MetricMapping)this.getPojo()).getBizEntity(), key);
                break;
            }
            case "metric_field_name": {
                break;
            }
        }
    }

    private void clickFieldName(BosEntity bosEntity, String fieldName) {
        IFormView view = this.getView();
        String entityNumber = bosEntity.getNumber();
        MetricBizEntityColumnSelectStrategy colsSelectStrategy = new MetricBizEntityColumnSelectStrategy();
        PageUtils.showColsTreePage(view, entityNumber, colsSelectStrategy, new CloseCallBack((IFormPlugin)this, fieldName));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "biz_entity": {
                this.beforeBizEntityF7Select(showParameter);
                break;
            }
            case "metric_entity_identity": {
                this.beforeBizEntityF7Select(showParameter);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMetricDefinitionOptions();
    }

    private void setMetricDefinitionOptions() {
        List metricDefinitions = MetricServiceHolder.getMetricService().getMetricDefinitions();
        List metricDefinitionsSelect = metricDefinitions.stream().map(m -> {
            ComboItem center = new ComboItem();
            center.setValue(m.getId());
            center.setCaption(new LocaleString(m.getName()));
            return center;
        }).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(METRIC_ENTITY_IDENTITY);
        comboEdit.setComboItems(metricDefinitionsSelect);
    }

    private void setMetricDetailOptions() {
        ModelMeta modelMeta;
        String metricEntityId = ((MetricMapping)this.getPojo()).getMetricEntityIdentity();
        if (StringUtils.isEmpty((CharSequence)metricEntityId)) {
            modelMeta = new ModelMeta();
            modelMeta.setFields(new ArrayList());
        } else {
            modelMeta = MetricServiceHolder.getMetricService().getModelMeta(metricEntityId);
        }
        List metricDetails = modelMeta.getFields();
        List metricDefinitionsSelect = metricDetails.stream().filter(f -> f.getFieldType() == FieldType.metric || f.getFieldType() == FieldType.dimension).map(m -> {
            ComboItem center = new ComboItem();
            center.setValue(m.getFieldName());
            center.setCaption(new LocaleString(m.getAlias() + "(" + m.getFieldName() + ")"));
            return center;
        }).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(METRIC_FIELD_KEY);
        comboEdit.setComboItems(metricDefinitionsSelect);
        ((MetricMapping)this.getPojo()).setMetricEntityName(modelMeta.getModelName());
    }

    private static DynamicObjectCollection getBaseForms() {
        ArrayList<String> baseFormNumbers = new ArrayList<String>(10);
        baseFormNumbers.add(METRIC_TEMPLATE_ENTITY);
        QFilter qFilter = new QFilter(NUMBER, "in", baseFormNumbers);
        return QueryServiceHelper.query((String)BOS_FORM_META, (String)ID, (QFilter[])qFilter.toArray());
    }

    public static Map<String, String> getBizEntityF7Range() {
        HashMap<String, String> numberToName = new HashMap<String, String>(16);
        DynamicObjectCollection baseForms = MetricMappingEditPlugin.getBaseForms();
        QFilter inheritPathFilter = null;
        for (DynamicObject baseForm : baseForms) {
            QFilter filter = new QFilter(INHERIT_PATH, "like", (Object)("%" + baseForm.getString(ID) + "%"));
            if (inheritPathFilter == null) {
                inheritPathFilter = filter;
                continue;
            }
            inheritPathFilter.or(filter);
        }
        if (inheritPathFilter != null) {
            DynamicObjectCollection formMetas = QueryServiceHelper.query((String)BOS_FORM_META, (String)"number,name", (QFilter[])inheritPathFilter.toArray());
            for (DynamicObject formMeta : formMetas) {
                String name = formMeta.getString(NAME);
                String number = formMeta.getString(NUMBER);
                numberToName.put(number, name);
            }
        }
        return numberToName;
    }

    private void beforeBizEntityF7Select(ListShowParameter showParameter) {
        Map<String, String> mobFormMap = MetricMappingEditPlugin.getBizEntityF7Range();
        QFilter qFilter = new QFilter(NUMBER, "in", mobFormMap.keySet());
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "biz_entity_field_name": {
                this.callBackFieldName(e, actionId);
                break;
            }
            case "metric_field_name": {
                this.callBackFieldName(e, actionId);
                break;
            }
        }
    }

    private void callBackFieldName(ClosedCallBackEvent e, String fieldName) {
        JSONArray data = this.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        IDataModel model = this.getModel();
        int currEntryIndex = model.getEntryCurrentRowIndex(METRIC_MAPPING_ENTRY);
        if (BIZ_ENTITY_FIELD_NAME.equals(fieldName)) {
            model.setValue(fieldName, dataJson.get((Object)TEXT), currEntryIndex);
            model.setValue(BIZ_ENTITY_FIELD_KEY, dataJson.get((Object)"fieldName"), currEntryIndex);
        }
        if (METRIC_FIELD_NAME.equals(fieldName)) {
            model.setValue(fieldName, dataJson.get((Object)TEXT), currEntryIndex);
            model.setValue(METRIC_FIELD_KEY, dataJson.get((Object)"fieldName"), currEntryIndex);
        }
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex(METRIC_MAPPING_ENTRY);
        switch (name = e.getProperty().getName()) {
            case "biz_entity_field_name": {
                this.clearBizFieldKey(model, currRowIndex);
                break;
            }
            case "metric_field_key": {
                this.setMetricFieldName(currRowIndex);
                break;
            }
            case "biz_entity": {
                this.clearBizFields();
                break;
            }
            case "metric_entity_identity": {
                this.setMetricDetailOptions();
                this.clearMetricFields();
                break;
            }
        }
    }

    private void setMetricFieldName(int currRowIndex) {
        MetricMapping pojo = (MetricMapping)this.getPojo();
        MetricMappingEntry row = (MetricMappingEntry)pojo.getMetricMappingEntry().get(currRowIndex);
        ModelField modelField = MetricServiceHolder.getMetricService().getModelMeta(pojo.getMetricEntityIdentity()).getFields().stream().filter(field -> field.getFieldName().equals(row.getMetricFieldKey())).findFirst().get();
        String metricFieldName = modelField.getAlias();
        FieldType fieldType = modelField.getFieldType();
        this.getModel().setValue("field_type", (Object)String.valueOf(fieldType.getFieldType()), currRowIndex);
        row.setMetricFieldName(metricFieldName);
    }

    private void clearBizFields() {
        IDataModel model = this.getModel();
        model.beginInit();
        ((MetricMapping)this.getPojo()).getMetricMappingEntry().forEach(metricMappingEntry -> {
            metricMappingEntry.setBizEntityFieldKey("");
            metricMappingEntry.setBizEntityFieldName("");
        });
        model.endInit();
        this.getView().updateView(METRIC_MAPPING_ENTRY);
    }

    private void clearMetricFields() {
        IDataModel model = this.getModel();
        model.beginInit();
        ((MetricMapping)this.getPojo()).getMetricMappingEntry().forEach(metricMappingEntry -> {
            metricMappingEntry.setMetricFieldKey("");
            metricMappingEntry.setMetricFieldName("");
            metricMappingEntry.setFieldType(null);
        });
        model.endInit();
        this.getView().updateView(METRIC_MAPPING_ENTRY);
    }

    private void clearBizFieldKey(IDataModel model, int currRowIndex) {
        model.beginInit();
        MetricMappingEntry metricMappingEntry = (MetricMappingEntry)((MetricMapping)this.getPojo()).getMetricMappingEntry().get(currRowIndex);
        String mobFieldName = metricMappingEntry.getBizEntityFieldName();
        if (StringUtils.isEmpty((CharSequence)mobFieldName)) {
            metricMappingEntry.setBizEntityFieldKey("");
        }
        this.getView().updateView(METRIC_MAPPING_ENTRY, currRowIndex);
        model.endInit();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"delete")) {
            Object metricId = this.getModel().getValue("metricdefid");
            if (metricId == null) {
                return;
            }
            QFilter qFilter = new QFilter("metricdefinitionid", "=", metricId);
            boolean exists = QueryServiceHelper.exists((String)"scmdi_assesstarget", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                String number = (String)this.getModel().getValue(NUMBER);
                String tip = number + ResManager.loadKDString((String)"\uff1a\u8be5\u6307\u6807\u6620\u5c04\u5bf9\u5e94\u7684\u4f9b\u5e94\u94fe\u6307\u6807\u5df2\u5236\u5b9a\u76ee\u6807\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"MetricDefinitionEditPlugin_6", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(tip);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("deleteentry")) {
            this.createNewEntry();
            return;
        }
        if (operateKey.equals("save")) {
            this.createNewEntry();
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        }
    }

    private void createNewEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METRIC_MAPPING_ENTRY);
        if (entryEntity.isEmpty()) {
            this.getModel().createNewEntryRow(METRIC_MAPPING_ENTRY);
        }
    }
}

