/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.mapping;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetricMappingListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("delete".equals(operateKey)) {
            this.checkDelete(args);
        }
    }

    private void checkDelete(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        Map metricsMappingMap = BusinessDataServiceHelper.loadFromCache((String)"scmdi_metrics_mapping", (String)"id,number,metricdefid", (QFilter[])new QFilter[]{qFilter});
        Collection values = metricsMappingMap.values();
        LinkedHashMap map = new LinkedHashMap(16);
        values.forEach(mapping -> {
            long metricId = mapping.getLong("metricdefid");
            if (metricId != 0L) {
                String number = mapping.getString("number");
                map.put(number, metricId);
            }
        });
        if (map.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            Long value = (Long)entry.getValue();
            boolean exist = this.existAssessTarget(value);
            if (!exist) continue;
            stringBuilder.append((String)entry.getKey()).append(ResManager.loadKDString((String)"\uff1a\u8be5\u6307\u6807\u6620\u5c04\u5bf9\u5e94\u7684\u4f9b\u5e94\u94fe\u6307\u6807\u5df2\u5236\u5b9a\u76ee\u6807\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"MetricDefinitionEditPlugin_6", (String)"scmc-scmdi-form", (Object[])new Object[0])).append("\n");
        }
        if (stringBuilder.length() > 0) {
            String tips = stringBuilder.toString();
            this.getView().showErrorNotification(tips);
            args.setCancel(true);
        }
    }

    private boolean existAssessTarget(Long value) {
        QFilter qFilter = new QFilter("metricdefinitionid", "=", (Object)value);
        return QueryServiceHelper.exists((String)"scmdi_assesstarget", (QFilter[])new QFilter[]{qFilter});
    }
}

