/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metric;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.JsonUtils;
import kd.scmc.scmdi.form.enumeration.metric.DimensionTypeEnum;
import kd.scmc.scmdi.form.enumeration.metric.MetricDimensionDateTypeEnum;
import kd.scmc.scmdi.form.plugin.form.AbstractPojoPlugin;
import kd.scmc.scmdi.form.vo.metric.MetricDefinitionEntryVo;
import kd.scmc.scmdi.form.vo.metric.MetricDefinitionVo;
import org.apache.commons.lang3.StringUtils;

public class MetricDefinitionFormPlugin
extends AbstractPojoPlugin<MetricDefinitionVo>
implements RowClickEventListener {
    public static final String DIMENSION_OBJECT = "dimension_object";
    public static final String DIMENSION_TYPE = "dimension_type";
    public static final String METRIC_OBJECT_DATE_TYPE = "metric_object_date_type";
    public static final String DIMENSION_OBJECT_JSON = "dimension_object_json";
    public static final String METRIC_DIMENSION_ENTRY = "metric_dimension_entry";
    public static final String METRIC_OBJECT_FORM_TYPE = "METRIC_OBJECT_FORM_TYPE";
    public static final String DATE_TYPE_KEY = "dateType";
    public static final String FORM_TYPE_KEY = "formType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DIMENSION_OBJECT});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "dimension_object": {
                this.selectDimensionObject();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex(METRIC_DIMENSION_ENTRY);
        switch (name = e.getProperty().getName()) {
            case "dimension_type": {
                MetricDefinitionEntryVo metricDefinitionEntryVo = ((MetricDefinitionVo)this.getPojo()).getMetricDimensionEntry().get(currRowIndex);
                metricDefinitionEntryVo.setDimensionObjectJson(null);
                metricDefinitionEntryVo.setDimensionObject(null);
                if (metricDefinitionEntryVo.getDimensionType() != null) {
                    metricDefinitionEntryVo.getDimensionType().onChanged(this.getView(), currRowIndex);
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), currRowIndex, new String[]{DIMENSION_OBJECT});
                break;
            }
        }
    }

    private void selectDimensionObject() {
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex(METRIC_DIMENSION_ENTRY);
        MetricDefinitionEntryVo metricDefinitionEntryVo = ((MetricDefinitionVo)this.getPojo()).getMetricDimensionEntry().get(currRowIndex);
        DimensionTypeEnum dimensionType = metricDefinitionEntryVo.getDimensionType();
        if (dimensionType != null) {
            dimensionType.selectDimensionObject(this.getView(), metricDefinitionEntryVo);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "metric_object_date_type": {
                this.setDateType(e);
                break;
            }
            case "METRIC_OBJECT_FORM_TYPE": {
                this.setFormType(e);
                break;
            }
        }
    }

    private void setFormType(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex(METRIC_DIMENSION_ENTRY);
        MetricDefinitionEntryVo metricDefinitionEntryVo = ((MetricDefinitionVo)this.getPojo()).getMetricDimensionEntry().get(currRowIndex);
        if (!CommonUtils.isNullOrEmpty((Object)returnData)) {
            map.put(FORM_TYPE_KEY, returnData.get(0).getPrimaryKeyValue());
            metricDefinitionEntryVo.setDimensionObject(returnData.get(0).getName());
        }
        model.setValue(DIMENSION_OBJECT_JSON, (Object)JsonUtils.toJson(map), currRowIndex);
    }

    private void setDateType(ClosedCallBackEvent e) {
        String dateType = (String)e.getReturnData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DATE_TYPE_KEY, dateType);
        IDataModel model = this.getView().getModel();
        int currEntryIndex = model.getEntryCurrentRowIndex(METRIC_DIMENSION_ENTRY);
        model.setValue(DIMENSION_OBJECT_JSON, (Object)JsonUtils.toJson(map), currEntryIndex);
        if (StringUtils.isEmpty((CharSequence)dateType)) {
            return;
        }
        MetricDimensionDateTypeEnum type = MetricDimensionDateTypeEnum.valueOf(dateType);
        String name = type.getName();
        model.setValue(DIMENSION_OBJECT, (Object)name, currEntryIndex);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MetricDefinitionVo pojo = (MetricDefinitionVo)this.getPojo();
        List<MetricDefinitionEntryVo> metricDimensionEntry = pojo.getMetricDimensionEntry();
        for (int i = 0; i < metricDimensionEntry.size(); ++i) {
            MetricDefinitionEntryVo metricDefinitionEntryVo = metricDimensionEntry.get(i);
            if (metricDefinitionEntryVo.getDimensionType() != null) {
                metricDefinitionEntryVo.getDimensionType().onChanged(this.getView(), i);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{DIMENSION_OBJECT});
        }
    }
}

