/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metric;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.JsonUtils;
import kd.scmc.scmdi.common.utils.OperationLogUtils;
import kd.scmc.scmdi.form.vo.metric.MetricImportDimensionResult;

public class MetricDefinitionListPlugin
extends AbstractTreeListPlugin {
    private static final String METRIC_IMPORT = "import_metric";
    private static final String SCMDI_METRIC_IMPORT = "scmdi_metric_import";
    private static final String SCMDI_METRIC_DEF = "scmdi_metric_def";
    private static final String SCMDI_METRIC_SOURCE = "scmdi_metric_source";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{METRIC_IMPORT});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals(METRIC_IMPORT) && afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.selectMetricSource();
        }
    }

    private void metricImport(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SCMDI_METRIC_IMPORT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCMDI_METRIC_IMPORT));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void selectMetricSource() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SCMDI_METRIC_SOURCE);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCMDI_METRIC_SOURCE));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "scmdi_metric_source": {
                this.metricImport(closedCallBackEvent);
                break;
            }
            case "scmdi_metric_import": {
                this.handleImportedData(closedCallBackEvent);
                break;
            }
        }
    }

    private void handleImportedData(ClosedCallBackEvent closedCallBackEvent) {
        List returnData = (List)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        List selectedNodeId = this.treeListView.getTreeView().getTreeState().getSelectedNodeId();
        String nodeId = CommonUtils.isNullOrEmpty((Object)selectedNodeId) ? null : (((String)selectedNodeId.get(0)).equals(this.treeListView.getTreeModel().getRoot().getId()) ? null : (String)selectedNodeId.get(0));
        List<DynamicObject> dataList = returnData.stream().map(data -> {
            DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)SCMDI_METRIC_DEF);
            target.set("number", (Object)data.getNumber());
            target.set("name", (Object)data.getName());
            target.set("enable", (Object)0);
            target.set("status", (Object)"A");
            target.set("creator", (Object)RequestContext.get().getCurrUserId());
            target.set("group", (Object)nodeId);
            target.set("import_json", (Object)JsonUtils.toJson(data.getAttributes()));
            target.set("disabler", (Object)RequestContext.get().getCurrUserId());
            target.set("disabledate", (Object)new Date());
            DynamicObjectCollection entry = target.getDynamicObjectCollection("metric_dimension_entry");
            List<MetricImportDimensionResult> dimensionList = data.getDimensionList();
            dimensionList.forEach(metricImportDimensionResult -> {
                DynamicObject dynamicObject = entry.addNew();
                dynamicObject.set("dimension_number", (Object)metricImportDimensionResult.getDimensionNumber());
                dynamicObject.set("dimension_name", (Object)metricImportDimensionResult.getDimensionName());
            });
            return target;
        }).collect(Collectors.toList());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)SCMDI_METRIC_DEF, (DynamicObject[])dataList.toArray(new DynamicObject[dataList.size()]));
        List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
        int successCount = CommonUtils.isNullOrEmpty((Object)operationResult.getSuccessPkIds()) ? 0 : operationResult.getSuccessPkIds().size();
        int failedCount = dataList.size() - successCount;
        String title = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6307\u6807", (String)"MetricDefinitionListPlugin_IMPORT", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u6761\u6307\u6807\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u6761\u6307\u6807\u3002", (String)"MetricDefinitionListPlugin_IMPORT_DESC", (String)"scmc-scmdi-form", (Object[])new Object[0]), successCount, failedCount);
        OperationLogUtils.record((String)SCMDI_METRIC_DEF, (String)title, (String)desc);
        if (CommonUtils.isNullOrEmpty((Object)allErrorInfo)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6307\u6807\u6210\u529f\u3002", (String)"MetricDefinitionListPlugin_SUCCESS", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
        this.reload();
    }
}

