/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metric;

import com.kingdee.bos.qing.modeler.api.response.FieldType;
import com.kingdee.bos.qing.modeler.api.response.ModelField;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.scmdi.business.metric.MetricDefinition;
import kd.scmc.scmdi.business.metric.MetricServiceHolder;
import kd.scmc.scmdi.common.utils.JsonUtils;
import kd.scmc.scmdi.form.vo.metric.CosmicMetric;
import kd.scmc.scmdi.form.vo.metric.MetricImportDimensionResult;
import kd.scmc.scmdi.form.vo.metric.MetricImportResult;

public class MetricImportPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(MetricImportPlugin.class);
    private static final String ENTRY = "entryentity";
    private static final String BTN_OK = "btnok";

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (BTN_OK.equals(control.getKey())) {
            IFormView view = this.getView();
            EntryGrid billList = (EntryGrid)this.getControl(ENTRY);
            int[] selectedRows = billList.getSelectRows();
            if (selectedRows == null || selectedRows.length == 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"MetricImportPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]));
                return;
            }
            List metrics = Arrays.stream(selectedRows).mapToObj(i -> i).map(i -> {
                String json = (String)this.getModel().getValue("serialized_json", i.intValue());
                return (CosmicMetric)JsonUtils.fromJson((String)json, CosmicMetric.class);
            }).map(metric -> {
                MetricImportResult metricImportResult = new MetricImportResult();
                metricImportResult.setName(metric.getMetric().getAlias());
                metricImportResult.setNumber(metric.getMetric().getFieldName());
                List<MetricImportDimensionResult> dimensionResults = MetricServiceHolder.getMetricService().getModelMeta(metric.getDefinition().getId()).getFields().stream().filter(modelField -> modelField.getFieldType() == FieldType.dimension).map(f -> {
                    MetricImportDimensionResult dimensionResult = new MetricImportDimensionResult();
                    dimensionResult.setDimensionName(f.getAlias());
                    dimensionResult.setDimensionNumber(f.getFieldName());
                    return dimensionResult;
                }).collect(Collectors.toList());
                metricImportResult.setDimensionList(dimensionResults);
                metricImportResult.addAttribute("metricImportSource", "COSMIC_METRIC");
                metricImportResult.addAttribute("metricModelId", metric.getDefinition().getId());
                return metricImportResult;
            }).collect(Collectors.toList());
            view.returnDataToParent(metrics);
            view.close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fulfillMetricList();
    }

    private void fulfillMetricList() {
        List metricDefinitions = MetricServiceHolder.getMetricService().getMetricDefinitions();
        IDataModel model = this.getView().getModel();
        List metricList = metricDefinitions.stream().flatMap(m -> {
            try {
                return MetricServiceHolder.getMetricService().getModelMeta(m.getId()).getFields().stream().filter(modelField -> modelField.getFieldType() == FieldType.metric).map(modelField -> new CosmicMetric((ModelField)modelField, (MetricDefinition)m));
            }
            catch (Exception e) {
                log.warn("fulfillMetricList:" + m.getId(), (Throwable)e);
                return Stream.of(new CosmicMetric[0]);
            }
        }).collect(Collectors.toList());
        int size = metricList.size();
        if (size == 0) {
            return;
        }
        model.batchCreateNewEntryRow(ENTRY, size);
        for (int i = 0; i < size; ++i) {
            CosmicMetric metric = (CosmicMetric)metricList.get(i);
            MetricDefinition metricDefinition = metric.getDefinition();
            model.setValue("model_set", (Object)metricDefinition.getModelSetName(), i);
            model.setValue("directory", (Object)metricDefinition.getDirectoryName(), i);
            model.setValue("model_name", (Object)metricDefinition.getName(), i);
            model.setValue("metric_number", (Object)metric.getMetric().getFieldName(), i);
            model.setValue("metric_name", (Object)metric.getMetric().getAlias(), i);
            model.setValue("serialized_json", (Object)JsonUtils.toJson((Object)metric), i);
        }
    }
}

