/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BizBasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.common.enumeration.PeriodType;
import kd.scmc.scmdi.common.pojo.DimensionEntryInfo;
import kd.scmc.scmdi.common.pojo.ImportData;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.JsonUtils;
import kd.scmc.scmdi.common.utils.excel.ExcelUtils;
import kd.scmc.scmdi.common.utils.excel.FileUtils;
import kd.scmc.scmdi.form.plugin.form.metrics.ValueStorageEntity;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AssessTargetEntryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private MainEntityType mainEntityType;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EXPORT, IMPORT});
    }

    private MainEntityType getMetricMappingMeta(FormShowParameter formShowParameter) {
        Long metricDefinitionId;
        QFilter qFilter;
        DynamicObject mapping;
        if (this.mainEntityType != null) {
            return this.mainEntityType;
        }
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        if ((mapping = BusinessDataServiceHelper.loadSingle((String)"scmdi_metrics_mapping", (QFilter[])(qFilter = new QFilter("metricdefid", "=", (Object)(metricDefinitionId = Long.valueOf((String)formShowParameter.getCustomParam("metricdefinitionid"))))).toArray())) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u6807\u6620\u5c04\uff0c\u65e0\u6cd5\u8fdb\u884c\u76ee\u6807\u503c\u8bbe\u7f6e", (String)"AssessTargetEntryPlugin_getMetricMappingMeta_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        DynamicObject biz_entity = mapping.getDynamicObject("biz_entity");
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)biz_entity.getString("number"));
        return this.mainEntityType;
    }

    private List<DimensionEntryInfo> getDimensionList(FormShowParameter formShowParameter) {
        String json;
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        ArrayList<DimensionEntryInfo> dimensionList = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(json = (String)formShowParameter.getCustomParam("dimension_list_json"))) ? new ArrayList() : JsonUtils.fromJsonToList((String)json, DimensionEntryInfo.class);
        return dimensionList;
    }

    private PeriodType getPeriodType(FormShowParameter formShowParameter) {
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        String periodType = (String)formShowParameter.getCustomParam("period_type");
        return PeriodType.valueOf((String)periodType);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter source = (FormShowParameter)e.getSource();
        EntryAp entryAp = this.createDynamicEntryAp(source);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", ENTRY_ENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new KDBizException(exception.getMessage());
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        String dimDetailJson = (String)this.getView().getFormShowParameter().getCustomParam("allValues");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dimDetailJson)) {
            super.createNewData(e);
            return;
        }
        ValueStorageEntity valueStorageEntity = ValueStorageEntity.fromJsonString(dimDetailJson);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        valueStorageEntity.setData(dataEntity);
        e.setDataEntity((Object)dataEntity);
    }

    public void beforeBindData(EventObject e) {
        List<DimensionEntryInfo> dimensionList = this.getDimensionList(null);
        if (CommonUtils.isNullOrEmpty(dimensionList)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        }
        EntryAp dynamicEntryAp = this.createDynamicEntryAp(null);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private BasedataEdit createServerEditor(DimensionEntryInfo dim, MainEntityType metricMappingMeta) {
        BizBasedataEdit basedataEdit;
        IDataEntityProperty dimensionProperty = (IDataEntityProperty)metricMappingMeta.getProperties().get((Object)dim.getDimensionIdentity());
        if (dimensionProperty instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)dimensionProperty;
            OrgEdit orgEdit = new OrgEdit();
            orgEdit.setOrgFunc(orgProp.getOrgFunc());
            basedataEdit = orgEdit;
        } else {
            basedataEdit = this.isBizBaseData(dim.getMetaDataNumber()) ? new BizBasedataEdit() : new BasedataEdit();
        }
        basedataEdit.setF7MultipleSelect(false);
        basedataEdit.setF7BatchFill(false);
        return basedataEdit;
    }

    public void onGetControl(OnGetControlArgs event) {
        PeriodType periodType;
        String key = event.getKey();
        List<DimensionEntryInfo> dimensionList = this.getDimensionList(null);
        MainEntityType metricMappingMeta = this.getMetricMappingMeta(null);
        DimensionEntryInfo dimensionEntryInfo = dimensionList.stream().filter(dim -> dim.getDimensionWithPrefix().equals(key)).findAny().orElse(null);
        if (dimensionEntryInfo != null) {
            BasedataEdit basedataEdit = this.createServerEditor(dimensionEntryInfo, metricMappingMeta);
            basedataEdit.setKey(key);
            basedataEdit.setEntryKey(ENTRY_ENTITY);
            basedataEdit.setView(this.getView());
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.setF7BatchFill(false);
            event.setControl((Control)basedataEdit);
        }
        if ((periodType = this.getPeriodType(null)).getPeriods().containsKey(event.getKey())) {
            DecimalEdit basedataEdit = new DecimalEdit();
            basedataEdit.setKey(key);
            basedataEdit.setEntryKey(ENTRY_ENTITY);
            basedataEdit.setView(this.getView());
            basedataEdit.addClickListener((ClickListener)this);
            event.setControl((Control)basedataEdit);
        }
        if (key.equals(ENTRY_ENTITY)) {
            EntryGrid entryGrid = (EntryGrid)event.getControl();
            if (entryGrid == null) {
                return;
            }
            entryGrid.getItems().clear();
            dimensionList.forEach(dimension -> {
                String dimensionWithPrefix = dimension.getDimensionWithPrefix();
                BasedataEdit basedataEdit = this.createServerEditor((DimensionEntryInfo)dimension, metricMappingMeta);
                basedataEdit.setKey(dimensionWithPrefix);
                basedataEdit.setEntryKey(ENTRY_ENTITY);
                basedataEdit.setView(this.getView());
                basedataEdit.setF7BatchFill(false);
                entryGrid.getItems().add(basedataEdit);
            });
            periodType.getPeriods().forEach((key1, value) -> {
                DecimalEdit basedataEdit = new DecimalEdit();
                basedataEdit.setKey(key1);
                basedataEdit.setEntryKey(ENTRY_ENTITY);
                basedataEdit.setView(this.getView());
                basedataEdit.addClickListener((ClickListener)this);
                entryGrid.getItems().add(basedataEdit);
            });
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(EXPORT)) {
            this.exportExcel();
        }
        if (key.equals(IMPORT)) {
            this.importExcel();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndex;
        super.beforeDeleteRow(e);
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (ENTRY_ENTITY.equals(e.getEntryProp().getName()) && (rowIndex = e.getRowIndexs()).length == rowCount) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4fdd\u7559\u4e00\u884c\u3002", (String)"AssessTargetEntryPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
    }

    private EntryAp createDynamicEntryAp(FormShowParameter formShowParameter) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.setMulti(false);
        List<DimensionEntryInfo> dimensionList = this.getDimensionList(formShowParameter);
        MainEntityType metricMappingMeta = this.getMetricMappingMeta(formShowParameter);
        dimensionList.forEach(dimension -> {
            String dimensionWithPrefix = dimension.getDimensionWithPrefix();
            String dimensionName = dimension.getDimensionName();
            String metaDataNumber = dimension.getMetaDataNumber();
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(dimensionWithPrefix);
            fieldAp.setKey(dimensionWithPrefix);
            fieldAp.setName(new LocaleString(dimensionName));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setQuickAddNew(false);
            fieldAp.setF7MultipleSelect(false);
            BasedataField field = this.createField((DimensionEntryInfo)dimension, metaDataNumber, metricMappingMeta);
            fieldAp.setField((Field)field);
            fieldAp.createColumns();
            field.setBizBasedata(this.isBizBaseData(metaDataNumber));
            entryAp.getItems().add(fieldAp);
        });
        PeriodType periodType = this.getPeriodType(formShowParameter);
        periodType.getPeriods().entrySet().forEach(e -> {
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId((String)e.getKey());
            fieldAp.setKey((String)e.getKey());
            fieldAp.setName(new LocaleString((String)e.getValue()));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setF7MultipleSelect(false);
            fieldAp.setWidth(new LocaleString("100px"));
            DecimalField field = new DecimalField();
            field.setId((String)e.getKey());
            field.setKey((String)e.getKey());
            field.setNeedFormat(false);
            field.setZeroShow(false);
            field.setScale(10);
            field.setPrecision(23);
            fieldAp.setField((Field)field);
            fieldAp.createColumns();
            fieldAp.setNoDisplayScaleZero(true);
            entryAp.getItems().add(fieldAp);
        });
        return entryAp;
    }

    private BasedataField createField(DimensionEntryInfo dimensionEntryInfo, String metaDataNumber, MainEntityType metricMappingMeta) {
        Object field;
        IDataEntityProperty dimensionProperty = (IDataEntityProperty)metricMappingMeta.getProperties().get((Object)dimensionEntryInfo.getDimensionIdentity());
        if (dimensionProperty instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)dimensionProperty;
            field = new OrgField(){

                protected OrgEdit createServerEditor() {
                    return new OrgEdit();
                }
            };
            OrgField orgField = (OrgField)field;
            orgField.setOrgFuncs(orgProp.getOrgFunc());
        } else {
            field = new BasedataField();
        }
        field.setId(dimensionEntryInfo.getDimensionWithPrefix());
        field.setKey(dimensionEntryInfo.getDimensionWithPrefix());
        field.setBaseEntityNumber(metaDataNumber);
        return field;
    }

    private boolean isBizBaseData(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        boolean isBizBaseData = mainType instanceof BasedataEntityType && ((BasedataEntityType)mainType).getMasteridType() == 2;
        return isBizBaseData;
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRY_ENTITY);
        List<DimensionEntryInfo> dimensionList = this.getDimensionList(null);
        MainEntityType metricMappingMeta = this.getMetricMappingMeta(null);
        dimensionList.forEach(dimension -> {
            String metaDataNumber = dimension.getMetaDataNumber();
            BasedataProp basedataProp = this.getBasedataProp((DimensionEntryInfo)dimension, metaDataNumber, metricMappingMeta);
            DynamicSimpleProperty pRefId = basedataProp.createRefIDProp();
            pRefId.setPrimaryKey(false);
            if (StringUtils.isBlank((CharSequence)basedataProp.getAlias())) {
                pRefId.setDbIgnore(true);
            } else {
                pRefId.setAlias(basedataProp.getAlias());
                pRefId.setTableGroup(basedataProp.getTableGroup());
            }
            pRefId.setName(basedataProp.getName() + "_id");
            entryType.registerSimpleProperty(pRefId);
            basedataProp.setRefIdPropName(basedataProp.getName() + "_id");
            basedataProp.setRefIdProp((IDataEntityProperty)pRefId);
            entryType.registerComplexProperty((DynamicComplexProperty)basedataProp);
        });
        PeriodType periodType = this.getPeriodType(null);
        periodType.getPeriods().entrySet().forEach(e -> {
            DecimalProp basedataProp = new DecimalProp();
            basedataProp.setName((String)e.getKey());
            basedataProp.setDisplayName(new LocaleString((String)e.getValue()));
            basedataProp.setDbIgnore(true);
            basedataProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)basedataProp);
        });
    }

    private BasedataProp getBasedataProp(DimensionEntryInfo dimension, String metaDataNumber, MainEntityType metricMappingMeta) {
        BasedataProp basedataProp;
        IDataEntityProperty dimensionProperty = (IDataEntityProperty)metricMappingMeta.getProperties().get((Object)dimension.getDimensionIdentity());
        if (dimensionProperty instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)dimensionProperty;
            OrgProp genOrgProp = new OrgProp();
            genOrgProp.setOrgFunc(orgProp.getOrgFunc());
            basedataProp = genOrgProp;
        } else {
            basedataProp = new BasedataProp();
        }
        basedataProp.setName(dimension.getDimensionWithPrefix());
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)metaDataNumber);
        basedataProp.setDisplayName(dt.getDisplayName());
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        basedataProp.setBaseEntityId(metaDataNumber);
        basedataProp.setComplexType((IDataEntityType)dt);
        return basedataProp;
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
    }

    private void importExcel() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("scmdi_target_import");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "import": {
                this.parseImportExcel(closedCallBackEvent);
                break;
            }
        }
    }

    private void parseImportExcel(ClosedCallBackEvent closedCallBackEvent) {
        List<DimensionEntryInfo> dimensionList;
        String url = (String)closedCallBackEvent.getReturnData();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        TempFileCacheDownloadable.Content content = FileUtils.getFileContent((String)url);
        if (content == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\u5185\u5bb9\uff01", (String)"AssessTargetEntryPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        InputStream inputStream = content.getInputStream();
        List<ImportData> importDataList = this.readExcel(inputStream, dimensionList = this.getDimensionList(null));
        int size = importDataList.size();
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u7a7a\u7684\u6587\u4ef6\uff0c\u8bf7\u586b\u5199\u76ee\u6807\u660e\u7ec6\u4e4b\u540e\u518d\u4e0a\u4f20\u3002", (String)"AssessTargetEntryPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, size);
        for (int i = 0; i < size; ++i) {
            int rowIndex = i;
            ImportData importData = importDataList.get(i);
            Map valueMap = importData.getValueMap();
            Map dimensionMap = importData.getDimensionMap();
            valueMap.entrySet().forEach(stringBigDecimalEntry -> this.getModel().setValue((String)stringBigDecimalEntry.getKey(), stringBigDecimalEntry.getValue(), rowIndex));
            dimensionMap.entrySet().forEach(dimNumberEntry -> {
                String entityNumber;
                String key = (String)dimNumberEntry.getKey();
                String value = (String)dimNumberEntry.getValue();
                String metaDataNumber = dimensionList.stream().filter(dim -> dim.getDimensionWithPrefix().equals(key)).findAny().get().getMetaDataNumber();
                BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)metaDataNumber);
                if (dataEntityType.getMasteridType() == 2) {
                    MasterBasedataProp property = (MasterBasedataProp)dataEntityType.getProperties().get((Object)dataEntityType.getMasteridPropName());
                    entityNumber = property.getBaseEntityId();
                } else {
                    entityNumber = metaDataNumber;
                }
                String numberProperty = dataEntityType.getNumberProperty();
                QFilter qFilter = new QFilter(numberProperty, "=", (Object)value);
                DynamicObject selectedData = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)(numberProperty + ",id"), (QFilter[])qFilter.toArray());
                this.getView().getModel().setValue(key, (Object)selectedData, rowIndex);
            });
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4eceexcel\u4e2d\u5bfc\u5165\u4e86%s\u884c\u6570\u636e\u3002", (String)"AssessTargetEntryPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), size));
    }

    public List<ImportData> readExcel(InputStream inputStream, List<DimensionEntryInfo> dimensionList) {
        XSSFWorkbook workbook;
        PeriodType periodType = this.getPeriodType(null);
        Map periods = periodType.getPeriods();
        try {
            workbook = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new KDBizException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
        XSSFSheet sheet = workbook.getSheetAt(0);
        XSSFRow identifyRow = sheet.getRow(1);
        XSSFRow titleRow = sheet.getRow(2);
        AtomicInteger titleIndex = new AtomicInteger();
        XSSFCell cell = titleRow.getCell(titleIndex.get());
        String stringCellValue = cell.getStringCellValue();
        if (!stringCellValue.equals("\u5e8f\u53f7")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3002", (String)"AssessTargetEntryPlugin_readExcel_failed", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        titleIndex.getAndIncrement();
        int i = 0;
        for (DimensionEntryInfo dimensionInfo : dimensionList) {
            String dimension2 = dimensionInfo.getDimensionWithPrefix();
            XSSFCell cell2 = identifyRow.getCell(titleIndex.get());
            String stringCellValue2 = cell2.getStringCellValue();
            if (!stringCellValue2.equals(dimension2)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3002", (String)"AssessTargetEntryPlugin_readExcel_failed", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            }
            cell2 = titleRow.getCell(titleIndex.get());
            stringCellValue2 = cell2.getStringCellValue();
            String dimName = dimensionInfo.getDimensionName();
            if (!stringCellValue2.equals("\u7ef4\u5ea6" + (i + 1) + "-" + dimName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3002", (String)"AssessTargetEntryPlugin_readExcel_failed", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            }
            ++i;
            titleIndex.getAndIncrement();
        }
        periods.entrySet().forEach(entry -> {
            String period = (String)entry.getKey();
            XSSFCell cell = identifyRow.getCell(titleIndex.get());
            String stringCellValue = cell.getStringCellValue();
            if (!stringCellValue.equals(period)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3002", (String)"AssessTargetEntryPlugin_readExcel_failed", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            }
            period = (String)entry.getValue();
            cell = titleRow.getCell(titleIndex.get());
            stringCellValue = cell.getStringCellValue();
            if (!stringCellValue.equals(period)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3002", (String)"AssessTargetEntryPlugin_readExcel_failed", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            }
            titleIndex.getAndIncrement();
        });
        int lastRowNum = sheet.getLastRowNum();
        ArrayList<ImportData> importDataList = new ArrayList<ImportData>();
        for (int rowNumber = 3; rowNumber <= lastRowNum; ++rowNumber) {
            ImportData importData = new ImportData();
            XSSFRow dataRow = sheet.getRow(rowNumber);
            boolean rowEmpty = ExcelUtils.isRowEmpty((Row)dataRow);
            if (rowEmpty) break;
            AtomicInteger titleIndex2 = new AtomicInteger();
            titleIndex2.getAndIncrement();
            dimensionList.forEach(dimension -> {
                XSSFCell cell = dataRow.getCell(titleIndex2.get());
                String stringCellValue = ExcelUtils.getStringValue((XSSFCell)cell);
                importData.setDimension(dimension.getDimensionWithPrefix(), stringCellValue);
                titleIndex2.getAndIncrement();
            });
            periods.entrySet().forEach(entry -> {
                XSSFCell cell = dataRow.getCell(titleIndex2.get());
                BigDecimal value = ExcelUtils.getBigDecimal((XSSFCell)cell);
                importData.setValue((String)entry.getKey(), value);
                titleIndex2.getAndIncrement();
            });
            importDataList.add(importData);
        }
        return importDataList;
    }

    private void exportExcel() {
        SXSSFWorkbook workbook = this.getWorkbook();
        IFormView view = this.getView();
        String fileName = "\u6307\u6807\u76ee\u6807\u503c\u5bfc\u5165\u6a21\u677f_" + this.getDimensionList(null).size() + "\u7ef4\u5ea6_" + this.getPeriodType(null) + ".xlsx";
        ExcelUtils.downloadExcel((Workbook)workbook, (IFormView)view, (String)fileName);
    }

    public SXSSFWorkbook getWorkbook() {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet("\u76ee\u6807\u503c\u660e\u7ec6");
        this.setRemarks(workbook, sheet);
        this.setTitle(workbook, sheet);
        return workbook;
    }

    private void setRemarks(SXSSFWorkbook workbook, SXSSFSheet sheet) {
        SXSSFRow row = sheet.createRow(0);
        int columnIndex = 0;
        SXSSFCell cell = row.createCell(columnIndex);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        cell.setCellValue("\u8bf4\u660e\uff1a\u8bf7\u52ff\u4fee\u6539\u672c\u6587\u6863\u7684\u683c\u5f0f\u3002\n\u7ef4\u5ea6\u8bf7\u586b\u5199\u57fa\u7840\u8d44\u6599\u7684\u7f16\u7801\u3002\u4e0d\u5b58\u5728\u7684\u7f16\u7801\u4f1a\u88ab\u5ffd\u7565\u3002\n\u5e8f\u53f7\u8bf7\u4ece1\u5f00\u59cb\u4f9d\u6b21\u586b\u5199\uff0c\u82e5\u5e8f\u53f7\u9519\u8bef\u7684\u884c\u4f1a\u88ab\u5ffd\u7565\u3002");
        cell.setCellStyle(cellStyle);
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, this.getDimensionList(null).size() + this.getPeriodType(null).getPeriods().size());
        sheet.addMergedRegion(cellRangeAddress);
        row.setHeight((short)1000);
    }

    private void setTitle(SXSSFWorkbook workbook, SXSSFSheet sheet) {
        SXSSFRow identifyRow = sheet.createRow(1);
        SXSSFRow titleRow = sheet.createRow(2);
        CellStyle titleStyle = ExcelUtils.getTitleStyle((SXSSFWorkbook)workbook);
        CellStyle dimensionDataStyle = ExcelUtils.getDimensionDataStyle((SXSSFWorkbook)workbook);
        CellStyle valueDataStyle = ExcelUtils.getValueDataStyle((SXSSFWorkbook)workbook);
        AtomicInteger columnIndex = new AtomicInteger();
        SXSSFCell cell = titleRow.createCell(columnIndex.get());
        cell.setCellValue("\u5e8f\u53f7");
        cell.setCellStyle(titleStyle);
        sheet.setColumnWidth(columnIndex.get(), 2000);
        columnIndex.getAndIncrement();
        List<DimensionEntryInfo> dimensionList = this.getDimensionList(null);
        Map periods = this.getPeriodType(null).getPeriods();
        int flag = 0;
        for (DimensionEntryInfo dimensionEntryInfo : dimensionList) {
            sheet.setDefaultColumnStyle(columnIndex.get(), dimensionDataStyle);
            SXSSFCell cell2 = identifyRow.createCell(columnIndex.get());
            cell2.setCellValue(dimensionEntryInfo.getDimensionWithPrefix());
            cell2.setCellStyle(titleStyle);
            sheet.setColumnWidth(columnIndex.get(), 8000);
            cell2 = titleRow.createCell(columnIndex.get());
            int row = flag + 1;
            cell2.setCellValue("\u7ef4\u5ea6" + row + "-" + dimensionEntryInfo.getDimensionName());
            cell2.setCellStyle(titleStyle);
            sheet.setColumnWidth(columnIndex.get(), 8000);
            ++flag;
            columnIndex.getAndIncrement();
        }
        periods.entrySet().forEach(entry -> {
            sheet.setDefaultColumnStyle(columnIndex.get(), valueDataStyle);
            SXSSFCell cell = identifyRow.createCell(columnIndex.get());
            cell.setCellValue((String)entry.getKey());
            cell.setCellStyle(titleStyle);
            cell = titleRow.createCell(columnIndex.get());
            cell.setCellValue((String)entry.getValue());
            cell.setCellStyle(titleStyle);
            sheet.setColumnWidth(columnIndex.get(), 3000);
            columnIndex.getAndIncrement();
        });
        identifyRow.setHidden(Boolean.valueOf(true));
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
    }
}

