/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metrics;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.scmdi.common.enumeration.PeriodType;
import kd.scmc.scmdi.common.pojo.DimensionEntryInfo;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.JsonUtils;
import kd.scmc.scmdi.common.utils.StyleUtils;
import kd.scmc.scmdi.form.plugin.form.metrics.ValueStorageEntity;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class AssessTargetFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String TABLE_PAGE_ID = "TABLE_PAGE_ID";
    private static final String ASSESS_TARGET = "scmdi_assesstarget";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"detail", "assessdimension", "set_target_label", "buttonap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setMetricHeadInfo();
        List<DynamicObject> targets = this.getTargetList();
        this.fulfillTargetEntryList(targets);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("goalsetting".equals(type)) {
            this.goalSettingPageInitSetting(targets);
        } else if ("querygoal".equals(type)) {
            this.goalQueryPageInitSetting(targets);
        }
        this.setBillButtonVisibleByStatus();
        this.setSplitContainerVisible();
    }

    private void setMetricHeadInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long metricId = (Long)customParams.get("metricId");
        this.getModel().setValue("metricdefinitionid", (Object)metricId);
        Object metricNumber = customParams.get("metricNumber");
        this.getModel().setValue("metricnum", metricNumber);
        String metricName = (String)customParams.get("metricName");
        this.getModel().setValue("metricname", (Object)metricName);
        Object metricGroup = customParams.get("metricGroup");
        this.getModel().setValue("metricgroup", metricGroup);
        String statRate = (String)customParams.get("statrate");
        this.getModel().setValue("statrate", (Object)statRate);
        Object metricDefinition = customParams.get("metricDefinition");
        this.getModel().setValue("metricdefinition", metricDefinition);
    }

    private List<DynamicObject> getTargetList() {
        Long metricId = this.getMetricDefinitionId();
        QFilter filter = new QFilter("metricdefinitionid", "=", (Object)metricId);
        Map assessTargetMap = BusinessDataServiceHelper.loadFromCache((String)ASSESS_TARGET, (String)"id,assesscyclegrain,assessyear,assessdimension,assess_dimension_json_tag,billstatus,targetvaluejson_tag,metricdefinitionid,creator,createtime,modifier,modifytime", (QFilter[])new QFilter[]{filter}, (String)"assessyear desc");
        return assessTargetMap.values().stream().collect(Collectors.toList());
    }

    private void goalQueryPageInitSetting(List<DynamicObject> targets) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"buttonap"});
        if (targets == null || targets.isEmpty()) {
            return;
        }
        this.setTargetFormBySelectedTarget(targets);
    }

    private void goalSettingPageInitSetting(List<DynamicObject> targets) {
        boolean year;
        String statRate = (String)this.getModel().getValue("statrate");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap"});
        boolean bl = year = statRate.equals("MONTH") || statRate.equals("QUARTER") || statRate.equals("YEAR");
        if (year) {
            this.getModel().setValue("assesscyclegrain", (Object)statRate);
            this.setNewFormValues(targets);
            this.generateTable();
        } else if (!targets.isEmpty()) {
            this.setTargetFormBySelectedTarget(targets);
        } else {
            this.getModel().setValue("assesscyclegrain", (Object)"CONSTANT");
            this.setNewFormValues(null);
            this.generateTable();
        }
    }

    private void setNewFormValues(List<DynamicObject> targets) {
        this.getModel().setValue("assessyear", (Object)this.getNewTargetYear(targets));
        this.getModel().setValue("billstatus", (Object)"A");
        this.getModel().setValue("assessdimension", null);
        this.getModel().setValue("assess_dimension_json_tag", null);
        this.getModel().setValue("targetvaluejson_tag", null);
        this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("createtime", (Object)new Date());
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("modifytime", (Object)new Date());
        this.getModel().setValue("id", null);
    }

    private void fulfillTargetEntryList(List<DynamicObject> targetList) {
        this.getModel().deleteEntryData("targetentry");
        if (targetList == null || targetList.isEmpty()) {
            return;
        }
        int i = 0;
        IFormView view = this.getView();
        this.getModel().batchCreateNewEntryRow("targetentry", targetList.size());
        for (DynamicObject assessTarget : targetList) {
            CardEntry cardEntry = (CardEntry)view.getControl("targetentry");
            Object status = assessTarget.get("billstatus");
            this.getModel().setValue("entryassessyear", assessTarget.get("assessyear"), i);
            this.getModel().setValue("status", status, i);
            this.getModel().setValue("targetid", assessTarget.get("id"), i);
            this.getModel().setValue("dimension", (Object)assessTarget.getString("assessdimension"), i);
            HashMap<String, Map> entryFieldsMap = new HashMap<String, Map>(1);
            Map colorMap = null;
            if ("A".equals(status)) {
                colorMap = StyleUtils.getColorMap((String)"#F5F5F5", (String)"#666666", (String)"#CCCCCC");
            }
            if ("B".equals(status)) {
                colorMap = StyleUtils.getColorMap((String)"#F2F9FF", (String)"#276FF5", (String)"#85B8FF");
            }
            if ("C".equals(status)) {
                colorMap = StyleUtils.getColorMap((String)"#F2FFF5", (String)"#1BA854", (String)"#6DD18E");
            }
            entryFieldsMap.put("status", colorMap);
            cardEntry.setCustomProperties(cardEntry.getKey(), i, entryFieldsMap);
            ++i;
        }
    }

    private void setTargetFormBySelectedTarget(List<DynamicObject> targets) {
        int selectedIndex;
        if (targets == null || targets.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
        if (entryGrid.getSelectRows().length == 0) {
            selectedIndex = 0;
            entryGrid.selectRows(0, true);
        } else {
            selectedIndex = entryGrid.getSelectRows()[0];
        }
        DynamicObject assessTarget = targets.get(selectedIndex);
        this.fulfillTargetForm(assessTarget);
        this.setSplitContainerVisible();
    }

    private void setSplitContainerVisible() {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        String value = (String)this.getView().getModel().getValue("assesscyclegrain");
        splitContainer.hidePanel(SplitDirection.left, "CONSTANT".equals(value));
        this.getView().setVisible(Boolean.valueOf(!"CONSTANT".equals(value)), new String[]{"assessyear"});
    }

    private void fulfillTargetForm(DynamicObject assessTarget) {
        this.getModel().setValue("assesscyclegrain", assessTarget.get("assesscyclegrain"));
        this.getModel().setValue("assessyear", assessTarget.get("assessyear"));
        this.getModel().setValue("assessdimension", assessTarget.get("assessdimension"));
        this.getModel().setValue("billstatus", assessTarget.get("billstatus"));
        this.getModel().setValue("targetvaluejson_tag", assessTarget.get("targetvaluejson_tag"));
        this.getModel().setValue("creator", assessTarget.get("creator"));
        this.getModel().setValue("createtime", assessTarget.get("createtime"));
        this.getModel().setValue("modifier", assessTarget.get("modifier"));
        this.getModel().setValue("modifytime", assessTarget.get("modifytime"));
        this.getModel().setValue("assess_dimension_json_tag", assessTarget.get("assess_dimension_json_tag"));
        if (!this.getModel().getValue("id").equals(assessTarget.get("id"))) {
            this.getModel().setValue("id", assessTarget.get("id"));
            this.generateTable();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("buttonap".equals(key) || "set_target_label".equals(key)) {
            this.addNewTarget();
        } else if ("detail".equals(key)) {
            this.showMetricDetail();
        } else if ("assessdimension".equals(key)) {
            this.showMetricDimensionF7();
        }
    }

    private void showMetricDimensionF7() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scmdi_assessdimension");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long metricId = (Long)this.getView().getFormShowParameter().getCustomParam("metricId");
        formShowParameter.setCustomParam("metricId", (Object)metricId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assessdimension"));
        this.getView().showForm(formShowParameter);
    }

    private void showMetricDetail() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("scmdi_metrics_def");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        Object id = formShowParameter.getCustomParam("metricId");
        baseShowParameter.setPkId(id);
        String pageId = (String)formShowParameter.getCustomParam("pageId");
        if (pageId != null && this.getView().existView(pageId)) {
            baseShowParameter.setPageId(pageId);
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void addNewTarget() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"cardentryfixrowap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
        entryGrid.selectRows(new int[0], 0);
        List<DynamicObject> targetList = this.getTargetList();
        this.goalSettingPageInitSetting(targetList);
        this.setBillButtonVisibleByStatus();
    }

    private Long getMetricDefinitionId() {
        Object metricId = this.getModel().getValue("metricdefinitionid");
        Long id = Long.valueOf((String)metricId);
        return id;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"assessdimension")) {
            this.dimensionF7CloseCallBack(closedCallBackEvent);
        }
    }

    private void dimensionF7CloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        List selectedDimensions = (List)closedCallBackEvent.getReturnData();
        String dimensionListJson = JsonUtils.toJson((Object)selectedDimensions);
        String assessDimensionJsonTag = (String)this.getModel().getValue("assess_dimension_json_tag");
        if (assessDimensionJsonTag.equals(dimensionListJson)) {
            this.setDimensionNameText(selectedDimensions);
            return;
        }
        Set<DimensionEntryInfo> fulfilledDimensions = this.getFulfilledDimensions();
        if (fulfilledDimensions != null) {
            fulfilledDimensions.removeAll(selectedDimensions);
        }
        if (fulfilledDimensions != null && !CommonUtils.isNullOrEmpty(fulfilledDimensions)) {
            String message = ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u66f4\u65b0\u7ef4\u5ea6\uff1f", (String)"AssessTargetFormPlugin_dimensionF7CloseCallBack_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
            String dimNames = fulfilledDimensions.stream().map(DimensionEntryInfo::getDimensionName).collect(Collectors.joining(","));
            String messageDetail = String.format(ResManager.loadKDString((String)"\u539f\u6709\u7684\u201c%1$s\u201d\u7ef4\u5ea6\u4e0b\u5df2\u6709\u6570\u636e\uff0c\u66f4\u65b0\u540e\u7ef4\u5ea6\u4e0b\u7684\u6570\u636e\u5c06\u6e05\u9664\u3002", (String)"AssessTargetFormPlugin_dimensionF7CloseCallBack_2", (String)"scmc-scmdi-form", (Object[])new Object[0]), dimNames);
            this.getView().getPageCache().putBigObject("assess_dimension_json_tag", dimensionListJson);
            this.getView().showConfirm(message, messageDetail, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("updateDimensions", (IFormPlugin)this));
        } else {
            this.generateTableByNewDimension(dimensionListJson, selectedDimensions);
        }
    }

    private void setDimensionNameText(List<DimensionEntryInfo> dimensionList) {
        this.getModel().setValue("assessdimension", (Object)CommonUtils.subString((String)dimensionList.stream().map(DimensionEntryInfo::getDimensionName).collect(Collectors.joining(",")), (int)500));
    }

    private Set<DimensionEntryInfo> getFulfilledDimensions() {
        String pageId = this.getView().getPageCache().get(TABLE_PAGE_ID);
        if (pageId == null) {
            return null;
        }
        DynamicObject dataEntity = this.getView().getView(pageId).getModel().getDataEntity(true);
        ValueStorageEntity valueStorageEntity = new ValueStorageEntity(dataEntity, this.getDimensionList(), PeriodType.valueOf((String)((String)this.getModel().getValue("assesscyclegrain"))));
        return valueStorageEntity.getFulfilledDimensions();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("updateDimensions".equals(messageBoxClosedEvent.getCallBackId())) {
            this.dimensionChangedConfirmCallBack(messageBoxClosedEvent);
        }
    }

    private void dimensionChangedConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        ArrayList<DimensionEntryInfo> dimensionEntryInfos;
        String dimensionJson = this.getPageCache().getBigObject("assess_dimension_json_tag");
        List list = dimensionEntryInfos = StringUtils.isEmpty((CharSequence)dimensionJson) ? new ArrayList() : JsonUtils.fromJsonToList((String)dimensionJson, DimensionEntryInfo.class);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.generateTableByNewDimension(dimensionJson, dimensionEntryInfos);
        }
        this.getPageCache().remove("assess_dimension_json_tag");
    }

    private void generateTableByNewDimension(String dimensionJson, List<DimensionEntryInfo> dimensionEntryInfos) {
        this.setDimensionNameText(dimensionEntryInfos);
        ValueStorageEntity valueStorageEntity = this.getValueStorageEntity();
        valueStorageEntity.setNewDimensions(dimensionEntryInfos);
        this.getModel().setValue("targetvaluejson_tag", (Object)valueStorageEntity.toJsonString());
        this.getModel().setValue("assess_dimension_json_tag", (Object)dimensionJson);
        this.generateTable();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("targetentry".equals(entryGrid.getKey())) {
            this.showSelectedTarget();
        }
    }

    private void showSelectedTarget() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetentry");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        this.fulfillTargetForm(this.getTargetList().get(selectRow));
        this.setBillButtonVisibleByStatus();
    }

    private void setBillButtonVisibleByStatus() {
        String billStatus = (String)this.getView().getModel().getValue("billstatus");
        if ("A".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap3"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap", "baritemap1", "baritemap4"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"unsubmit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritemap1"});
        } else if ("B".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap", "baritemap4"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemap1"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap3", "baritemap1"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"unsubmit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"unaudit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritemap3"});
        } else if ("C".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap", "baritemap1", "baritemap4"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap3"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemap3"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"unaudit"});
        }
        this.getView().setEnable(Boolean.valueOf("A".equals(billStatus)), new String[]{"fieldsetpanelap1", "fieldsetpanelap2", "flexpanelap3"});
        Object id = this.getView().getModel().getValue("id");
        if (id == null || id.equals(0) || id.equals(0L)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap4"});
        }
    }

    private Date getNewTargetYear(List<DynamicObject> targetList) {
        if (targetList == null || targetList.isEmpty()) {
            return new Date();
        }
        Date currentMaxDate = targetList.stream().map(data -> data.getDate("assessyear")).sorted(Comparator.reverseOrder()).findFirst().get();
        return new DateTime((Object)currentMaxDate).plusYears(1).toDate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        switch (key) {
            case "assesscyclegrain": {
                this.assessCycleGrainChanged((String)newValue);
                break;
            }
        }
    }

    private void assessCycleGrainChanged(String newValue) {
        String cycle = newValue;
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        if ("CONSTANT".equals(cycle)) {
            splitContainer.hidePanel(SplitDirection.left, true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"assessyear"});
        } else {
            splitContainer.hidePanel(SplitDirection.left, false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"assessyear"});
        }
    }

    private void generateTable() {
        String allValues = (String)this.getModel().getValue("targetvaluejson_tag");
        String pageId = this.getView().getPageCache().get(TABLE_PAGE_ID);
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            this.getView().getView(pageId).close();
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scmdi_assessentry");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap3");
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCustomParam("dimension_list_json", this.getModel().getValue("assess_dimension_json_tag"));
        formShowParameter.setCustomParam("metricdefinitionid", this.getModel().getValue("metricdefinitionid"));
        formShowParameter.setCustomParam("allValues", (Object)allValues);
        formShowParameter.setCustomParam("period_type", this.getModel().getValue("assesscyclegrain"));
        formShowParameter.setCustomParam("metricDef", this.getModel().getValue("metricdefinitionid"));
        this.getView().showForm(formShowParameter);
        pageId = formShowParameter.getPageId();
        this.getView().getPageCache().put(TABLE_PAGE_ID, pageId);
    }

    private List<DimensionEntryInfo> getDimensionList() {
        String json = (String)this.getModel().getValue("assess_dimension_json_tag");
        return StringUtils.isEmpty((CharSequence)json) ? new ArrayList() : JsonUtils.fromJsonToList((String)json, DimensionEntryInfo.class);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                if (!this.checkMustInput()) break;
                this.saveTableValueToJsonField();
                this.validateYear(args);
                break;
            }
            case "submit": {
                if (!this.checkMustInput()) break;
                ValueStorageEntity valueStorageEntity = this.saveTableValueToJsonField();
                this.validateLegal(valueStorageEntity, args);
                break;
            }
        }
    }

    private boolean checkMustInput() {
        String dimensionName = (String)this.getModel().getValue("assessdimension");
        return !StringUtils.isBlank((CharSequence)dimensionName);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = null;
        switch (operateKey) {
            case "save": {
                operationResult = this.saveOrSubmitOperate("save");
                break;
            }
            case "submit": {
                operationResult = this.saveOrSubmitOperate("submit");
                break;
            }
            case "unsubmit": {
                operationResult = this.invokeOperation("unsubmit");
                break;
            }
            case "audit": {
                operationResult = this.invokeOperation("audit");
                break;
            }
            case "unaudit": {
                operationResult = this.invokeOperation("unaudit");
                break;
            }
            case "delete": {
                operationResult = this.invokeOperation("delete");
                this.getView().getModel().setValue("id", null);
                break;
            }
        }
        if (operationResult != null && !operationResult.isSuccess()) {
            OperationResult result = args.getOperationResult();
            result.setSuccess(false);
            result.setValidateResult(operationResult.getValidateResult());
            result.setMessage(operationResult.getMessage());
            result.setAllErrorInfo(operationResult.getAllErrorInfo());
            result.setShowMessage(operationResult.isShowMessage());
            result.setMessage(operationResult.getMessage());
            result.setBillCount(operationResult.getBillCount());
            result.setBillNos(operationResult.getBillNos());
            result.setSuccessPkIds(operationResult.getSuccessPkIds());
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap"});
        List<DynamicObject> targets = this.getTargetList();
        this.fulfillTargetEntryList(targets);
        this.reselect(targets);
        if (targets == null || targets.isEmpty()) {
            this.goalSettingPageInitSetting(targets);
        } else {
            this.goalQueryPageInitSetting(targets);
        }
        this.setBillButtonVisibleByStatus();
    }

    private void reselect(List<DynamicObject> targets) {
        EntryGrid eg = (EntryGrid)this.getControl("targetentry");
        for (int i = 0; i < targets.size(); ++i) {
            if (!targets.get(i).getPkValue().equals(this.getView().getModel().getValue("id"))) continue;
            eg.selectRows(i);
            break;
        }
    }

    private OperationResult invokeOperation(String operation) {
        Long id = (Long)this.getModel().getValue("id");
        if ((id == null || id.equals(0L)) && operation.equals("delete")) {
            return null;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operation, (String)ASSESS_TARGET, (Object[])new Object[]{id}, null);
        return operationResult;
    }

    private OperationResult saveOrSubmitOperate(String operation) {
        Long id = (Long)this.getModel().getValue("id");
        DynamicObject target = id != null && id.compareTo(0L) != 0 ? BusinessDataServiceHelper.loadSingle((Object)id, (String)ASSESS_TARGET) : BusinessDataServiceHelper.newDynamicObject((String)ASSESS_TARGET);
        target.set("assesscyclegrain", this.getModel().getValue("assesscyclegrain"));
        target.set("assessyear", this.getModel().getValue("assessyear"));
        target.set("assessdimension", this.getModel().getValue("assessdimension"));
        target.set("targetvaluejson_tag", this.getModel().getValue("targetvaluejson_tag"));
        target.set("metricdefinitionid", this.getModel().getValue("metricdefinitionid"));
        target.set("creator", this.getModel().getValue("creator"));
        target.set("createtime", this.getModel().getValue("createtime"));
        target.set("modifier", this.getModel().getValue("modifier"));
        target.set("modifytime", this.getModel().getValue("modifytime"));
        target.set("modifytime", this.getModel().getValue("modifytime"));
        target.set("assess_dimension_json_tag", this.getModel().getValue("assess_dimension_json_tag"));
        target.set("billstatus", this.getModel().getValue("billstatus"));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operation, (String)ASSESS_TARGET, (DynamicObject[])new DynamicObject[]{target}, (OperateOption)OperateOption.create());
        this.getModel().setValue("id", (Object)target.getLong("id"));
        this.getModel().setValue("billstatus", (Object)target.getString("billstatus"));
        return operationResult;
    }

    private ValueStorageEntity saveTableValueToJsonField() {
        ValueStorageEntity valueStorageEntity = this.getValueStorageEntity();
        this.getModel().setValue("targetvaluejson_tag", (Object)valueStorageEntity.toJsonString());
        return valueStorageEntity;
    }

    private ValueStorageEntity getValueStorageEntity() {
        String pageId = this.getView().getPageCache().get(TABLE_PAGE_ID);
        DynamicObject dataEntity = this.getView().getView(pageId).getModel().getDataEntity(true);
        ValueStorageEntity valueStorageEntity = new ValueStorageEntity(dataEntity, this.getDimensionList(), PeriodType.valueOf((String)((String)this.getModel().getValue("assesscyclegrain"))));
        return valueStorageEntity;
    }

    private void validateYear(BeforeDoOperationEventArgs args) {
        String assessCycleGrain = (String)this.getModel().getValue("assesscyclegrain");
        if ("CONSTANT".equals(assessCycleGrain)) {
            return;
        }
        Date assessYear = (Date)this.getModel().getValue("assessyear");
        if (assessYear == null) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u5e74\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AssessTargetFormPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            return;
        }
        String metricId = (String)this.getModel().getValue("metricdefinitionid");
        Long id = Long.valueOf(metricId);
        QFilter filter = new QFilter("metricdefinitionid", "=", (Object)id);
        long assessId = (Long)this.getModel().getValue("id");
        if (assessId != 0L) {
            filter.and("id", "<>", (Object)assessId);
        }
        Map assessTargetMap = BusinessDataServiceHelper.loadFromCache((String)ASSESS_TARGET, (QFilter[])new QFilter[]{filter});
        Collection values = assessTargetMap.values();
        for (DynamicObject value : values) {
            Date year = value.getDate("assessyear");
            if (year == null) continue;
            String yearStr = new SimpleDateFormat("yyyy").format(year);
            String assessYearStr = new SimpleDateFormat("yyyy").format(assessYear);
            if (!assessYearStr.equals(yearStr)) continue;
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6307\u6807\u5df2\u8bbe\u5b9a\u8be5\u5e74\u4efd\u76ee\u6807\uff0c\u65e0\u9700\u518d\u6b21\u8bbe\u5b9a\u3002", (String)"AssessTargetFormPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
    }

    private void validateDuplicated(ValueStorageEntity valueStorageEntity, BeforeDoOperationEventArgs args) {
        String tips = valueStorageEntity.validateDuplicated();
        if (StringUtils.isNotEmpty((CharSequence)tips)) {
            args.setCancel(true);
            args.setCancelMessage(tips);
            this.getView().showErrorNotification(tips);
        }
    }

    private void validateLegal(ValueStorageEntity valueStorageEntity, BeforeDoOperationEventArgs args) {
        this.validateYear(args);
        String dimensionLegal = valueStorageEntity.validateDimensionLegal();
        if (StringUtils.isNotEmpty((CharSequence)dimensionLegal)) {
            args.setCancel(true);
            this.getView().showErrorNotification(dimensionLegal);
            return;
        }
        String validate = valueStorageEntity.validateValueLegal();
        if (StringUtils.isNotEmpty((CharSequence)validate)) {
            args.setCancel(true);
            this.getView().showErrorNotification(validate);
            return;
        }
        this.validateDuplicated(valueStorageEntity, args);
    }
}

