/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metrics;

import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MetricDefinitionListPlugin
extends AbstractTreeListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        int size = this.getSelectRowsSize();
        switch (operateKey) {
            case "metricmapping": {
                this.checkMetricMapping(args, size);
                break;
            }
            case "goalsetting": {
                this.checkGoalSetting(args, size);
                break;
            }
            case "querygoal": {
                this.checkQueryGoal(args, size);
                break;
            }
            case "delete": {
                this.checkDelete(args);
                break;
            }
        }
    }

    private void checkMetricMapping(BeforeDoOperationEventArgs args, int size) {
        if (size > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u6307\u6807\u6620\u5c04\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MetricDefinitionListPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] entryPrimaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObject metricsDef = BusinessDataServiceHelper.loadSingle((Object)entryPrimaryKeyValues[0], (String)"scmdi_metrics_def");
        String status = metricsDef.getString("status");
        String enable = metricsDef.getString("enable");
        if (!"1".equals(enable) || !"C".equals(status)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u5fc5\u987b\u4e3a\u53ef\u7528\uff0c\u4e14\u6570\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u65f6\u624d\u80fd\u6307\u6807\u6620\u5c04\u3002", (String)"MetricDefinitionListPlugin_7", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkGoalSetting(BeforeDoOperationEventArgs args, int size) {
        if (size > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5236\u5b9a\u76ee\u6807\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MetricDefinitionListPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean newTargetPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"scmoc", (String)"scmdi_assesstarget", (String)"47156aff000000ac");
        if (!newTargetPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u76ee\u6807\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MetricDefinitionListPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkQueryGoal(BeforeDoOperationEventArgs args, int size) {
        if (size > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u76ee\u6807\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MetricDefinitionListPlugin_3", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean newTargetPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"scmoc", (String)"scmdi_assesstarget", (String)"47150e89000000ac");
        if (!newTargetPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u76ee\u6807\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MetricDefinitionListPlugin_4", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        Object id = billList.getFocusRowPkId();
        QFilter qFilter = new QFilter("metricdefinitionid", "=", id);
        boolean exists = QueryServiceHelper.exists((String)"scmdi_assesstarget", (QFilter[])new QFilter[]{qFilter});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76ee\u6807\u503c\u3002", (String)"MetricDefinitionListPlugin_6", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkDelete(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] entryPrimaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("metricdefinitionid", "in", (Object)entryPrimaryKeyValues);
        boolean exists = QueryServiceHelper.exists((String)"scmdi_assesstarget", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5b58\u5728\u8003\u6838\u76ee\u6807\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"MetricDefinitionListPlugin_5", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
        QFilter qFilter1 = new QFilter("metricdefid", "in", (Object)entryPrimaryKeyValues);
        boolean exists1 = QueryServiceHelper.exists((String)"scmdi_metrics_mapping", (QFilter[])new QFilter[]{qFilter1});
        if (exists1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5b58\u5728\u6307\u6807\u6620\u5c04\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"MetricDefinitionListPlugin_8", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private int getSelectRowsSize() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows.size();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("metricmapping".equals(operateKey)) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("scmdi_metrics_mapping");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            BillList billList = (BillList)this.getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            DynamicObject metricMapping = QueryServiceHelper.queryOne((String)"scmdi_metrics_mapping", (String)"id", (QFilter[])new QFilter[]{new QFilter("metricdefid", "=", focusRowPkId)});
            if (metricMapping != null) {
                long mappingId = metricMapping.getLong("id");
                baseShowParameter.setPkId((Object)mappingId);
                baseShowParameter.setStatus(OperationStatus.VIEW);
            } else {
                baseShowParameter.setCustomParam("metricId", focusRowPkId);
            }
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else if ("goalsetting".equals(operateKey) || "querygoal".equals(operateKey)) {
            this.openAssessTargetForm(operateKey);
        }
    }

    private void openAssessTargetForm(String key) {
        BillList billList = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billList.getFocusRowPkId();
        DynamicObject metric = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"scmdi_metrics_def");
        String status = metric.getString("status");
        String metricMappingStatus = metric.getString("metricmappingstatus");
        String enable = metric.getString("enable");
        if (!("C".equals(status) && "B".equals(metricMappingStatus) && "1".equals(enable))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u5fc5\u987b\u4e3a\u53ef\u7528\uff0c\u4e14\u5df2\u505a\u6307\u6807\u6620\u5c04\u540e\u624d\u80fd\u5236\u5b9a\u76ee\u6807\u3002", (String)"MetricDefinitionFormPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            return;
        }
        Long id = metric.getLong("id");
        String number = metric.getString("number");
        ILocaleString name = metric.getLocaleString("name");
        ILocaleString metricDefinition = metric.getLocaleString("metricdefinition");
        DynamicObject group = metric.getDynamicObject("group");
        String statRate = metric.getString("statrate");
        Long groupId = null;
        if (group != null) {
            groupId = (Long)group.getPkValue();
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scmdi_assesstargetlist");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("metricId", id);
        customParams.put("metricNumber", number);
        customParams.put("metricName", name.getLocaleValue());
        customParams.put("metricGroup", groupId);
        customParams.put("statrate", statRate);
        customParams.put("metricDefinition", metricDefinition.getLocaleValue());
        customParams.put("type", key);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }
}

