/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.metrics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.common.enumeration.PeriodType;
import kd.scmc.scmdi.common.pojo.DimensionEntryInfo;
import kd.scmc.scmdi.common.pojo.ValueRow;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.excel.JsonUtils;

public class ValueStorageEntity {
    private List<DimensionEntryInfo> dimensionList;
    private List<ValueRow> rows;

    public ValueStorageEntity() {
    }

    public void setNewDimensions(List<DimensionEntryInfo> newDimensionList) {
        List<DimensionEntryInfo> orientList = this.dimensionList;
        this.dimensionList = newDimensionList;
        orientList.removeAll(newDimensionList);
        this.purgeValues(orientList);
    }

    private void purgeValues(List<DimensionEntryInfo> removedDimensionList) {
        Set removedDimensionKeys = removedDimensionList.stream().map(DimensionEntryInfo::getDimensionWithPrefix).collect(Collectors.toSet());
        if (!CommonUtils.isNullOrEmpty(removedDimensionKeys)) {
            for (String removedDimensionKey : removedDimensionKeys) {
                this.getRows().stream().forEach(valueRow -> valueRow.getSelectedBaseData().remove(removedDimensionKey));
            }
        }
        this.getRows().removeIf(row -> {
            Map selectedBaseDataMap = row.getSelectedBaseData();
            Map valueMap = row.getValues();
            return !(valueMap != null && !valueMap.isEmpty() && !valueMap.values().stream().allMatch(v -> v == null || v.doubleValue() == 0.0) || selectedBaseDataMap != null && !selectedBaseDataMap.isEmpty() && !selectedBaseDataMap.values().stream().allMatch(v -> v == null));
        });
    }

    @JsonIgnore
    public Set<DimensionEntryInfo> getFulfilledDimensions() {
        HashSet<DimensionEntryInfo> fulfilledDimensions = new HashSet<DimensionEntryInfo>();
        List<ValueRow> rows = this.getRows();
        for (ValueRow row : rows) {
            Map selectedBaseData = row.getSelectedBaseData();
            for (Map.Entry entry : selectedBaseData.entrySet()) {
                if (entry.getValue() == null) continue;
                fulfilledDimensions.add(this.dimensionList.stream().filter(d -> d.getDimensionWithPrefix().equals(entry.getKey())).findAny().get());
            }
        }
        return fulfilledDimensions;
    }

    public ValueStorageEntity(DynamicObject dataEntity, List<DimensionEntryInfo> dimensionList, PeriodType periodType) {
        DynamicObjectCollection rowList = dataEntity.getDynamicObjectCollection("entryentity");
        this.dimensionList = dimensionList;
        List rows = rowList.stream().map(entryRow -> {
            ValueRow valueRow = new ValueRow();
            HashMap selectedBaseDataMap = new HashMap();
            dimensionList.forEach(dimension -> {
                String dimensionIdentity;
                DynamicObject selectedBaseData = entryRow.getDynamicObject(dimensionIdentity = dimension.getDimensionWithPrefix());
                selectedBaseDataMap.put(dimensionIdentity, selectedBaseData == null ? null : selectedBaseData.getPkValue());
            });
            valueRow.setSelectedBaseData(selectedBaseDataMap);
            HashMap values = new HashMap();
            periodType.getPeriods().forEach((key, value1) -> {
                BigDecimal value = entryRow.getBigDecimal(key);
                values.put(key, value);
            });
            valueRow.setValues(values);
            return valueRow;
        }).collect(Collectors.toList());
        this.rows = rows;
    }

    public List<ValueRow> getRows() {
        return this.rows;
    }

    public void setRows(List<ValueRow> rows) {
        this.rows = rows;
    }

    public String toJsonString() {
        return JsonUtils.writeValueAsString((Object)this);
    }

    public static ValueStorageEntity fromJsonString(String json) {
        return (ValueStorageEntity)JsonUtils.readValue((String)json, ValueStorageEntity.class);
    }

    public String validateDimensionLegal() {
        LinkedHashMap allErrorRows = new LinkedHashMap(16);
        AtomicInteger rowIndex = new AtomicInteger();
        this.getRows().forEach(row -> {
            Map selectedBaseData = row.getSelectedBaseData();
            ArrayList<String> emptyDimensionNames = new ArrayList<String>();
            for (Map.Entry entry : selectedBaseData.entrySet()) {
                if (entry.getValue() != null) continue;
                DimensionEntryInfo dimensionEntryInfo = this.dimensionList.stream().filter(dim -> dim.getDimensionWithPrefix().equals(entry.getKey())).findAny().orElse(null);
                emptyDimensionNames.add(dimensionEntryInfo.getDimensionName());
            }
            if (!emptyDimensionNames.isEmpty()) {
                allErrorRows.put(rowIndex.get(), emptyDimensionNames);
            }
            rowIndex.getAndIncrement();
        });
        if (allErrorRows.isEmpty()) {
            return null;
        }
        String tips = allErrorRows.entrySet().stream().map(mapListEntry -> {
            List key = (List)mapListEntry.getValue();
            Integer value = (Integer)mapListEntry.getKey();
            String dimNames = String.join((CharSequence)",", key);
            return String.format(ResManager.loadKDString((String)"\u6240\u6709\u7ef4\u5ea6\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u586b\u5199\u76ee\u6807\u660e\u7ec6\u7b2c%d\u884c\uff1a\u201c%s\u201d\u3002", (String)"ValueStorageEntity_2", (String)"scmc-scmdi-form", (Object[])new Object[0]), value + 1, dimNames);
        }).collect(Collectors.joining("\n"));
        return tips;
    }

    public String validateValueLegal() {
        ArrayList list = new ArrayList();
        AtomicInteger rowIndex = new AtomicInteger();
        this.getRows().forEach(row -> {
            Map selectedValues = row.getValues();
            boolean flag = true;
            for (BigDecimal value : selectedValues.values()) {
                if (value == null || value.compareTo(BigDecimal.ZERO) == 0) continue;
                flag = false;
                break;
            }
            if (flag) {
                list.add(rowIndex.get());
            }
            rowIndex.getAndIncrement();
        });
        if (list.isEmpty()) {
            return null;
        }
        String line = list.stream().map(i -> i + 1 + "").collect(Collectors.joining(","));
        return String.format(ResManager.loadKDString((String)"\u6bcf\u884c\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u76ee\u6807\u503c\uff0c\u8bf7\u586b\u5199\u76ee\u6807\u660e\u7ec6\u7b2c %s \u884c\u7684\u76ee\u6807\u503c\u3002", (String)"ValueStorageEntity_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), line);
    }

    public String validateDuplicated() {
        Set<Integer> duplicated = this.findDuplicated(this.getRows());
        if (duplicated.isEmpty()) {
            return null;
        }
        String line = duplicated.stream().map(e -> e + 1).map(String::valueOf).map(s -> String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"ValueStorageEntity_validateDuplicated_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), s)).collect(Collectors.joining(ResManager.loadKDString((String)"\u3001", (String)"ValueStorageEntity_validateDuplicated_1", (String)"scmc-scmdi-form", (Object[])new Object[0])));
        String tips = String.format(ResManager.loadKDString((String)"%1$s\u7684\u8003\u6838\u7ef4\u5ea6\u7ec4\u5408\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e\u3002", (String)"ValueStorageEntity_validateDuplicated_2", (String)"scmc-scmdi-form", (Object[])new Object[0]), line);
        return tips;
    }

    private Set<Integer> findDuplicated(List<ValueRow> rowList) {
        HashMap<Map, List<Integer>> counts = new HashMap<Map, List<Integer>>(16);
        HashSet<Integer> duplicateIndex = new HashSet<Integer>();
        for (int i = 0; i < rowList.size(); ++i) {
            ValueRow valueRow = rowList.get(i);
            Map selectedBaseData = valueRow.getSelectedBaseData();
            if (counts.containsKey(selectedBaseData)) {
                duplicateIndex.add(i);
                duplicateIndex.addAll((Collection)counts.get(selectedBaseData));
                continue;
            }
            counts.put(selectedBaseData, Collections.singletonList(i));
        }
        return duplicateIndex;
    }

    public void setData(DynamicObject dataEntity) {
        DynamicObjectCollection dynamicDataRows = dataEntity.getDynamicObjectCollection("entryentity");
        if (this.rows == null || this.rows.isEmpty()) {
            DynamicObject newRow = new DynamicObject(dynamicDataRows.getDynamicObjectType());
            dynamicDataRows.add((Object)newRow);
            return;
        }
        for (ValueRow valueRow : this.rows) {
            Map selectedBaseData = valueRow.getSelectedBaseData();
            DynamicObject newRow = new DynamicObject(dynamicDataRows.getDynamicObjectType());
            selectedBaseData.forEach((key, selectedPkValue) -> {
                if (selectedPkValue != null) {
                    DimensionEntryInfo dimensionEntryInfo = this.dimensionList.stream().filter(dim -> dim.getDimensionWithPrefix().equals(key)).findAny().orElse(null);
                    DynamicObject selectedBd = BusinessDataServiceHelper.loadSingle((Object)selectedPkValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)dimensionEntryInfo.getMetaDataNumber()));
                    newRow.set(key, (Object)selectedBd);
                }
            });
            Map values = valueRow.getValues();
            values.forEach((arg_0, arg_1) -> ((DynamicObject)newRow).set(arg_0, arg_1));
            dynamicDataRows.add((Object)newRow);
        }
    }

    public List<DimensionEntryInfo> getDimensionList() {
        return this.dimensionList;
    }
}

