/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.util.OpenPageUtils;
import kd.scmc.scmdi.common.pojo.ItoCardInfo;
import kd.scmc.scmdi.form.plugin.form.operatecenter.ItoQueryPlugin;

public class InvTurnOverChartCardPlugin
extends AbstractFormPlugin {
    private static final String INV_HOME_ID = "1891962676314462208";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildChart();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "flexpanelap": {
                AppInfo scmoc = AppMetadataCache.getAppInfoByNumber((String)"scmoc");
                OpenPageUtils.openMenu((IFormView)this.getView(), (String)INV_HOME_ID, (String)scmoc.getId());
                break;
            }
        }
    }

    private void buildChart() {
        CustomChart chart = (CustomChart)this.getControl("customchartap");
        chart.clearData();
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "0px");
        this.buildChartData(chart);
        chart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        chart.addTooltip("axisPointer", axisPointType);
        chart.setShowTooltip(true);
    }

    private void buildChartData(CustomChart chart) {
        Map lineChartData;
        ItoCardInfo invChartData = ItoQueryPlugin.getInvChartData();
        Map barChartData = invChartData.getBarChartData();
        this.buildAxis(chart, invChartData.getPeriodAxis());
        if (barChartData != null) {
            this.buildItoHistogram(chart, (BigDecimal[])barChartData.get("ito"));
            this.buildYoyItoHistogram(chart, (BigDecimal[])barChartData.get("yoyito"));
        }
        if ((lineChartData = invChartData.getLineChartData()) != null) {
            this.buildTurnOverDayLine(chart, (BigDecimal[])lineChartData.get("turnday"));
            this.buildYoyTurnOverDayLine(chart, (BigDecimal[])lineChartData.get("yoyturnday"));
        }
    }

    private void buildAxis(CustomChart chart, List<String> itoDataInfos) {
        if (itoDataInfos == null) {
            return;
        }
        String[] category = itoDataInfos.toArray(new String[0]);
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys(category);
    }

    private void buildItoHistogram(CustomChart chart, BigDecimal[] itoDataInfos) {
        if (itoDataInfos == null) {
            return;
        }
        chart.createYAxis("", AxisType.value);
        BarSeries barSeries = chart.createBarSeries("\u5468\u8f6c\u7387");
        barSeries.setBarWidth("8px");
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
        barSeries.setData((Number[])itoDataInfos);
    }

    private void buildYoyItoHistogram(CustomChart chart, BigDecimal[] itoDataInfos) {
        if (itoDataInfos == null) {
            return;
        }
        BarSeries barSeries = chart.createBarSeries("\u540c\u671f\u5468\u8f6c\u7387");
        barSeries.setBarWidth("8px");
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
        barSeries.setData((Number[])itoDataInfos);
    }

    private void buildTurnOverDayLine(CustomChart chart, BigDecimal[] itoDataInfos) {
        if (itoDataInfos == null) {
            return;
        }
        chart.createYAxis("", AxisType.value);
        LineSeries lineSeries = chart.createLineSeries("\u5468\u8f6c\u5929\u6570");
        lineSeries.setYAxisIndex(1);
        lineSeries.setData((Number[])itoDataInfos);
    }

    private void buildYoyTurnOverDayLine(CustomChart chart, BigDecimal[] itoDataInfos) {
        if (itoDataInfos == null) {
            return;
        }
        LineSeries lineSeries = chart.createLineSeries("\u540c\u671f\u5468\u8f6c\u5929\u6570");
        lineSeries.setYAxisIndex(1);
        lineSeries.setData((Number[])itoDataInfos);
    }
}

