/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.scmdi.common.pojo.DataCardInfo;
import kd.scmc.scmdi.common.pojo.ItoCardInfo;
import kd.scmc.scmdi.common.pojo.SingleDataCardInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;

public class ItoQueryPlugin {
    public static DataCardInfo getInvDigitalData() {
        Set<Long> costAccountIds = ItoQueryPlugin.getCostAccountIds();
        if (costAccountIds.isEmpty()) {
            return new DataCardInfo();
        }
        long periodTypeId = ItoQueryPlugin.getPeriodTypeId(costAccountIds);
        Date monthAgoByDate = HomePageDateUtils.getMonthAgoByDate();
        DynamicObject endPeriod = ItoQueryPlugin.getPeriodByDate(monthAgoByDate, null, periodTypeId);
        DynamicObject startPeriod = ItoQueryPlugin.getSixMonthAgoPeriod(endPeriod);
        DataSet itoData = ItoQueryPlugin.queryItoData(costAccountIds, periodTypeId, true, startPeriod, endPeriod);
        Map<String, DynamicObject> yoyPeriod = ItoQueryPlugin.getYOYPeriod(startPeriod, endPeriod);
        DataSet yoyItoData = ItoQueryPlugin.queryItoData(costAccountIds, periodTypeId, true, yoyPeriod.get("startPeriod"), yoyPeriod.get("endPeriod"));
        Map<String, DynamicObject> qoqPeriod = ItoQueryPlugin.getQOQPeriod(startPeriod, endPeriod);
        DataSet qoqItoData = ItoQueryPlugin.queryItoData(costAccountIds, periodTypeId, true, qoqPeriod.get("startPeriod"), qoqPeriod.get("endPeriod"));
        SingleDataCardInfo nowDataInfo = ItoQueryPlugin.getSingleDataInfo(itoData);
        SingleDataCardInfo yoyDataInfo = ItoQueryPlugin.getSingleDataInfo(yoyItoData);
        SingleDataCardInfo qoqDataInfo = ItoQueryPlugin.getSingleDataInfo(qoqItoData);
        DataCardInfo dataCardInfo = new DataCardInfo();
        BigDecimal ito = nowDataInfo.getFirstData();
        BigDecimal saleAmount = nowDataInfo.getSecondData();
        BigDecimal invAmount = nowDataInfo.getThirdData();
        if (ito != null && saleAmount != null && invAmount != null) {
            BigDecimal yoyIto = ItoQueryPlugin.getRate(ito, yoyDataInfo.getFirstData());
            BigDecimal yoySaleAmount = ItoQueryPlugin.getRate(saleAmount, yoyDataInfo.getSecondData());
            BigDecimal yoyInvAmount = ItoQueryPlugin.getRate(invAmount, yoyDataInfo.getThirdData());
            dataCardInfo.setFirstDataYoy(yoyIto);
            dataCardInfo.setSecondDataYoy(yoySaleAmount);
            dataCardInfo.setThirdDataYoy(yoyInvAmount);
            BigDecimal qoqIto = ItoQueryPlugin.getRate(ito, qoqDataInfo.getFirstData());
            BigDecimal qoqSaleAmount = ItoQueryPlugin.getRate(saleAmount, qoqDataInfo.getSecondData());
            BigDecimal qoqInvAmount = ItoQueryPlugin.getRate(invAmount, qoqDataInfo.getThirdData());
            dataCardInfo.setFirstDataQoq(qoqIto);
            dataCardInfo.setSecondDataQoq(qoqSaleAmount);
            dataCardInfo.setThirdDataQoq(qoqInvAmount);
            dataCardInfo.setFirstData(ito);
            dataCardInfo.setSecondData(saleAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
            dataCardInfo.setThirdData(invAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
        }
        return dataCardInfo;
    }

    private static BigDecimal getRate(BigDecimal currentData, BigDecimal lastData) {
        if (lastData == null || lastData.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal rate = currentData.subtract(lastData).divide(lastData, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        return rate;
    }

    private static SingleDataCardInfo getSingleDataInfo(DataSet itoData) {
        SingleDataCardInfo singleDataCardInfo = new SingleDataCardInfo();
        if (itoData != null && itoData.hasNext()) {
            Row next = itoData.next();
            singleDataCardInfo.setThirdData(next.getBigDecimal("avgstock"));
            singleDataCardInfo.setSecondData(next.getBigDecimal("salecost"));
            singleDataCardInfo.setFirstData(next.getBigDecimal("turnrate"));
        }
        return singleDataCardInfo;
    }

    public static ItoCardInfo getInvChartData() {
        Row next;
        Set<Long> costAccountIds = ItoQueryPlugin.getCostAccountIds();
        if (costAccountIds.isEmpty()) {
            return new ItoCardInfo();
        }
        long periodTypeId = ItoQueryPlugin.getPeriodTypeId(costAccountIds);
        Date monthAgoByDate = HomePageDateUtils.getMonthAgoByDate();
        DynamicObject endPeriod = ItoQueryPlugin.getPeriodByDate(monthAgoByDate, null, periodTypeId);
        DynamicObject startPeriod = ItoQueryPlugin.getSixMonthAgoPeriod(endPeriod);
        DataSet itoData = ItoQueryPlugin.queryItoData(costAccountIds, periodTypeId, false, startPeriod, endPeriod);
        Map<String, DynamicObject> yoyPeriod = ItoQueryPlugin.getYOYPeriod(startPeriod, endPeriod);
        DataSet yoyItoData = ItoQueryPlugin.queryItoData(costAccountIds, periodTypeId, true, yoyPeriod.get("startPeriod"), yoyPeriod.get("endPeriod"));
        ArrayList<String> periodAxis = new ArrayList<String>(6);
        ArrayList<BigDecimal> itoChartData = new ArrayList<BigDecimal>(6);
        ArrayList<BigDecimal> yoyItoChartData = new ArrayList<BigDecimal>(6);
        ArrayList<BigDecimal> turnDayChartData = new ArrayList<BigDecimal>(6);
        ArrayList<BigDecimal> yoyTurnDayChartData = new ArrayList<BigDecimal>(6);
        LinkedHashMap<String, BigDecimal[]> barChartData = new LinkedHashMap<String, BigDecimal[]>(6);
        LinkedHashMap<String, BigDecimal[]> lineChartData = new LinkedHashMap<String, BigDecimal[]>(6);
        if (itoData != null && itoData.hasNext()) {
            next = itoData.next();
            periodAxis.add(next.getString("periodnumber"));
            itoChartData.add(next.getBigDecimal("turnrate"));
            turnDayChartData.add(next.getBigDecimal("turndays"));
        }
        if (yoyItoData != null && yoyItoData.hasNext()) {
            next = yoyItoData.next();
            periodAxis.add(next.getString("periodnumber"));
            yoyItoChartData.add(next.getBigDecimal("turnrate"));
            yoyTurnDayChartData.add(next.getBigDecimal("turndays"));
        }
        barChartData.put("ito", itoChartData.toArray(new BigDecimal[0]));
        barChartData.put("yoyito", yoyItoChartData.toArray(new BigDecimal[0]));
        lineChartData.put("turnday", turnDayChartData.toArray(new BigDecimal[0]));
        lineChartData.put("yoyturnday", yoyTurnDayChartData.toArray(new BigDecimal[0]));
        ItoCardInfo itoCardInfo = new ItoCardInfo();
        itoCardInfo.setPeriodAxis(periodAxis);
        itoCardInfo.setBarChartData(barChartData);
        itoCardInfo.setLineChartData(lineChartData);
        return itoCardInfo;
    }

    private static Set<Long> getCostAccountIds() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)true);
        if (userHasPermOrgs.getHasPermOrgs().isEmpty()) {
            return Collections.emptySet();
        }
        List invOrgs = OrgUnitServiceHelper.filterOrgDuty((List)userHasPermOrgs.getHasPermOrgs(), (String)"05");
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgIds(invOrgs);
        param.setFromViewType("10");
        param.setToViewType("05");
        param.setDirectViewType("fromorg");
        List allFromInvToCalOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        Set<Long> costAccountIdsByCalOrg = ItoQueryPlugin.getCostAccountIdsByCalOrg(allFromInvToCalOrgIds);
        return costAccountIdsByCalOrg;
    }

    private static long getPeriodTypeId(Set<Long> costAccountIds) {
        Iterator<Long> iterator = costAccountIds.iterator();
        Long next = iterator.next();
        DynamicObject sysCtrlEntity = ItoQueryPlugin.getSysCtrlEntity(next);
        Long startPeriodId = null;
        if (sysCtrlEntity != null) {
            startPeriodId = sysCtrlEntity.getLong("startperiod.id");
        }
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache(startPeriodId, (String)"bd_period");
        long periodTypeId = (Long)period.getDynamicObject("periodtype").getPkValue();
        return periodTypeId;
    }

    private static DynamicObjectCollection getPeriodColl(long periodTypeId, DynamicObject startPeriod, DynamicObject endPeriod) {
        QFilter q = new QFilter("periodtype", "=", (Object)periodTypeId);
        q.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        q.and("id", ">=", (Object)startPeriod.getLong("id"));
        q.and("id", "<=", (Object)endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        return coll;
    }

    public static DataSet queryItoData(Set<Long> costAccountIds, long periodTypeId, boolean isGroupByPeriod, DynamicObject startPeriod, DynamicObject endPeriod) {
        DynamicObjectCollection periodColl = ItoQueryPlugin.getPeriodColl(periodTypeId, startPeriod, endPeriod);
        int turnOverDays = 30;
        if (isGroupByPeriod) {
            turnOverDays = periodColl.size() * 30;
        }
        HashMap<Integer, Long> periodIdMap = new HashMap<Integer, Long>(6);
        ArrayList<Integer> periodNumberList = new ArrayList<Integer>(6);
        for (DynamicObject info : periodColl) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            Long periodId = info.getLong("id");
            periodIdMap.put(periodNumber, periodId);
            periodNumberList.add(periodNumber);
        }
        DataSet itoData = ItoQueryPlugin.getItoData(periodNumberList, periodIdMap, costAccountIds, isGroupByPeriod, turnOverDays);
        return itoData;
    }

    private static DataSet getItoData(List<Integer> periodNumberList, Map<Integer, Long> periodIdMap, Set<Long> costAccountId, boolean isGroupByPeriod, int turnOverDays) {
        DataSet dataSet = null;
        DataSet costRecordDataSet = null;
        DataSet costAdjustDataSet = null;
        DataSet recordAdjustDataSet = null;
        for (int periodNumber : periodNumberList) {
            dataSet = dataSet == null ? ItoQueryPlugin.getDataSet(periodNumber, costAccountId) : dataSet.union(ItoQueryPlugin.getDataSet(periodNumber, costAccountId));
            costRecordDataSet = costRecordDataSet == null ? ItoQueryPlugin.getCostRecordDataSet(periodNumber, periodIdMap, costAccountId) : costRecordDataSet.union(ItoQueryPlugin.getCostRecordDataSet(periodNumber, periodIdMap, costAccountId));
            if (costAdjustDataSet == null) {
                costAdjustDataSet = ItoQueryPlugin.getCostAdjustDataSet(periodNumber, periodIdMap, costAccountId);
                continue;
            }
            costAdjustDataSet = costAdjustDataSet.union(ItoQueryPlugin.getCostAdjustDataSet(periodNumber, periodIdMap, costAccountId));
        }
        if (dataSet == null || dataSet.copy().isEmpty()) {
            return dataSet;
        }
        recordAdjustDataSet = ItoQueryPlugin.unionRecordAdjust(costRecordDataSet, costAdjustDataSet);
        dataSet = ItoQueryPlugin.joinBalDataSet(dataSet, recordAdjustDataSet);
        dataSet = ItoQueryPlugin.groupDataSet(dataSet);
        dataSet = ItoQueryPlugin.groupDataSetByPeriod(dataSet, isGroupByPeriod);
        dataSet = ItoQueryPlugin.calculateDataSet(dataSet, turnOverDays);
        return dataSet;
    }

    private static DataSet calculateDataSet(DataSet dataSet, int turnOverDays) {
        String selectFields = ItoQueryPlugin.getGroupCols(true).replace(",isstandard", "");
        dataSet = dataSet.select((selectFields + ",periodbeginamount,periodendamount,(periodbeginamount +  periodendamount) / 2 as avgstock,actualcost as salecost").split(","));
        dataSet = dataSet.select((selectFields + ",periodbeginamount,periodendamount,avgstock,salecost,case when avgstock != 0 then salecost / avgstock else 0 end as turnrate").split(","));
        List<Object[]> dataList = ItoQueryPlugin.getDataList(dataSet);
        dataSet = Algo.create((String)"scmc.scmoc").createDataSet(dataList.iterator(), dataSet.getRowMeta());
        return dataSet.select((selectFields + ",periodbeginamount,periodendamount,avgstock,salecost,turnrate,case when turnrate != 0 then " + turnOverDays + ".0 / turnrate else 0 end as turndays").split(",")).orderBy(new String[]{"periodnumber"});
    }

    private static List<Object[]> getDataList(DataSet dataSet) {
        int fieldLength = dataSet.getRowMeta().getFields().length;
        DataSet dataSetCopy = dataSet.copy();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (Row row : dataSetCopy) {
            Object[] RowData = new Object[fieldLength];
            for (int i = 0; i < fieldLength; ++i) {
                RowData[i] = row.get(i);
            }
            BigDecimal turnRate = row.getBigDecimal("turnrate");
            if (turnRate != null) {
                turnRate = turnRate.setScale(4, RoundingMode.HALF_UP);
            }
            RowData[ItoQueryPlugin.getListFieldIndex((String)"turnrate", (DataSet)dataSet)] = turnRate;
            dataList.add(RowData);
        }
        return dataList;
    }

    private static int getListFieldIndex(String field, DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private static DataSet groupDataSetByPeriod(DataSet dataSet, boolean isGroupByPeriod) {
        if (isGroupByPeriod) {
            DataSet dataSet1 = dataSet.groupBy(ItoQueryPlugin.getGroupCols(false).replace(",isstandard", "").split(",")).sum("periodbeginamount").sum("periodendamount").sum("actualcost").finish();
            dataSet1 = dataSet1.addField("0", "periodnumber").addField("0", "year").addField("0", "month");
            return dataSet1.select((ItoQueryPlugin.getGroupCols(true).replace(",isstandard", "") + ",periodbeginamount,periodendamount,actualcost").split(","));
        }
        return dataSet;
    }

    private static DataSet groupDataSet(DataSet dataSet) {
        dataSet = dataSet.groupBy(ItoQueryPlugin.getGroupCols(true).replace(",isstandard", "").split(",")).sum("periodbeginamount").sum("periodendamount").sum("actualcost").finish();
        return dataSet.select((ItoQueryPlugin.getGroupCols(true).replace(",isstandard", "") + ",periodbeginamount,periodendamount,actualcost").split(","));
    }

    private static String getGroupCols(boolean havePeriodCol) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        if (havePeriodCol) {
            sql.append(",year,month,periodnumber");
        }
        sql.append(",baseunit,currency,isstandard");
        return sql.toString();
    }

    private static DataSet joinBalDataSet(DataSet dataSet, DataSet recordAdjustDataSet) {
        return dataSet.leftJoin(recordAdjustDataSet).on("costaccountid", "costaccountid").on("calorgid", "calorgid").on("year", "year").on("month", "month").on("periodnumber", "periodnumber").on("baseunit", "baseunit").on("currency", "currency").on("isstandard", "isstandard").select(dataSet.getRowMeta().getFieldNames(), new String[]{"actualcost"}).finish();
    }

    private static DataSet unionRecordAdjust(DataSet costRecordDataSet, DataSet costAdjustDataSet) {
        return costRecordDataSet.union(costAdjustDataSet).groupBy(ItoQueryPlugin.getGroupCols().split(",")).sum("actualcost").finish();
    }

    private static DataSet getCostAdjustDataSet(int periodNumber, Map<Integer, Long> periodIdMap, Set<Long> costAccount) {
        QFilter q = new QFilter("costaccount", "in", costAccount);
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        q.and("period", "=", (Object)periodIdMap.get(periodNumber));
        q.and("billstatus", "=", (Object)"C");
        QFilter actualQ = new QFilter("entryentity.accounttype", "!=", (Object)"D");
        QFilter standardQ1 = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standardQ1.and("createtype", "!=", (Object)"M");
        QFilter standardQ2 = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standardQ2.and("createtype", "=", (Object)"M");
        standardQ2.and("billsrctype", "=", (Object)"D");
        q.and(actualQ.or(standardQ1).or(standardQ2));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_costadjustbill", (String)ItoQueryPlugin.getCostAdjustSelectFields(periodNumber), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(ItoQueryPlugin.getGroupCols().split(",")).sum("actualcost").finish();
        return dataSet;
    }

    private static String getCostAdjustSelectFields(int periodNumber) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,entryentity.baseunit.id as baseunit,currency.id as currency,entryentity.adjustamt as actualcost,case when entryentity.accounttype = 'D' then 1 else 0 end as isstandard";
        return select;
    }

    private static DataSet getCostRecordDataSet(int periodNumber, Map<Integer, Long> periodIdMap, Set<Long> costAccount) {
        Long periodId = periodIdMap.get(periodNumber);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)entityType);
        QFilter q = new QFilter("costaccount", "in", costAccount);
        q.and("issplitcreate", "=", (Object)"0");
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        q.and("period", "=", (Object)periodId);
        q.and("bookdate", "<=", (Object)period.getDate("enddate"));
        q.and("bookdate", ">=", (Object)period.getDate("begindate"));
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatus);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_costrecord", (String)ItoQueryPlugin.getCostRecordSelectFields(periodNumber), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(ItoQueryPlugin.getGroupCols().split(",")).sum("actualcost").finish();
        return dataSet;
    }

    private static String getCostRecordSelectFields(int periodNumber) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,entry.baseunit.id as baseunit,localcurrency.id as currency,case when entry.accounttype = 'D' then entry.standardcost else entry.actualcost end as actualcost,case when entry.accounttype = 'D' then 1 else 0 end as isstandard";
        return select;
    }

    private static DataSet getDataSet(int periodNumber, Set<Long> costAccountId) {
        DataSet unionDataSet;
        QFilter q = new QFilter("costaccount", "in", costAccountId);
        QFilter beginQ = ItoQueryPlugin.getBeginFilter(periodNumber);
        QFilter endQ = ItoQueryPlugin.getEndFilter(periodNumber);
        boolean isNewBalance = ItoQueryPlugin.isNewBalance();
        if (isNewBalance) {
            DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_bal", (String)ItoQueryPlugin.getNewBalSelectFields(periodNumber, "0"), (QFilter[])new QFilter[]{q, beginQ}, null);
            String groupByField = "costaccountid,calorgid,periodnumber,year,month,baseunit,currency,isstandard";
            beginDataSet = beginDataSet.groupBy(groupByField.split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodbeginamount").sum("periodendamount").sum("periodendstandardcost").sum("periodendcostdiff").finish();
            DataSet endDataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_bal", (String)ItoQueryPlugin.getNewBalSelectFields(periodNumber, "1"), (QFilter[])new QFilter[]{q, endQ}, null);
            endDataSet = endDataSet.groupBy(groupByField.split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodbeginamount").sum("periodendamount").sum("periodendstandardcost").sum("periodendcostdiff").finish();
            unionDataSet = beginDataSet.union(endDataSet);
        } else {
            DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_balance", (String)ItoQueryPlugin.getBalSelectFields(periodNumber, "0"), (QFilter[])new QFilter[]{q, beginQ}, null);
            DataSet endDataSet = QueryServiceHelper.queryDataSet((String)"scmoc.homepage", (String)"cal_balance", (String)ItoQueryPlugin.getBalSelectFields(periodNumber, "1"), (QFilter[])new QFilter[]{q, endQ}, null);
            unionDataSet = beginDataSet.union(endDataSet);
        }
        unionDataSet = unionDataSet.groupBy(ItoQueryPlugin.getGroupCols().split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodbeginamount").sum("periodendamount").finish();
        unionDataSet = unionDataSet.select(ItoQueryPlugin.getGroupCols() + ",case when isstandard = 1 then beginstandardcost + periodbegincostdiff else periodbeginamount end as periodbeginamount,case when isstandard = 1 then periodendstandardcost + periodendcostdiff else periodendamount end as periodendamount");
        return unionDataSet;
    }

    private static String getGroupCols() {
        String sql = "costaccountid,calorgid,year,month,periodnumber,baseunit,currency,isstandard";
        return sql;
    }

    private static String getBalSelectFields(int periodNumber, String selectType) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,baseunit,calpolicy.currency.id as currency,case when accounttype = 'D' then 1 else 0 end as isstandard";
        if ("0".equals(selectType)) {
            select = select + ",periodendstandardcost as beginstandardcost,periodendcostdiff as periodbegincostdiff,periodendactualcost as periodbeginamount,0.0 as periodendamount,0.0 as periodendstandardcost,0.0 as periodendcostdiff";
        } else if ("1".equals(selectType)) {
            select = select + ",0.0 as beginstandardcost,0.0 as periodbegincostdiff,0.0 as periodbeginamount,periodendactualcost as periodendamount,periodendstandardcost as periodendstandardcost,periodendcostdiff as periodendcostdiff";
        }
        return select;
    }

    private static String getNewBalSelectFields(int periodNumber, String selectType) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,baseunit,calpolicy.currency.id as currency,case when accounttype = 'D' then 1 else 0 end as isstandard";
        if ("0".equals(selectType)) {
            select = select + ",standardcost_bal as beginstandardcost,costdiff_bal as periodbegincostdiff,actualcost_bal as periodbeginamount,0.0 as periodendamount,0.0 as periodendstandardcost,0.0 as periodendcostdiff";
        } else if ("1".equals(selectType)) {
            select = select + ",0.0 as beginstandardcost,0.0 as periodbegincostdiff,0.0 as periodbeginamount,actualcost_bal as periodendamount,standardcost_bal as periodendstandardcost,costdiff_bal as periodendcostdiff";
        }
        return select;
    }

    private static QFilter getBeginFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        return q;
    }

    private static QFilter getEndFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<=", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">", (Object)periodNumber));
        return q;
    }

    private static boolean isNewBalance() {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
    }

    public static Map<Object, DynamicObject> getCollByStartPeriodAndEndPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"ItoQueryPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        QFilter filter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
        filter.and(new QFilter("isadjustperiod", "=", (Object)"0"));
        filter.and("id", ">=", (Object)startPeriod.getLong("id"));
        filter.and("id", "<=", (Object)endPeriod.getLong("id"));
        Map period = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id,name,enddate", (QFilter[])new QFilter[]{filter});
        return period;
    }

    public static Map<String, DynamicObject> getQOQPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u73af\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        QFilter filter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
        filter.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        filter.and("id", ">=", (Object)startPeriod.getLong("id"));
        filter.and("id", "<=", (Object)endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{filter}, (String)"periodyear asc,periodnumber asc");
        int size = coll.size();
        Date startPeriodDate = startPeriod.getDate("begindate");
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqStartPeriodDateTime = startPeriodDateTime.minusMonths(size);
        Date startDate = Date.from(qoqStartPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter startFilter = new QFilter("begindate", "=", (Object)startDate);
        startFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject qoqStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{startFilter});
        Date endPeriodDate = endPeriod.getDate("begindate");
        LocalDateTime endPeriodDateTime = LocalDateTime.ofInstant(endPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqEndPeriodDateTime = endPeriodDateTime.minusMonths(size);
        Date endDate = Date.from(qoqEndPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter endFilter = new QFilter("begindate", "=", (Object)endDate);
        endFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject qoqEndPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"be_period", (QFilter[])new QFilter[]{endFilter});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        map.put("startPeriod", qoqStartPeriod);
        map.put("endPeriod", qoqEndPeriod);
        return map;
    }

    public static Map<String, DynamicObject> getYOYPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        Date startPeriodDate = startPeriod.getDate("begindate");
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqStartPeriodDateTime = startPeriodDateTime.minusYears(1L);
        Date startDate = Date.from(qoqStartPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter startFilter = new QFilter("begindate", "=", (Object)startDate);
        startFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject yoyStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{startFilter});
        Date endPeriodDate = endPeriod.getDate("begindate");
        LocalDateTime endPeriodDateTime = LocalDateTime.ofInstant(endPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqEndPeriodDateTime = endPeriodDateTime.minusYears(1L);
        Date endDate = Date.from(qoqEndPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter endFilter = new QFilter("begindate", "=", (Object)endDate);
        endFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject yoyEndPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{endFilter});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        map.put("startPeriod", yoyStartPeriod);
        map.put("endPeriod", yoyEndPeriod);
        return map;
    }

    public static DynamicObject getSixMonthAgoPeriod(DynamicObject currentPeriod) {
        DynamicObject periodType = currentPeriod.getDynamicObject("periodtype");
        Date currentPeriodDate = currentPeriod.getDate("begindate");
        LocalDateTime currentPeriodDateTime = LocalDateTime.ofInstant(currentPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime sixMonthAgoBeforeCurrent = currentPeriodDateTime.minusMonths(5L);
        Date date = Date.from(sixMonthAgoBeforeCurrent.atZone(ZoneId.systemDefault()).toInstant());
        QFilter qFilter = new QFilter("begindate", "=", (Object)date);
        qFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{qFilter});
        return period;
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,begindate,enddate,periodyear,periodnumber,periodtype";
        }
        QFilter f = new QFilter("begindate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObject getSysCtrlEntity(Long costAccountID) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.currentperiod.periodyear,entry.currentperiod.periodnumber,entry.startperiod.id,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            long recordCostAccountID = entryInfo.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }

    public static Set<Long> getCostAccountIdsByCalOrg(List<Long> calOrgIds) {
        QFilter q = new QFilter("calorg", "in", calOrgIds).and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
        if (costAccounts == null || costAccounts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> idset = new HashSet<Long>(16);
        HashMap<Long, Long> calorgCostAccountMap = new HashMap<Long, Long>(16);
        for (DynamicObject costAccount : costAccounts) {
            boolean ismainaccount = costAccount.getBoolean("ismainaccount");
            Long costAccountId = costAccount.getLong("id");
            Long calorgId = costAccount.getLong("calorg");
            if (ismainaccount) {
                calorgCostAccountMap.put(calorgId, costAccountId);
                continue;
            }
            if (calorgCostAccountMap.containsKey(calorgId)) continue;
            calorgCostAccountMap.put(calorgId, costAccountId);
        }
        for (Map.Entry mapEntry : calorgCostAccountMap.entrySet()) {
            idset.add((Long)mapEntry.getValue());
        }
        return idset;
    }
}

