/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.scmc.scmdi.marketpulse.business.service.CompanyInfosService;
import kd.scmc.scmdi.marketpulse.common.CompanyFilterCondition;
import kd.scmc.scmdi.marketpulse.common.CompanyInfo;
import kd.scmc.scmdi.marketpulse.common.PartnerInfo;
import kd.scmc.scmdi.marketpulse.common.enums.PartnerEnum;
import kd.scmc.scmdi.marketpulse.common.enums.RiskDataFetcherEnum;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyBusinessInfo;
import kd.scmc.scmdi.marketpulse.common.vo.info.CompanyHistoryNameInfo;
import org.apache.commons.lang3.StringUtils;

public class MarketPulseCardPlugin
extends AbstractFormPlugin
implements CountDownListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flexpanelap"});
        CountDown countDown = (CountDown)this.getView().getControl("countdownap");
        countDown.addCountDownListener((CountDownListener)this);
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("cached_counter", "0");
        ThreadPools.executeOnce((String)"load_data", this::startLoadData);
    }

    public void afterBindData(EventObject e) {
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.setDuration(1);
        countdown.start();
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"flexpanelap", (CharSequence)source.getKey())) {
            this.clickViewMore();
        } else if (StringUtils.equals((CharSequence)"cardentryflexpanelap", (CharSequence)source.getKey())) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.clickViewDetail(index);
        }
    }

    public void onCountDownEnd(CountDownEvent evt) {
        int entrySize = this.getModel().getEntryEntity("entryentity").size();
        List<CompanyInfo> companyInfoFromCache = this.getCompanyInfoFromCache();
        if (companyInfoFromCache.size() > entrySize) {
            for (int index = entrySize; index < companyInfoFromCache.size(); ++index) {
                this.createNewEntryAndAddNewData(companyInfoFromCache.get(index), index);
            }
            this.getView().updateView("entryentity");
        }
        this.restartCountDown();
        super.onCountDownEnd(evt);
    }

    private void restartCountDown() {
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        int entrySize = this.getModel().getEntryEntity("entryentity").size();
        int countDownTimes = Integer.parseInt(this.getPageCache().get("cached_counter"));
        if (countDownTimes < 300 && entrySize < 10) {
            this.getPageCache().put("cached_counter", String.valueOf(++countDownTimes));
            countdown.setDuration(1);
            countdown.start();
        } else {
            countdown.pause();
        }
    }

    private void createNewEntryAndAddNewData(CompanyInfo companyInfo, int index) {
        if (companyInfo == null) {
            return;
        }
        this.getModel().createNewEntryRow("entryentity");
        this.getModel().beginInit();
        String[] riskStatus = (String[])Arrays.stream(RiskDataFetcherEnum.values()).map(RiskDataFetcherEnum::getDataType).toArray(String[]::new);
        CompanyBusinessInfo businessInfo = companyInfo.getBusinessInfo();
        if (businessInfo != null) {
            this.getModel().setValue("company_id", (Object)businessInfo.getBusinessInfoItem().getCompanyId(), index);
            this.getModel().setValue("company_name", (Object)businessInfo.getBusinessInfoItem().getCompanyName(), index);
            this.getModel().setValue("credit_no", (Object)businessInfo.getBusinessInfoItem().getCreditNo(), index);
            String updateTime = businessInfo.getBusinessInfoItem().getUpdateTime();
            this.getModel().setValue("update_time", (Object)updateTime, index);
        }
        this.getModel().setValue("partner_type", (Object)companyInfo.getPartnerType(), index);
        this.getModel().setValue("company_status", (Object)companyInfo.getBusinessInfo().getBusinessInfoItem().getCompanyStatus(), index);
        CompanyHistoryNameInfo historyNameInfo = companyInfo.getHistoryNameInfo();
        boolean isPresentHistoryName = historyNameInfo != null && CollectionUtils.isNotEmpty((Collection)historyNameInfo.getBaseData());
        this.getModel().setValue("exsit_historyname", (Object)isPresentHistoryName, index);
        this.getView().getModel().setValue("risk_details", (Object)this.getRiskText(riskStatus, companyInfo), index);
        int riskTotalNumber = companyInfo.getRiskTotalNumber();
        this.getView().getModel().setValue("qty", (Object)riskTotalNumber, index);
        this.getView().getModel().setValue("datasource", (Object)companyInfo.getDataSource(), index);
        this.getView().getModel().endInit();
    }

    private String getRiskText(String[] status, CompanyInfo companyInfo) {
        StringBuilder riskTextBuilder = new StringBuilder("\u5176\u4e2d\uff1a");
        Arrays.stream(status).forEach(item -> companyInfo.getRiskInfos().stream().filter(riskInfo -> riskInfo.getDataType().equals(item) && !riskInfo.getBaseData().isEmpty()).findAny().ifPresent(riskInfo -> riskTextBuilder.append(riskInfo.getDataType()).append(String.format(ResManager.loadKDString((String)"%s\u6761", (String)"CompanyInfo_1", (String)"scmc-scmdi-marketpilse", (Object[])new Object[0]), riskInfo.getBaseData().size())).append(" | ")));
        return riskTextBuilder.substring(0, riskTextBuilder.length() - 3);
    }

    private void startLoadData() {
        CompanyFilterCondition companyFilterCondition = this.initCompanyFilterCondition();
        CompanyInfosService companyInfosService = new CompanyInfosService(companyFilterCondition);
        List partners = companyFilterCondition.getPartners();
        int sum = 0;
        for (int i = 0; sum < 10 && i < partners.size(); ++i) {
            CompanyInfo singleCompanyInfo = companyInfosService.getSingleCompanyInfos((PartnerInfo)partners.get(i));
            if (singleCompanyInfo == null || singleCompanyInfo.getRiskTotalNumber() <= 0) continue;
            try {
                this.cacheCompanyInfo(singleCompanyInfo);
                ++sum;
                continue;
            }
            catch (JsonProcessingException e) {
                throw new KDBizException("\u7f13\u5b58\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void cacheCompanyInfo(CompanyInfo companyInfo) throws JsonProcessingException {
        List<CompanyInfo> companyInfoList = this.getCompanyInfoFromCache();
        companyInfoList.add(companyInfo);
        this.getPageCache().put("cached_company_info", new ObjectMapper().writeValueAsString(companyInfoList));
    }

    private List<CompanyInfo> getCompanyInfoFromCache() {
        List<Object> companyInfoList;
        String cachedCompanyInfo = this.getPageCache().get("cached_company_info");
        if (cachedCompanyInfo == null || "".equals(cachedCompanyInfo)) {
            companyInfoList = new ArrayList<CompanyInfo>();
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, CompanyInfo.class);
            try {
                companyInfoList = (List)objectMapper.readValue(cachedCompanyInfo, (JavaType)type);
            }
            catch (JsonProcessingException e) {
                throw new KDBizException("\u83b7\u53d6\u4f01\u4e1a\u7f13\u5b58\u4fe1\u606f\u5931\u8d25");
            }
        }
        return companyInfoList;
    }

    private CompanyFilterCondition initCompanyFilterCondition() {
        String[] riskItems = (String[])Arrays.stream(RiskDataFetcherEnum.values()).map(RiskDataFetcherEnum::getDataType).toArray(String[]::new);
        List customersAndSuppliers = PartnerEnum.CustomAndSupplier.getPartnerInfosSupplier().getPartnerInfos();
        String[] partnerTypes = PartnerEnum.CustomAndSupplier.getPartnerTypes();
        CompanyFilterCondition companyFilterCondition = new CompanyFilterCondition();
        companyFilterCondition.setRiskItems(riskItems);
        companyFilterCondition.setPartners(customersAndSuppliers);
        companyFilterCondition.setPartnerTypes(partnerTypes);
        companyFilterCondition.setPageSize(10);
        companyFilterCondition.setStartIndex(0);
        companyFilterCondition.setPageNum(1);
        return companyFilterCondition;
    }

    private void clickViewMore() {
        String pageId = this.getPageCache().get("cached_page_id");
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            this.openMarketPulseList();
        } else {
            IFormView view = this.getView().getView(pageId);
            if (view == null) {
                this.openMarketPulseList();
            } else {
                view.activate();
                this.getView().sendFormAction(view);
            }
        }
    }

    private void openMarketPulseList() {
        String pageId = this.getNewPageId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scmdi_market_pulse_list");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setPageId(pageId);
        this.getView().showForm(formShowParameter);
    }

    private String getNewPageId() {
        String pageId = UUID.randomUUID().toString();
        this.getPageCache().put("cached_page_id", pageId);
        return pageId;
    }

    private void clickViewDetail(int index) {
        String companyId = (String)this.getModel().getValue("company_id", index);
        String businessInfoPageId = this.getBusinessInfoPageId(companyId);
        if (StringUtils.isEmpty((CharSequence)businessInfoPageId)) {
            this.openBusinessInfoDetailPage(index);
        } else {
            IFormView view = this.getView().getView(businessInfoPageId);
            if (view == null) {
                this.openBusinessInfoDetailPage(index);
            } else {
                view.activate();
                this.getView().sendFormAction(view);
            }
        }
    }

    private void openBusinessInfoDetailPage(int index) {
        String companyName = (String)this.getModel().getValue("company_name", index);
        String creditNo = (String)this.getModel().getValue("credit_no", index);
        String partnerType = (String)this.getModel().getValue("partner_type", index);
        String companyId = (String)this.getModel().getValue("company_id", index);
        String pageId = this.getNewBusinessInfoPageId(companyId);
        FormShowParameter detailShowParameter = new FormShowParameter();
        PartnerInfo partnerInfo = new PartnerInfo(companyName, partnerType, creditNo, companyId);
        detailShowParameter.setCustomParam("partnerInfo", (Object)partnerInfo);
        detailShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        detailShowParameter.setFormId("scmdi_businessinfo_detail");
        detailShowParameter.setCaption(companyName);
        detailShowParameter.setPageId(pageId);
        this.getView().showForm(detailShowParameter);
    }

    private String getNewBusinessInfoPageId(String companyId) {
        String pageId = UUID.randomUUID().toString();
        String busInfoStr = this.getPageCache().get("cached_bus_info_map");
        Map busInfoMap = StringUtils.isEmpty((CharSequence)busInfoStr) ? new HashMap(5) : (Map)JSON.parseObject((String)busInfoStr, Map.class);
        busInfoMap.put(companyId, pageId);
        this.getPageCache().put("cached_bus_info_map", JSON.toJSONString(busInfoMap));
        return pageId;
    }

    private String getBusinessInfoPageId(String companyId) {
        String result = "";
        String busInfoStr = this.getPageCache().get("cached_bus_info_map");
        if (StringUtils.isNotEmpty((CharSequence)busInfoStr)) {
            Map busInfoMap = (Map)JSON.parseObject((String)busInfoStr, Map.class);
            result = (String)busInfoMap.get(companyId);
        }
        return result;
    }
}

