/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.chart.PieChart;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.ChartBuilder;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.PieChartBuilder;
import kd.scmc.scmdi.form.plugin.form.operatecenter.tpl.ProcessTplCardPlugin;

public class OtcProcessCardPlugin
extends ProcessTplCardPlugin {
    private static final String SCMC = "SCMC";
    public static final String PUR = "PUR";
    private static final String SM_SALORDER_KEY = "sm_salorder_001";

    @Override
    protected QFilter getProcessDefineFilter() {
        List<Object> processCategory = this.getProcessCategoryFromScmc();
        List<Object> purCategory = OtcProcessCardPlugin.getPurCategory();
        processCategory.addAll(purCategory);
        return new QFilter("categoryid", "in", processCategory);
    }

    @Override
    protected void setDefaultProcess(DynamicObject[] processDefines) {
        Object pkValue = Arrays.stream(processDefines).filter(processDefine -> SM_SALORDER_KEY.equals(processDefine.getString("key"))).findAny().map(DataEntityBase::getPkValue).orElseGet(() -> processDefines[0].getPkValue());
        this.getModel().setValue("process", (Object)String.valueOf(pkValue));
    }

    @Override
    protected ChartBuilder<?> getChartBuilder() {
        PieChart itoChart = (PieChart)this.getControl("piechartap");
        return new PieChartBuilder(itoChart);
    }

    @Override
    public boolean isSetRateFieldStyle() {
        return false;
    }

    private List<Object> getProcessCategoryFromScmc() {
        QFilter scmcFilter = new QFilter("number", "=", (Object)SCMC);
        DynamicObject scmcCategory = QueryServiceHelper.queryOne((String)"wf_processcagetory", (String)"id", (QFilter[])new QFilter[]{scmcFilter});
        if (scmcCategory == null || scmcCategory.get("id") == null) {
            return new ArrayList<Object>(0);
        }
        Long scmcAppId = scmcCategory.getLong("id");
        QFilter appIdFilter = new QFilter("id", "=", (Object)scmcAppId);
        appIdFilter.or("parentid", "=", (Object)scmcAppId);
        Map appIdColl = BusinessDataServiceHelper.loadFromCache((String)"wf_processcagetory", (String)"id,number", (QFilter[])new QFilter[]{appIdFilter});
        DynamicObject[] dynamicObjects = appIdColl.values().toArray(new DynamicObject[0]);
        return Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    private static List<Object> getPurCategory() {
        QFilter scmcFilter = new QFilter("number", "=", (Object)PUR);
        DynamicObject scmcCategory = QueryServiceHelper.queryOne((String)"wf_processcagetory", (String)"id", (QFilter[])new QFilter[]{scmcFilter});
        if (scmcCategory == null || scmcCategory.get("id") == null) {
            return new ArrayList<Object>(0);
        }
        Long purAppId = scmcCategory.getLong("id");
        QFilter appIdFilter = new QFilter("id", "=", (Object)purAppId);
        appIdFilter.or("parentid", "=", (Object)purAppId);
        Map appIdColl = BusinessDataServiceHelper.loadFromCache((String)"wf_processcagetory", (String)"id,number", (QFilter[])new QFilter[]{appIdFilter});
        DynamicObject[] dynamicObjects = appIdColl.values().toArray(new DynamicObject[0]);
        return Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }
}

