/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.HomePageOrgHelper;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.common.pojo.DataCardInfo;
import kd.scmc.scmdi.common.pojo.SingleDataCardInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;
import kd.scmc.scmdi.form.plugin.form.operatecenter.tpl.DataCardTplPlugin;

public class PurDataCardPlugin
extends DataCardTplPlugin {
    private static final String PUR_OPERATION_CENTER_MENU_ID = "1995754974059284480";
    public static final String FLEXPANELAP = "flexpanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FLEXPANELAP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (FLEXPANELAP.equals(source.getKey())) {
            AppInfo scmoc = AppMetadataCache.getAppInfoByNumber((String)"scmoc");
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)PUR_OPERATION_CENTER_MENU_ID, (String)scmoc.getId());
        }
    }

    @Override
    protected DataCardInfo getDigitalCardInfo() {
        List purOrg = HomePageOrgHelper.getPurOrgByUserPermission();
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        Date yoyEndDate = HomePageDateUtils.getYearAgoByDate((Date)endDate);
        Date yoyStartDate = HomePageDateUtils.getYearAgoByDate((Date)startDate);
        Date qoqEndDate = HomePageDateUtils.getSixMonthAgoByDate((Date)HomePageDateUtils.getYesterdayByDate((Date)endDate));
        Date qoqStartDate = HomePageDateUtils.getSixMonthAgoByDate((Date)HomePageDateUtils.getYesterdayByDate((Date)startDate));
        SingleDataCardInfo nowDataInfo = this.getSingleDataInfo(purOrg, startDate, endDate);
        SingleDataCardInfo yoyDataInfo = this.getSingleDataInfo(purOrg, yoyStartDate, yoyEndDate);
        SingleDataCardInfo qoqDataInfo = this.getSingleDataInfo(purOrg, qoqStartDate, qoqEndDate);
        DataCardInfo dataCardInfo = new DataCardInfo();
        BigDecimal purAmount = nowDataInfo.getFirstData();
        BigDecimal newSupplier = nowDataInfo.getSecondData();
        BigDecimal timelyReceipt = nowDataInfo.getThirdData();
        if (purAmount != null && newSupplier != null && timelyReceipt != null) {
            dataCardInfo.setFirstData(purAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
            dataCardInfo.setSecondData(newSupplier);
            dataCardInfo.setThirdData(timelyReceipt);
            BigDecimal yoySaleAmount = this.getRate(purAmount, yoyDataInfo.getFirstData());
            BigDecimal yoyNewCustom = this.getRate(newSupplier, yoyDataInfo.getSecondData());
            BigDecimal yoyReceiptAmount = this.getRate(timelyReceipt, yoyDataInfo.getThirdData());
            dataCardInfo.setFirstDataYoy(yoySaleAmount);
            dataCardInfo.setSecondDataYoy(yoyNewCustom);
            dataCardInfo.setThirdDataYoy(yoyReceiptAmount);
            BigDecimal qoqSaleAmount = this.getRate(purAmount, qoqDataInfo.getFirstData());
            BigDecimal qoqNewCustom = this.getRate(newSupplier, qoqDataInfo.getSecondData());
            BigDecimal qoqReceiptAmount = this.getRate(timelyReceipt, qoqDataInfo.getThirdData());
            dataCardInfo.setFirstDataQoq(qoqSaleAmount);
            dataCardInfo.setSecondDataQoq(qoqNewCustom);
            dataCardInfo.setThirdDataQoq(qoqReceiptAmount);
        }
        return dataCardInfo;
    }

    private BigDecimal getRate(BigDecimal currentData, BigDecimal lastData) {
        if (lastData == null || lastData.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal rate = currentData.subtract(lastData).divide(lastData, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        return rate;
    }

    private SingleDataCardInfo getSingleDataInfo(List<Long> orgId, Date startDate, Date endDate) {
        BigDecimal totalAmount = this.getTotalAmount(orgId, startDate, endDate);
        BigDecimal newSupplierNum = this.getNewSupplierNum(orgId, startDate, endDate);
        BigDecimal timelyReceiptRate = this.getTimelyReceiptRate(orgId, startDate, endDate);
        SingleDataCardInfo singleDataCardInfo = new SingleDataCardInfo();
        singleDataCardInfo.setFirstData(totalAmount);
        singleDataCardInfo.setSecondData(newSupplierNum);
        singleDataCardInfo.setThirdData(timelyReceiptRate);
        return singleDataCardInfo;
    }

    private BigDecimal getTotalAmount(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = this.getFilter(orgId, startDate, endDate);
        DataSet totalAmountData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"billentry.curamountandtax", (QFilter[])new QFilter[]{qFilter}, null).groupBy().sum("billentry.curamountandtax").finish();
        BigDecimal totalAmount = null;
        if (totalAmountData.hasNext()) {
            Row row = totalAmountData.next();
            totalAmount = row.getBigDecimal("billentry.curamountandtax");
        }
        return totalAmount;
    }

    private QFilter getFilter(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)BigDecimal.ZERO));
        return qFilter;
    }

    private BigDecimal getNewSupplierNum(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("createorg", "in", orgId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
        int count = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_supplier", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null).count("id", false);
        return new BigDecimal(count);
    }

    private BigDecimal getTimelyReceiptRate(List<Long> orgIds, Date startDate, Date endDate) {
        DataSet timelyReceiptRateData = PurInfoCalculateHelper.getTimelyReceiptRateData(orgIds, (Date)startDate, (Date)endDate);
        BigDecimal expireNum = BigDecimal.ZERO;
        BigDecimal onTimeNum = BigDecimal.ZERO;
        BigDecimal timelyReceiptRate = new BigDecimal("0.00");
        while (timelyReceiptRateData.hasNext()) {
            Row row = timelyReceiptRateData.next();
            expireNum = expireNum.add(row.getBigDecimal("expireordernum"));
            onTimeNum = onTimeNum.add(row.getBigDecimal("ontimenum"));
        }
        if (BigDecimal.ZERO.compareTo(expireNum) != 0) {
            timelyReceiptRate = onTimeNum.multiply(new BigDecimal("100")).divide(expireNum, 2, RoundingMode.HALF_UP);
        }
        return timelyReceiptRate;
    }
}

