/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.util.OpenPageUtils;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.common.enumeration.AbcMaterialInfoEnum;
import kd.scmc.scmdi.common.pojo.AbcAnalysisInfo;

public class PurMaterialAbcCardPlugin
extends AbstractFormPlugin {
    private static final String PUR_OPERATION_CENTER_MENU_ID = "1995754974059284480";
    public static final String FLEXPANELAP = "flexpanelap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildChart();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FLEXPANELAP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (FLEXPANELAP.equals(source.getKey())) {
            AppInfo scmoc = AppMetadataCache.getAppInfoByNumber((String)"scmoc");
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)PUR_OPERATION_CENTER_MENU_ID, (String)scmoc.getId());
        }
    }

    private void buildChart() {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setMargin(Position.top, "30px");
        pieChart.setMargin(Position.bottom, "0px");
        pieChart.setMargin(Position.left, "0px");
        pieChart.setMargin(Position.right, "0px");
        String name = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u91d1\u989d%1$s\u5360\u6bd4", (String)"PurSupplierAbcCardPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), "\n");
        pieChart.setName(new LocaleString(name));
        HashMap<String, Object> titleStyle = new HashMap<String, Object>(2);
        titleStyle.put("color", "#333333");
        titleStyle.put("fontSize", 12);
        pieChart.setTitlePropValue("textStyle", titleStyle);
        pieChart.setLegendPropValue("right", (Object)0);
        pieChart.setLegendPropValue("top", (Object)"middle");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.addTooltip("show", (Object)false);
        pieChart.setTitlePropValue("left", (Object)"center");
        pieChart.setTitlePropValue("top", (Object)"center");
        PieSeries series = pieChart.createSeries("");
        Label label = new Label();
        label.setShow(false);
        series.setLabel(label);
        series.setRadius("50%", "70%");
        series.setCenter("50%", "50%");
        this.setData(series);
    }

    protected void setData(PieSeries series) {
        Arrays.stream(AbcMaterialInfoEnum.values()).forEach(info -> this.getView().setVisible(Boolean.valueOf(false), new String[]{info.getFieldLabel()}));
        List abcAnalysisInfos = PurInfoCalculateHelper.queryMaterialABCAnalysisData();
        BigDecimal allAmount = abcAnalysisInfos.stream().map(AbcAnalysisInfo::getAmount).reduce(BigDecimal::add).orElseGet(() -> new BigDecimal(0));
        if (allAmount.equals(new BigDecimal(0))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"data_label_flex"});
            return;
        }
        for (AbcMaterialInfoEnum info2 : AbcMaterialInfoEnum.values()) {
            Optional<BigDecimal> amountOp = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info2.getValue())).map(AbcAnalysisInfo::getAmount).reduce(BigDecimal::add);
            amountOp.ifPresent(amount -> {
                String percentage = amount.divide(allAmount, 10, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                BigDecimal unitAmount = amount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
                series.addData(info2.getName(), (Number)unitAmount);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{info2.getFieldLabel()});
                kd.bos.form.control.Label rateLabel = (kd.bos.form.control.Label)this.getControl(info2.getRateLabel());
                rateLabel.setText("\uff1a" + percentage + "%");
                kd.bos.form.control.Label amoutLabel = (kd.bos.form.control.Label)this.getControl(info2.getAmountLabel());
                amoutLabel.setText(unitAmount + "\u4e07\u5143");
            });
        }
    }
}

