/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.HomePageOrgHelper;
import kd.scmc.scmdi.common.pojo.SaleAmountInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;

public class SaleCombinationCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildChart();
    }

    private void buildChart() {
        CustomChart saleDataChart = (CustomChart)this.getControl("sale_data_chart");
        saleDataChart.clearData();
        saleDataChart.setMargin(Position.top, "30px");
        saleDataChart.setMargin(Position.left, "15px");
        saleDataChart.setMargin(Position.bottom, "0px");
        this.buildChartData(saleDataChart);
        saleDataChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        saleDataChart.addTooltip("axisPointer", axisPointType);
        saleDataChart.setShowTooltip(true);
    }

    private void buildChartData(CustomChart saleDataChart) {
        List<SaleAmountInfo> saleData = this.querySaleData();
        this.buildAxis(saleDataChart, saleData);
        this.buildSalesHistogram(saleDataChart, saleData);
        this.buildRcvHistogram(saleDataChart, saleData);
        this.buildRcvPercentLine(saleDataChart, saleData);
    }

    private void buildAxis(CustomChart saleDataChart, List<SaleAmountInfo> saleData) {
        String[] category = (String[])saleData.stream().map(SaleAmountInfo::getMonth).toArray(String[]::new);
        Axis xAxis = saleDataChart.createXAxis("", AxisType.category);
        xAxis.setCategorys(category);
    }

    private void buildSalesHistogram(CustomChart saleDataChart, List<SaleAmountInfo> saleData) {
        saleDataChart.createYAxis("\u4e07\u5143", AxisType.value);
        BarSeries salesBarSeries = saleDataChart.createBarSeries("\u9500\u552e\u91d1\u989d");
        salesBarSeries.setBarWidth("8px");
        Label label = new Label();
        label.setShow(false);
        salesBarSeries.setLabel(label);
        salesBarSeries.setData((Number[])saleData.stream().map(SaleAmountInfo::getCurTotalAllAmount).toArray(BigDecimal[]::new));
    }

    private void buildRcvHistogram(CustomChart saleDataChart, List<SaleAmountInfo> saleData) {
        BarSeries rcvBarSeries = saleDataChart.createBarSeries("\u6536\u6b3e\u91d1\u989d");
        rcvBarSeries.setBarWidth("8px");
        Label label = new Label();
        label.setShow(false);
        rcvBarSeries.setLabel(label);
        rcvBarSeries.setData((Number[])saleData.stream().map(SaleAmountInfo::getReceiptAllAmount).toArray(BigDecimal[]::new));
    }

    private void buildRcvPercentLine(CustomChart saleDataChart, List<SaleAmountInfo> saleData) {
        saleDataChart.createYAxis("%", AxisType.value);
        LineSeries rcvPercentLineSeries = saleDataChart.createLineSeries("\u6536\u73b0\u7387");
        rcvPercentLineSeries.setYAxisIndex(1);
        rcvPercentLineSeries.setData((Number[])saleData.stream().map(SaleAmountInfo::getReceiptPercent).toArray(BigDecimal[]::new));
    }

    private QFilter[] getSaleAmountFilter(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        qFilter.and(new QFilter("exchangerate", "!=", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        return new QFilter[]{qFilter};
    }

    private List<SaleAmountInfo> querySaleData() {
        List orgId = HomePageOrgHelper.getSaleOrgByUserPermission();
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getFirstDayOfFiveMonth((Date)dayStartTime);
        QFilter[] saleAmountFilter = this.getSaleAmountFilter(orgId, startDate, endDate);
        List yearMonthBetween = HomePageDateUtils.getYearMonthBetween((Date)startDate, (Date)endDate);
        String saleAmountField = SaleCombinationCardPlugin.getSaleAmountField();
        DataSet saleOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)saleAmountField, (QFilter[])saleAmountFilter, null);
        DataSet finish = saleOrder.select("orgname,currency,bizdate,to_char(bizdate,'yyyy-MM') as month,curtotalallamount,receiptallamount").groupBy(new String[]{"month"}).sum("curtotalallamount").sum("receiptallamount").finish();
        HashMap<String, SaleAmountInfo> map = new HashMap<String, SaleAmountInfo>(6);
        while (finish.hasNext()) {
            Row row = finish.next();
            SaleAmountInfo saleAmountInfo = new SaleAmountInfo();
            saleAmountInfo.setMonth(row.getString("month"));
            BigDecimal curTotalAllAmount = row.getBigDecimal("curtotalallamount").divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
            BigDecimal receiptAllAmount = row.getBigDecimal("receiptallamount").divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
            saleAmountInfo.setCurTotalAllAmount(curTotalAllAmount);
            saleAmountInfo.setReceiptAllAmount(receiptAllAmount);
            if (curTotalAllAmount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal receiptPercent = receiptAllAmount.divide(curTotalAllAmount, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                saleAmountInfo.setReceiptPercent(receiptPercent);
            }
            map.put(row.getString("month"), saleAmountInfo);
        }
        ArrayList<SaleAmountInfo> list = new ArrayList<SaleAmountInfo>(6);
        for (String yearMonth : yearMonthBetween) {
            SaleAmountInfo saleAmountInfo = new SaleAmountInfo();
            saleAmountInfo.setMonth(yearMonth);
            if (map.get(yearMonth) != null) {
                SaleAmountInfo queryInfo = (SaleAmountInfo)map.get(yearMonth);
                saleAmountInfo.setCurTotalAllAmount(queryInfo.getCurTotalAllAmount());
                saleAmountInfo.setReceiptAllAmount(queryInfo.getReceiptAllAmount());
                saleAmountInfo.setReceiptPercent(queryInfo.getReceiptPercent());
            }
            list.add(saleAmountInfo);
        }
        return list;
    }

    private static String getSaleAmountField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org.name as orgname");
        selectFields.add("currency");
        selectFields.add("bizdate");
        selectFields.add("curtotalallamount");
        selectFields.add("receiptamount * exchangerate as receiptallamount");
        return String.join((CharSequence)",", selectFields);
    }
}

