/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.HomePageOrgHelper;
import kd.scmc.scmdi.common.pojo.DataCardInfo;
import kd.scmc.scmdi.common.pojo.SingleDataCardInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;
import kd.scmc.scmdi.form.plugin.form.operatecenter.tpl.DataCardTplPlugin;

public class SaleDataCardPlugin
extends DataCardTplPlugin {
    @Override
    protected DataCardInfo getDigitalCardInfo() {
        List orgId = HomePageOrgHelper.getSaleOrgByUserPermission();
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getFirstDayOfFiveMonth((Date)dayStartTime);
        Date yoyEndDate = HomePageDateUtils.getYearAgoByDate((Date)endDate);
        Date yoyStartDate = HomePageDateUtils.getYearAgoByDate((Date)startDate);
        Date yesterdayByDate = HomePageDateUtils.getYesterdayByDate((Date)startDate);
        Date qoqEndDate = HomePageDateUtils.getDayEndTime((Date)yesterdayByDate);
        Date qoqStartDate = HomePageDateUtils.getSixMonthAgoByDate((Date)startDate);
        SingleDataCardInfo nowDataInfo = this.getSingleDataInfo(orgId, startDate, endDate);
        SingleDataCardInfo yoyDataInfo = this.getSingleDataInfo(orgId, yoyStartDate, yoyEndDate);
        SingleDataCardInfo qoqDataInfo = this.getSingleDataInfo(orgId, qoqStartDate, qoqEndDate);
        DataCardInfo dataCardInfo = new DataCardInfo();
        BigDecimal saleAmount = nowDataInfo.getFirstData();
        BigDecimal newCustom = nowDataInfo.getSecondData();
        BigDecimal receiptAmount = nowDataInfo.getThirdData();
        if (saleAmount != null && newCustom != null && receiptAmount != null) {
            saleAmount = saleAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
            receiptAmount = receiptAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
            dataCardInfo.setFirstData(saleAmount);
            dataCardInfo.setSecondData(newCustom);
            dataCardInfo.setThirdData(receiptAmount);
            BigDecimal saleAmountYoy = yoyDataInfo.getFirstData();
            BigDecimal receiptAmountYoy = yoyDataInfo.getThirdData();
            if (saleAmountYoy != null && receiptAmountYoy != null) {
                BigDecimal yoySaleAmount = this.getRate(saleAmount, saleAmountYoy.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
                BigDecimal yoyReceiptAmount = this.getRate(receiptAmount, receiptAmountYoy.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
                dataCardInfo.setFirstDataYoy(yoySaleAmount);
                dataCardInfo.setThirdDataYoy(yoyReceiptAmount);
            }
            BigDecimal yoyNewCustom = this.getRate(newCustom, yoyDataInfo.getSecondData());
            dataCardInfo.setSecondDataYoy(yoyNewCustom);
            BigDecimal saleAmountQoq = yoyDataInfo.getFirstData();
            BigDecimal receiptAmountQoq = yoyDataInfo.getThirdData();
            if (saleAmountQoq != null && receiptAmountQoq != null) {
                BigDecimal qoqSaleAmount = this.getRate(saleAmount, saleAmountQoq.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
                BigDecimal qoqReceiptAmount = this.getRate(receiptAmount, receiptAmountQoq.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP));
                dataCardInfo.setFirstDataQoq(qoqSaleAmount);
                dataCardInfo.setThirdDataQoq(qoqReceiptAmount);
            }
            BigDecimal qoqNewCustom = this.getRate(newCustom, qoqDataInfo.getSecondData());
            dataCardInfo.setSecondDataQoq(qoqNewCustom);
        }
        return dataCardInfo;
    }

    private BigDecimal getRate(BigDecimal currentData, BigDecimal lastData) {
        if (lastData == null || lastData.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal rate = currentData.subtract(lastData).divide(lastData, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        return rate;
    }

    private SingleDataCardInfo getSingleDataInfo(List<Long> orgId, Date startDate, Date endDate) {
        QFilter[] qFilter = this.getSaleAmountFilter(orgId, startDate, endDate);
        DataSet saleOrder = this.queryData(SaleDataCardPlugin.getSaleAmountField(), qFilter);
        SingleDataCardInfo singleDataCardInfo = new SingleDataCardInfo();
        if (saleOrder.hasNext()) {
            Row next = saleOrder.next();
            BigDecimal curTotalAllAmount = next.getBigDecimal("curtotalallamount");
            BigDecimal receiptAllAmount = next.getBigDecimal("receiptallamount");
            singleDataCardInfo.setFirstData(curTotalAllAmount);
            singleDataCardInfo.setThirdData(receiptAllAmount);
        }
        saleOrder.close();
        int newCustomer = this.getNewCustomer(orgId, startDate, endDate);
        singleDataCardInfo.setSecondData(new BigDecimal(newCustomer));
        return singleDataCardInfo;
    }

    private QFilter[] getSaleAmountFilter(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        qFilter.and(new QFilter("exchangerate", "!=", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        return new QFilter[]{qFilter};
    }

    private DataSet queryData(String queryFieldKey, QFilter[] qFilters) {
        DataSet saleOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)queryFieldKey, (QFilter[])qFilters, null);
        DataSet dataSet = saleOrder.groupBy().sum("curtotalallamount").sum("receiptallamount").finish();
        return dataSet;
    }

    private static String getSaleAmountField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org.name as orgname");
        selectFields.add("currency");
        selectFields.add("curtotalallamount");
        selectFields.add("receiptamount * exchangerate as receiptallamount");
        return String.join((CharSequence)",", selectFields);
    }

    public int getNewCustomer(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("createorg", "in", orgId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
        DataSet newCustomer = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null);
        int count = newCustomer.count("id", false);
        return count;
    }
}

