/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.common.enumeration.WarningLevelColorEnum;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;

public class WarnResultCardPlugin
extends AbstractFormPlugin {
    private static final String WARN_HANDLE = "1803595872269874176";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flexpanelap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildCardEntry();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("flexpanelap".equals(source.getKey())) {
            AppInfo scmoc = AppMetadataCache.getAppInfoByNumber((String)"scmoc");
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)WARN_HANDLE, (String)scmoc.getId());
        }
    }

    private void buildCardEntry() {
        DynamicObject[] warningResult = this.getWarningResult();
        if (warningResult.length > 0) {
            this.entryEntitySetValue(warningResult);
            this.warningLevelSetColor();
            this.getView().updateView("entryentity");
        }
    }

    private void entryEntitySetValue(DynamicObject[] warningResultArr) {
        DynamicObjectType entryType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject warningResult : warningResultArr) {
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("warningtitle", (Object)warningResult.getString("warning_title"));
            DynamicObject warnConfig = warningResult.getDynamicObject("warning_config");
            if (warnConfig != null) {
                entryObj.set("warningconfigname", (Object)warnConfig.getString("name"));
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"warningconfigname"});
            }
            entryObj.set("warninglevel", (Object)WarningLevelColorEnum.getTitle((String)warningResult.getString("warninglevel")));
            entryObj.set("warningcontent", (Object)warningResult.getString("warning_content"));
            entryObj.set("createtime", (Object)warningResult.getDate("createtime"));
            entryColl.add((Object)entryObj);
        }
    }

    private void warningLevelSetColor() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            if (entry == null || entry.getString("warninglevel") == null) continue;
            Map customProperties = WarningLevelColorEnum.getCustomProperties((String)entry.getString("warninglevel"));
            HashMap<String, Map> props = new HashMap<String, Map>(1);
            props.put("warninglevel", customProperties);
            cardEntry.setCustomProperties("warninglevel", i, props);
        }
    }

    private DynamicObject[] getWarningResult() {
        String untreated = "0";
        QFilter dataFilter = new QFilter("processingstatus", "=", (Object)untreated);
        dataFilter.and(this.getDateFilter());
        Map warningResultMap = BusinessDataServiceHelper.loadFromCache((String)"scmdi_warnresult_invqty", (String)"warning_title,warning_config,warninglevel,warning_content,createtime,", (QFilter[])new QFilter[]{dataFilter}, (String)"warninglevel desc,createtime,warning_config.number,warning_title,warning_content");
        DynamicObject[] warningResult = warningResultMap.values().toArray(new DynamicObject[0]);
        return warningResult;
    }

    private QFilter getDateFilter() {
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        QFilter qFilter = new QFilter("createtime", ">=", (Object)startDate);
        qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
        return qFilter;
    }
}

