/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.ChartBuilder;

public class HistogramChartBuilder
extends ChartBuilder<HistogramChart> {
    public HistogramChartBuilder(HistogramChart chart) {
        super(chart);
    }

    @Override
    public void build(ItemValue[] itemValues) {
        this.buildBarChart(itemValues);
    }

    protected void buildBarChart(ItemValue[] itemValues) {
        ((HistogramChart)this.chart).clearData();
        if (itemValues.length == 0) {
            ((HistogramChart)this.chart).refresh();
            return;
        }
        List<String> nameColl = Arrays.stream(itemValues).map(ItemValue::getName).collect(Collectors.toList());
        this.buildXAxisByNumChart((HistogramChart)this.chart, nameColl);
        this.buildYAxisByNumChart((HistogramChart)this.chart);
        ((HistogramChart)this.chart).setMargin(Position.top, "15%");
        ((HistogramChart)this.chart).setMargin(Position.right, "5%");
        ((HistogramChart)this.chart).addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        ((HistogramChart)this.chart).addTooltip("axisPointer", axisPointType);
        ((HistogramChart)this.chart).addTooltip("formatter", (Object)"{b}\uff1a{c}\u5c0f\u65f6");
        ((HistogramChart)this.chart).setShowTooltip(true);
        BarSeries barSeries = ((HistogramChart)this.chart).createSeries("");
        Arrays.stream(itemValues).forEach(arg_0 -> ((BarSeries)barSeries).addData(arg_0));
        barSeries.setBarWidth("10");
        barSeries.setPropValue("barMaxWidth", (Object)"30");
        int[] radius = new int[]{0, 20, 20, 0};
        HashMap<String, Object> itemStyle = new HashMap<String, Object>(3);
        itemStyle.put("borderRadius", radius);
        HashMap<String, String> colorMap = new HashMap<String, String>(1);
        colorMap.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{ \"offset\": 0, \"color\": '#6CAAFF' },\n{ \"offset\": 1, \"color\": '#1890FF' }])");
        itemStyle.put("normal", colorMap);
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setPropValue("itemStyle", itemStyle);
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
        ((HistogramChart)this.chart).refresh();
    }

    protected void buildYAxisByNumChart(HistogramChart histogramChart) {
        String unitName = ResManager.loadKDString((String)"\u5355\u636e\u8282\u70b9\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09", (String)"HistogramChartBuilder_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        Axis yAxis = histogramChart.createYAxis(unitName, AxisType.value);
        HashMap<String, String> nameTextStyle = new HashMap<String, String>(2);
        nameTextStyle.put("color", "#999999");
        nameTextStyle.put("fontSize", "10");
        nameTextStyle.put("align", "left");
        yAxis.setPropValue("nameTextStyle", nameTextStyle);
        yAxis.setPropValue("show", (Object)Boolean.TRUE);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisLine", axisShowMap);
        yAxis.setPropValue("axisTick", axisShowMap);
        LinkedHashMap<String, Object> axisLabelMap = new LinkedHashMap<String, Object>(3);
        axisLabelMap.put("fontSize", 12);
        axisLabelMap.put("color", "#999999");
        axisLabelMap.put("interval", "0");
        yAxis.setPropValue("axisLabel", axisLabelMap);
    }

    protected void buildXAxisByNumChart(HistogramChart histogramChart, List<String> nameColl) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        xAxis.setCategorys(nameColl.toArray(new String[0]));
        xAxis.setPropValue("splitNumber", (Object)3);
    }
}

