/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.ChartBuilder;

public class PieChartBuilder
extends ChartBuilder<PieChart> {
    public PieChartBuilder(PieChart chart) {
        super(chart);
    }

    @Override
    public void build(ItemValue[] itemValues) {
        this.setPieChartColor(itemValues);
        this.buildPieChart(itemValues);
    }

    private void setPieChartColor(ItemValue[] itemValues) {
        List<String> colorList = this.getColorList();
        for (int i = 0; i < itemValues.length; ++i) {
            String color = i >= 5 ? colorList.get(i % 6) : colorList.get(i);
            itemValues[i].setColor(color);
        }
    }

    private void buildPieChart(ItemValue[] itemValues) {
        ((PieChart)this.chart).clearData();
        if (itemValues.length == 0) {
            ((PieChart)this.chart).refresh();
            return;
        }
        PieSeries pieSeries = ((PieChart)this.chart).createPieSeries("");
        pieSeries.setData(itemValues);
        pieSeries.setRadius("60%", "80%");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        pieSeries.setPropValue("right", (Object)"5%");
        ((PieChart)this.chart).addTooltip("trigger", (Object)"item");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        ((PieChart)this.chart).addTooltip("axisPointer", axisPointType);
        ((PieChart)this.chart).setShowTooltip(true);
        ((PieChart)this.chart).addTooltip("formatter", (Object)"{b}:{d}% ");
        ((PieChart)this.chart).setLegendPropValue("right", (Object)0);
        ((PieChart)this.chart).setLegendPropValue("top", (Object)"center");
        ((PieChart)this.chart).setLegendVertical(true);
        ((PieChart)this.chart).setShowLegend(true);
        ((PieChart)this.chart).setLegendPropValue("icon", (Object)"circle");
        ((PieChart)this.chart).setName(new LocaleString(ResManager.loadKDString((String)"\u8017\u65f6\u5360\u6bd4", (String)"PieChartBuilder_0", (String)"scmc-scmdi-form", (Object[])new Object[0])));
        ((PieChart)this.chart).setTitlePropValue("left", (Object)"41%");
        ((PieChart)this.chart).setTitlePropValue("top", (Object)"center");
        ((PieChart)this.chart).refresh();
    }

    private List<String> getColorList() {
        ArrayList<String> labelColorList = new ArrayList<String>(6);
        labelColorList.add("#40A9FF");
        labelColorList.add("#45DAD1");
        labelColorList.add("#73D13D");
        labelColorList.add("#FFC53D");
        labelColorList.add("#F57582");
        labelColorList.add("#9F69E2");
        return labelColorList;
    }
}

